// -*- C++ -*- 
/*
** Copyright (C) 2000 Alan McIvor <alan@mcivor.gen.nz>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#ifndef PROJECTEXCEPTIONS_H
#define PROJECTEXCEPTIONS_H

#include <string>
using namespace std;

#include "openschedException.h"

class ProjectException
  : public OpenschedException
{
public:
    ProjectException( string reason );
    ~ProjectException();
};


class TASKException
  : public ProjectException
{
public:
    TASKException( string id, string reason );
    ~TASKException();
    virtual string which() const;

private:
    string mId;
};


class RESOURCEException
    : public ProjectException
{
public:
    RESOURCEException( string id, string reason );
    ~RESOURCEException();
    virtual string which() const;

private:
    string mId;
};


#endif
