;;;-*- Mode: Lisp; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of OpenMCL.  
;;;
;;;   OpenMCL is licensed under the terms of the Lisp Lesser GNU Public
;;;   License , known as the LLGPL and distributed with OpenMCL as the
;;;   file "LICENSE".  The LLGPL consists of a preamble and the LGPL,
;;;   which is distributed with OpenMCL as the file "LGPL".  Where these
;;;   conflict, the preamble takes precedence.  
;;;
;;;   OpenMCL is referenced in the preamble as the "LIBRARY."
;;;
;;;   The LLGPL is also available online at
;;;   http://opensource.franz.com/preamble.html

(in-package "CCL")

(defstruct subprimitive-info
  name
  offset
  nailed-down
  argument-mask
  registers-used
  )

(defmethod make-load-form ((s subprimitive-info) &optional env)
  (make-load-form-saving-slots s :environment env))

(defmethod print-object ((s subprimitive-info) stream)
  (print-unreadable-object (s stream :type t)
    (format stream "~A @ #x~x" 
            (subprimitive-info-name s)
            (subprimitive-info-offset s))))

(eval-when (:compile-toplevel :load-toplevel :execute)
(defparameter *subprims-shift* 2)
(defparameter *next-subprim-offset* (ash 1 14) )
)

; For now, nothing's nailed down and we don't say anything about
; registers clobbered.
(macrolet ((defppcsubprim (name)
	       (let* ((offset *next-subprim-offset*)
		      (info (make-subprimitive-info :name name
						    :offset offset)))
		 (incf *next-subprim-offset* 4)
		 `(progn
		   (undefine-constant ',name)
		   (defconstant ,name ,offset)
		   ,info))))
  (setq *next-subprim-offset* (ash 1 14))
  (defparameter *subprims*
    (vector
     (defppcsubprim .SPjmpsym)
     (defppcsubprim .SPjmpnfn)
     (defppcsubprim .SPfuncall)
     (defppcsubprim .SPmkcatch1v)
     (defppcsubprim .SPmkunwind)
     (defppcsubprim .SPmkcatchmv)
     (defppcsubprim .SPthrow)
     (defppcsubprim .SPnthrowvalues)
     (defppcsubprim .SPnthrow1value)
     (defppcsubprim .SPOLDbind)
     (defppcsubprim .SPOLDbind-self)
     (defppcsubprim .SPOLDbind-nil)
     (defppcsubprim .SPOLDunbind)
     (defppcsubprim .SPOLDunbind-n)
     (defppcsubprim .SPOLDunbind-to)
     (defppcsubprim .SPconslist)
     (defppcsubprim .SPconslist-star)
     (defppcsubprim .SPstkconslist)
     (defppcsubprim .SPstkconslist-star)
     (defppcsubprim .SPmkstackv)
     (defppcsubprim .SPsubtag-misc-ref)
     (defppcsubprim .SPnewblocktag)
     (defppcsubprim .SPnewgotag)
     (defppcsubprim .SPstack-misc-alloc)
     (defppcsubprim .SPgvector)
     (defppcsubprim .SPnvalret)
     (defppcsubprim .SPmvpass)
     (defppcsubprim .SPfitvals)
     (defppcsubprim .SPnthvalue)
     (defppcsubprim .SPvalues)
     (defppcsubprim .SPdefault-optional-args)
     (defppcsubprim .SPopt-supplied-p)
     (defppcsubprim .SPheap-rest-arg)
     (defppcsubprim .SPreq-heap-rest-arg)
     (defppcsubprim .SPheap-cons-rest-arg)
     (defppcsubprim .SPsimple-keywords)
     (defppcsubprim .SPkeyword-args)
     (defppcsubprim .SPkeyword-bind)
     (defppcsubprim .SPffcall)
     (defppcsubprim .SPffcalladdress)
     (defppcsubprim .SPksignalerr)
     (defppcsubprim .SPstack-rest-arg)
     (defppcsubprim .SPreq-stack-rest-arg)
     (defppcsubprim .SPstack-cons-rest-arg)
     (defppcsubprim .SPcallbackX)
     (defppcsubprim .SPcall-closure)
     (defppcsubprim .SPgetXlong)
     (defppcsubprim .SPspreadargz)
     (defppcsubprim .SPtfuncallgen)
     (defppcsubprim .SPtfuncallslide)
     (defppcsubprim .SPtfuncallvsp)
     (defppcsubprim .SPtcallsymgen)
     (defppcsubprim .SPtcallsymslide)
     (defppcsubprim .SPtcallsymvsp)
     (defppcsubprim .SPtcallnfngen)
     (defppcsubprim .SPtcallnfnslide)
     (defppcsubprim .SPtcallnfnvsp)
     (defppcsubprim .SPmisc-ref)
     (defppcsubprim .SPmisc-set)
     (defppcsubprim .SPstkconsyz)
     (defppcsubprim .SPstkvcell0)
     (defppcsubprim .SPstkvcellvsp)
     (defppcsubprim .SPmakestackblock)
     (defppcsubprim .SPmakestackblock0)
     (defppcsubprim .SPmakestacklist)
     (defppcsubprim .SPstkgvector)
     (defppcsubprim .SPmisc-alloc)
     (defppcsubprim .SPffcallX)
     (defppcsubprim .SPOLDbind-self-boundp-check)
     (defppcsubprim .SPmacro-bind)
     (defppcsubprim .SPdestructuring-bind)
     (defppcsubprim .SPdestructuring-bind-inner)
     (defppcsubprim .SPrecover-values)
     (defppcsubprim .SPvpopargregs)
     (defppcsubprim .SPinteger-sign)
     (defppcsubprim .SPsubtag-misc-set)
     (defppcsubprim .SPspread-lexpr-z)
     (defppcsubprim .SPOLDsetqsym)
     (defppcsubprim .SPreset)
     (defppcsubprim .SPmvslide)
     (defppcsubprim .SPsave-values)
     (defppcsubprim .SPadd-values)
     (defppcsubprim .SPcallback)
     (defppcsubprim .SPmisc-alloc-init)
     (defppcsubprim .SPstack-misc-alloc-init)
     (defppcsubprim .SPOLDprogvsave)
     (defppcsubprim .SPOLDprogvrestore)
     (defppcsubprim .SPcallbuiltin)
     (defppcsubprim .SPcallbuiltin0)
     (defppcsubprim .SPcallbuiltin1)
     (defppcsubprim .SPcallbuiltin2)
     (defppcsubprim .SPcallbuiltin3)
     (defppcsubprim .SPpopj)
     (defppcsubprim .SPrestorefullcontext)
     (defppcsubprim .SPsavecontextvsp)
     (defppcsubprim .SPsavecontext0)
     (defppcsubprim .SPrestorecontext)
     (defppcsubprim .SPlexpr-entry)
     (defppcsubprim .SPdarwin-syscall)
     (defppcsubprim .SPbuiltin-plus)
     (defppcsubprim .SPbuiltin-minus)
     (defppcsubprim .SPbuiltin-times)
     (defppcsubprim .SPbuiltin-div)
     (defppcsubprim .SPbuiltin-eq)
     (defppcsubprim .SPbuiltin-ne)
     (defppcsubprim .SPbuiltin-gt)
     (defppcsubprim .SPbuiltin-ge)
     (defppcsubprim .SPbuiltin-lt)
     (defppcsubprim .SPbuiltin-le)
     (defppcsubprim .SPbuiltin-eql)
     (defppcsubprim .SPbuiltin-length)
     (defppcsubprim .SPbuiltin-seqtype)
     (defppcsubprim .SPbuiltin-assq)
     (defppcsubprim .SPbuiltin-memq)
     (defppcsubprim .SPbuiltin-logbitp)
     (defppcsubprim .SPbuiltin-logior)
     (defppcsubprim .SPbuiltin-logand)
     (defppcsubprim .SPbuiltin-ash)
     (defppcsubprim .SPbuiltin-negate)
     (defppcsubprim .SPbuiltin-logxor)
     (defppcsubprim .SPbuiltin-aref1)
     (defppcsubprim .SPbuiltin-aset1)
     (defppcsubprim .SPbreakpoint)
     (defppcsubprim .SPeabi-ff-call)
     (defppcsubprim .SPeabi-callback)
     (defppcsubprim .SPsyscall)
     (defppcsubprim .SPgetu64)
     (defppcsubprim .SPgets64)
     (defppcsubprim .SPmakeu64)
     (defppcsubprim .SPmakes64)
     (defppcsubprim .SPOLDspecref)
     (defppcsubprim .SPOLDspecset)
     (defppcsubprim .SPOLDspecrefcheck)
     (defppcsubprim .SPrestoreintlevel)
     (defppcsubprim .SPmakes32)
     (defppcsubprim .SPmakeu32)
     (defppcsubprim .SPgets32)
     (defppcsubprim .SPgetu32)
     (defppcsubprim .SPfix-overflow)
     (defppcsubprim .SPmvpasssym)
     (defppcsubprim .SPsvar-specref)
     (defppcsubprim .SPsvar-specrefcheck)
     (defppcsubprim .SPsvar-bind)
     (defppcsubprim .SPsvar-bind-self)
     (defppcsubprim .SPsvar-bind-nil)
     (defppcsubprim .SPsvar-bind-self-boundp-check)
     (defppcsubprim .SPsvar-unbind)
     (defppcsubprim .SPsvar-unbind-n)
     (defppcsubprim .SPsvar-unbind-to)
     (defppcsubprim .SPsvar-specset)
     (defppcsubprim .SPsvar-setqsym)
     (defppcsubprim .SPsvar-progvsave)
     (defppcsubprim .SPsvar-progvrestore)
     )))

(defun subprim-name->offset (name)
  (let* ((sprec (find name *subprims* 
                      :test #'string-equal 
                      :key #'subprimitive-info-name)))
    (if sprec
      (subprimitive-info-offset sprec)
      (error "subprim named ~s not found." name))))

(ccl::provide "SUBPRIMS")
