# session-scubagw.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/vgw/session-scubagw.tcl,v 1.11 2002/02/03 04:39:50 lim Exp $

import Session/Scuba/RTPGW Observer AddressBlock NetworkManager/Scuba \
		Session/Scuba

Class Session/Scuba/RTPGW/VGW -superclass { Session/Scuba/RTPGW Observer }

Session/Scuba/RTPGW set localrepid_ 0

Session/Scuba/RTPGW instproc init { rtpsess sm gwagent spec } {
	$self next
	$self set rtpsess_ $rtpsess
	$self source-manager $sm
	$self set gwagent_ $gwagent
	$self set netmgr_ ""

	if { $spec != "none" } {
		set ab [new AddressBlock $spec]
		$self reset $ab
		delete $ab
	}
}

Session/Scuba/RTPGW instproc reset { ab } {
	$self instvar netmgr_ rtpsess_ gwagent_
	if { $netmgr_ != "" } {
		delete $netmgr_
	}
	set netmgr_ [new NetworkManager/Scuba $ab $rtpsess_ $gwagent_]
	$self scuba-net [$netmgr_ set scubaNet_]
}

Session/Scuba/RTPGW instproc set_allocation {} {
	$self instvar scoretab_ share_ gwagent_ rtpsess_ sessionbw_

	# Tabulate scores
	#
	# Find our transcoders in the score table and allocate
	# our bandwith proportionally.  If our bandwidth is 0, we get a
	# proportional fraction of 5% of the bandwidth which is set aside for
	# this purpose.

	set total 0
	set al [$gwagent_ set all_active_]
#puts "set allocation {$al}"
	set zerosrcs 0
	foreach src $al {
		set srcid [$src srcid]
		set srcsess [$src set session_]
		set voters [$gwagent_ voters $srcid]
		set subtotal 0
		foreach v $voters {
			set score [$gwagent_ score $v]
			set subtotal [expr $subtotal+$score]
		}
		set tot($src) $subtotal
		if { $subtotal == 0 } {
			incr zerosrcs
		}
		set total [expr $total+$subtotal]
	}

#puts "	set tlist \[$gwagent_ session_transcoders $rtpsess_\]=[$gwagent_ session_transcoders $rtpsess_]"
	set tlist [$gwagent_ session_transcoders $rtpsess_]
	foreach t $tlist {
		set src [$t source]
		if { $total > 0 } {
			set avg [expr $tot($src)/$total]
		} else {
			set avg 0
		}
		if { $avg > 0 } {
			set share_ [expr 0.95*$avg]
		} else {
			if { $zerosrcs == 0 } {
				set zerosrcs 1
			}
			set share_ [expr 0.05/$zerosrcs]
		}
#puts "$self: $src [$src srcid] set-bps $share_ of $sessionbw_=[expr $share_*$sessionbw_]"
		$t set-bps [expr int($share_*$sessionbw_ + 0.5)]
	}
}

#
# Aggregate the reports from all other sessions.
#
Session/Scuba/RTPGW instproc build_report {} {
	$self instvar gwagent_ rtpsess_
	set srclist [$gwagent_ set all_sources_]
	set total 0
	foreach src $srclist {
		set srcsess [$src set session_]
		if { $srcsess == $rtpsess_ } {
			continue
		}
		set ss [$gwagent_ set scuba_sess_($srcsess)]
		set replist [$ss last_report_from $src]
		$self sender-id [$src srcid]
		foreach rep $replist {
			set txid [lindex $rep 0]
			set score [lindex $rep 1]
			$self add-scuba-entry $txid [expr int($score*1e6)]
		}
		$self send-report [llength $replist]
	}
}

Session/Scuba/RTPGW instproc last_report_from src {
	$self instvar scoretab_
	set ret ""
	foreach rep [array names scoretab_ $src:*] {
		set transmitter [lindex [split $rep :] 1]
		lappend ret "$transmitter $scoretab_($rep)"
	}
	return $ret
}
