# ui-dragdrop.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/ui_tools/ui-dragdrop.tcl,v 1.4 2002/02/03 04:30:23 lim Exp $


Class DragNDrop


DragNDrop public init { widget callback {color \#808080} } {
	$self next
	$self instvar widget_ callback_ color_
	#$self bind_slaves $widget 1
	set widget_ $widget
	set callback_ $callback
	set color_ $color
	$self enable
}


DragNDrop public destroy { } {
	$self instvar widget_
	$self bind_slaves $widget_ 0
	if [winfo exists .$self] { destroy .$self }
	$self next
}


DragNDrop private bind_slaves { w flag } {
	foreach s [pack slaves $w] {
		$self bind_slaves $s $flag
	}

	$self bind $w $flag
}


DragNDrop private bind { w flag } {
	if $flag {
		bind $w <ButtonPress-1> "$self select %X %Y"
		bind $w <B1-Motion> "$self move"
		bind $w <ButtonRelease-1> "$self release"
	} else {
		bind $w <ButtonPress-1> ""
		bind $w <B1-Motion> ""
		bind $w <ButtonRelease-1> ""
	}
}


DragNDrop public build_widget { toplevel } {
}


DragNDrop public select_widget { toplevel } {
}


DragNDrop public release_widget { toplevel } {
}


DragNDrop private select {x y} {
	$self instvar id_ select_x_ select_y_ selected_
	set select_x_ $x
	set select_y_ $y
	set id_ [after 500 $self really_select $x $y]
	set selected_ 1
}


DragNDrop private really_select {x y} {
	$self instvar widget_ x_ y_ color_ id_
	if [info exists id_] { unset id_ }
	if ![winfo exists .$self] {
		toplevel .$self -background $color_ -bd 1 -relief raised
		#  prevent title bar and border from being drawn around
		# this window
		wm overrideredirect .$self 1
		wm withdraw .$self

		$self build_widget .$self
	}

	$self select_widget .$self
	set w [winfo width $widget_]
	set h [winfo height $widget_]

	wm geometry .$self ${w}x${h}+[winfo rootx $widget_]+[winfo \
			rooty $widget_]
	wm deiconify .$self
	raise .$self

	set x_ [expr $x - [winfo rootx $widget_]]
	set y_ [expr $y - [winfo rooty $widget_]]
}


DragNDrop private move { } {
	$self instvar id_ select_x_ select_y_ selected_
	if ![info exists selected_] return
	if [info exists id_] {
		after cancel $id_
		unset id_
		$self really_select $select_x_ $select_y_
	}

	$self instvar x_ y_
	set x [expr [winfo pointerx .$self] - $x_]
	set y [expr [winfo pointery .$self] - $y_]
	wm geometry .$self +$x+$y
	update idletasks
}


DragNDrop public get_nw_coords { x y } {
	$self instvar x_ y_
	return [list [expr $x - $x_] [expr $y - $y_]]
}


DragNDrop private release { } {
	$self instvar id_ selected_
	if ![info exists selected_] return
	unset selected_

	if [info exists id_] {
		after cancel $id_
		unset id_
		return
	}

	$self instvar x_ y_ widget_
	set x [winfo pointerx .$self]
	set y [winfo pointery .$self]

	set l [winfo rootx $widget_]
	set t [winfo rooty $widget_]
	set r [expr $l + [winfo width $widget_ ] - 1]
	set b [expr $t + [winfo height $widget_] - 1]

	wm withdraw .$self
	$self instvar callback_
	if { $callback_!={} } { eval $callback_ $self $x $y }
	#if { $x < $l || $x > $r || $y < $t || $y > $b } {
	#	$self instvar callback_
	#	if { $callback_!={} } { eval $callback_ $self $x $y }
	#} else {
	#	$self zoom_back
	#}

	$self release_widget .$self
}


DragNDrop public zoom_back { {steps 10} } {
	$self instvar x_ y_ widget_
	wm deiconify .$self
	set startx [winfo rootx .$self]
	set starty [winfo rooty .$self]
	set endx [winfo rootx $widget_]
	set endy [winfo rooty $widget_]

	set deltax [expr $endx - $startx]
	set deltay [expr $endy - $starty]
	if { $deltax < 0 } { set deltax [expr - $deltax] }
	if { $deltay < 0 } { set deltay [expr - $deltay] }

	if { $deltax > $deltay } {
		if { $startx < $endx } {
			set cmp {$x <= $endx}
			set incr $steps
		} else {
			set cmp {$x >= $endx}
			set incr -$steps
		}
		for { set x $startx } $cmp { incr x $incr } {
			set y [expr (( $x - $startx ) * ( $starty - $endy )) /\
					( $startx - $endx ) + $starty]
			wm geometry .$self +$x+$y
			update idletasks
		}
	} elseif { $deltax != 0 || $deltay != 0 } {
		if { $starty < $endy } {
			set cmp {$y <= $endy}
			set incr $steps
		} else {
			set cmp {$y >= $endy}
			set incr -$steps
		}
		for { set y $starty } $cmp { incr y $incr } {
			set x [expr (( $y - $starty ) * ( $startx - $endx )) /\
					( $starty - $endy ) + $startx]
			wm geometry .$self +$x+$y
			update idletasks
		}
	}

	wm withdraw .$self
}


DragNDrop public enable { { flag 1 } } {
	$self instvar widget_ enable_
	set enable_ $flag
	$self bind_slaves $widget_ $flag
}
