# ui-menu.tcl --
#
#       Defines a popup menu object
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Class PopupMenu

PopupMenu public init {w args} {
    $self next

    $self instvar win_ n_

    set win_ $w
    menubutton $win_ -indicatoron yes -menu $win_.m -relief raised -bd 2
    menu $win_.m
    set n_ 0

    foreach a $args {
	eval $self add $a
    }
}

PopupMenu public add {text {cmd ""}} {
    $self instvar win_ n_ text_ cmd_

    $win_.m add command -label $text -command "$self select $n_"
    if {$n_ == 0} {
	$win_ configure -text $text
    }

    set text_($n_) $text
    set cmd_($n_) $cmd
    incr n_
}

PopupMenu public get {} {
    $self instvar win_
    return [$win_ cget -text]
}

PopupMenu public clear {} {
    $self instvar win_ n_ text_ cmd_
    $win_.m delete 0 end
    for {set i 0} {$i<$n_} {incr i} {
	unset text_($i)
	unset cmd_($i)
    }
    set n_ 0
}

PopupMenu private select {n} {
    $self instvar win_ text_ cmd_
    $win_ configure -text $text_($n)
    if {$cmd_($n) != ""} {
	catch {eval $cmd_($n)}
    }

}
