# application-msp.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/msp/application-msp.tcl,v 1.33 2002/02/03 04:28:01 lim Exp $


import Application Timer/Periodic RTSP_Client Bookmark VcrIcons \
		Dialog MessageBox FontInitializer

# msp is the MASH streaming player, developed by Suchitra Raman as a
# client for the archive system.  msp can be started from the command
# line, or as a netscape helper app.  The -server flag allows msp to be
# passed a file which contains the starting uri, along with optional
# bookmarks.

# Status: alpha

# To Do: The vic and vat ui's should eventually be replaced by Cyndi's
# integrated UI.  Also, needs to include mb capabilities.  Switching
# sessions doesn't always work properly, and bookmarks need work.  Also,
# needs a lot more error trapping.


Class MSP_Application -superclass {Application Timer/Periodic}

#FIXME
#source tcl/net/network.tcl
# had to add because of in_multicast proc, should be part of AddressBlock?


#source tcl/msp/ui-vic.tcl
#source tcl/msp/ui-vat.tcl

#
MSP_Application instproc init { w argv } {

	$self instvar ui_ net_ session_ delta_ history_
	$self tkvar   offset_

	set o [$self options]
	$self next msp
	$self init_args $o
	$self init_resources $o
	$o parse_args $argv
	$self init_fonts $o
	$self init_UI $w

	set msp [$self get_option mspData]
	if { $msp!={} } {
		$self parse_msp $msp
	} else {
		$self parse_file [$self get_option serverFile]
	}
	set history_ ""
	if [info exists net_] {
	} else {
		set   net_ [new RTSP_Client]
		$net_ init_vars $self
	}
	if {[$self get_option autoStart] == "true"} {
		$self tkvar url_
		$self instvar desc_
		set url_ [$self get_option defaultAddr]
		set desc_ [$self get_option defaultDesc]
		$self open
	}
}

#
MSP_Application private parse_line { line } {
	set cmd [lindex $line 0]
	switch $cmd {
		uri {
			set v [lindex $line 1]
			$self add_default defaultAddr $v
			$self add_default autoStart "true"
		}
		activity {
			# Set up bindings so that look-ups can occur both ways.
			set info [split [join [lrange $line 1 end]] ":"]
			set name [string trim [lindex $info 0]]
			set color [string trim [lindex $info 2]]
			set spurts_($name) [string trim [lindex $info 1]]
			set acolor_($name) $color
			set uname_($color)  $name
		}
	}
}


# Address file is downloaded using HTTP and parsed here.
MSP_Application private parse_file { sFile } {
	$self instvar name_ spurts_ acolor_ uname_ bookmarks_
	$self instvar ui_

	if {$sFile == ""} {
		return 0
	}
	set fd [open $sFile "r"]
	if { $fd <  0 } {
		puts "$name_: error opening $sFile"
		exit 1
	}

	while { [gets $fd line] > 0 } {
		set cmd [lindex $line 0]
		switch $cmd {
			uri {
				set v [lindex $line 1]
				$self add_default defaultAddr $v
				$self add_default autoStart "true"
			}
			bookmark {
				# Set up bindings so that look-ups can occur both ways.
				set info [split [join [lrange $line 1 end]] "^"]
				set name [string trim [lindex $info 2]]
				set color [string trim [lindex $info 3]]
				if {$color == ""} {
					set color "black"
				}
				set offset [string trim [lindex $info 1]]
				set addr [string trim [lindex $info 0]]
				set bookmarks_($addr:$offset) [new Bookmark $name $addr $offset $color]
				set idx "$addr:$offset"
				$ui_(main).menubar.bookmarks.list add command -font [$self get_option entryFont] \
						-label "$name ($idx)" \
						-command "[list $self jump-to $idx]"
			}
		}
		$self parse_line $line
	}
	close $fd
	return 1
}

#
MSP_Application private parse_msp { msp } {
	foreach line [split $msp "\n"] {
		$self parse_line $line
	}
}

#
MSP_Application instproc init_args o {
	$o register_option -server serverFile
	$o register_option -msp mspData
	$o register_option -vusemega megaVideoSession
        $o register_option -ausemega megaAudioSession
	$o register_option -vrport megaRecvVideoPort
	$o register_option -vmegactrl megaVideoCtrl
        $o register_option -arport megaRecvAudioPort
	$o register_option -amegactrl megaAudioCtrl

	$o register_option -sspec videoSessionSpec
	$o register_option -sbw videoSessionBW
	$o register_option -sloc videoServiceLocation
	$o register_boolean_option -scuba useScuba
}

#
MSP_Application instproc init_UI { path } {

	$self instvar ui_ id_
	wm title . "MARS Rover"

	set id_ 0
	set ui_(main) $path
	frame $path  -relief sunken
	pack  $path -fill x

	$self build_menubar     $path
	$self build_entry       $path
	$self build_ctrlpanel   $path
	$self build_slider      $path
	$self build_title       $path
}

#
MSP_Application instproc build_av { path } {
	frame $path.av
	frame $path.av.vic
	frame $path.av.vat
	pack $path.av -side bottom -expand 1 -fill both
	pack $path.av.vat $path.av.vic -side left -expand 1 -fill both
}

#
MSP_Application instproc build_entry { w } {
	$self tkvar url_
	frame $w.entry -relief sunken
	pack  $w.entry -fill x
	label $w.entry.label -text Location: -justify right
	entry $w.entry.url -textvariable [$self tkvarname url_] -width 60\
			-bg white -fg black -font [$self get_option entryFont]
	bind $w.entry.url <Key-Return> "$self open"
	pack $w.entry.label -anchor w -side left
	pack $w.entry.url -fill x -side left -anchor e
}

#
MSP_Application instproc build_ctrlpanel { w } {
	$self instvar net_

	frame $w.cp -relief sunken -height 20
	pack $w.cp -fill x -anchor w -side top
	set mf [$self get_option medfont]
	button $w.cp.stop -height 10 -font $mf -text "Stop" -image VcrIcons(sstop)\
			-command "$self play-stop"
	button $w.cp.playOrPause  -height 10 -font $mf -text "Play" -image VcrIcons(splay)\
			-command "$self play-pause"
	pack $w.cp.playOrPause $w.cp.stop -side left -anchor w
}

#
MSP_Application instproc build_title { w } {
	$self instvar net_

	frame $w.sdes   -relief sunken
	frame $w.sinfo  -relief sunken
	frame $w.dur    -relief sunken
	pack $w.sdes $w.sinfo $w.dur -fill both -side top
	set ef [$self get_option entryFont]
	set bf [$self get_option mbFont]
	# Build the session description label
	label $w.sdes.label -text Title: -justify right \
			-width 15 -anchor e
	label $w.sdes.value -text " " -width 60 \
			-fg black -bg white  -font $ef -justify left -anchor w
	pack $w.sdes.label $w.sdes.value -fill x -side left -anchor w

	# Build the session info label
	label $w.sinfo.label -text Information: -justify right \
			-width 15 -anchor e
	label $w.sinfo.value -text " " -width 60 \
			-bg white -fg black -font $ef -justify left -anchor w\
			-wraplength 5i
	pack $w.sinfo.label $w.sinfo.value -fill x -side left -anchor w

	# Build the session info label
	label $w.dur.label -text Duration: -width 15 -justify right -anchor e
	label $w.dur.value -text "0:00:00" \
			-fg black -bg white -font $ef -width 60 \
			-justify left -anchor w
	pack $w.dur.label $w.dur.value -fill x -side left -anchor w
}

#
MSP_Application instproc build_slider { w } {

	# Offset in the stream to control seeking
	$self tkvar offset_
	$self instvar slider_

	set sf [$self get_option disableFont]
	frame $w.scale -relief sunken
	canvas $w.scale.activity -height 20 -width 650 -highlightthickness 0 -bd 1 -closeenough 1.0

	set slider_ INACTIVE
        scale $w.scale.slider -state disabled -orient horizontal \
		-width 8 -length 650 -relief groove -showvalue 0 \
		-from 0 -to 100 \
		-font $sf -showvalue true \
		-variable [$self tkvarname offset_] \
		-troughcolor white

	bind $w.scale.slider <ButtonRelease-2> "$self play-offset"
	bind $w.scale.slider <ButtonRelease-1> "$self play-offset"
	bind $w.scale.slider <ButtonPress-3> "$self edit_bookmark .bookmark"
        pack $w.scale -expand 0 -side top -anchor w
	pack $w.scale.activity $w.scale.slider -fill x -expand 0
}

# Invoked when play starts
MSP_Application instproc activate_slider { } {
	$self instvar ui_ slider_ net_
	#puts "Activating slider"
	if {$slider_ == "INACTIVE"} {
		set slider_ ACTIVE
		set mf [$self get_option medfont]
		set s [$net_ set session_(starttime_)]
		set e [$net_ set session_(endtime_)]
		$ui_(main).scale.slider configure -state active -font $mf -from 0 -to [expr int($e -$s)] \
				-tickinterval [expr int(0.49 * ($e - $s))]
		after 3000 $self read_bookmarks
		after 3000 $self update-activity
	}
}

# Invoked when slider is dragged.
MSP_Application instproc play-offset { } {
	$self instvar net_ slider_

        if {$slider_ == "ACTIVE"} {
		$net_ send "PLAY"
		$self cancel
		$self start-timer
	}
	return
}

#
MSP_Application instproc build_menubar { path } {

	$self instvar net_ history_

	frame $path.menubar  -relief sunken
	pack $path.menubar -fill x

	menubutton      $path.menubar.file -text "File" -m $path.menubar.file.x -width 5
	pack            $path.menubar.file -side left
	menu            $path.menubar.file.x -tearoff no

	$path.menubar.file.x add command -label "Open URL"    -command "$self get_URL .open"
	$path.menubar.file.x add command -label "Exit"        -command "$self exit"

	menubutton      $path.menubar.view -text "View" -m $path.menubar.view.x -width 5
	pack            $path.menubar.view -side left

	menubutton      $path.menubar.bookmarks -text "Bookmarks" -m $path.menubar.bookmarks.list -width 10
	pack            $path.menubar.bookmarks -side left

	menubutton      $path.menubar.go -text "Go" -m $path.menubar.go.list -width 5
	pack            $path.menubar.go -side left


	menubutton      $path.menubar.help -text "Help" -m $path.menubar.help.help -width 5
	pack            $path.menubar.help -side left

	menu            $path.menubar.view.x -tearoff no
	$path.menubar.view.x add command -label "Statistics"    -command "$self display-stats"
	$path.menubar.view.x add command -label "Preferences" 	-command " "

	menu            $path.menubar.go.list -tearoff no
	menu            $path.menubar.bookmarks.list -tearoff no
	$path.menubar.bookmarks.list add command -label "Add Bookmark" -command "$self edit_bookmark .bookmark"
	$path.menubar.bookmarks.list add separator
	menu            $path.menubar.help.help -tearoff no
	$path.menubar.help.help add command -label "Help"    -command " "
}

#
MSP_Application instproc display-stats { } {

}

#
MSP_Application instproc get_URL { w } {

	$self tkvar url_
	set url_ [$self get_option serverAddr]
	toplevel $w
	wm title $w "Open Presentation"
	message $w.msg -width 200 -justify center -text "Enter URL"
	pack $w.msg
	entry $w.url -width 60 -textvariable [$self tkvarname url_]\
			-font [$self get_option entryFont]
#	bind $w.url <Key-Return> "destroy $w; $self open"
	pack  $w.url
	frame $w.bf  -relief sunken
	pack  $w.bf -pady 5
	button $w.bf.ok -text "Open" -width 5 -command "destroy $w; $self open"
	pack   $w.bf.ok
	button $w.bf.quit -text "Cancel" -width 5 -command "destroy $w"
	pack   $w.bf.quit -side right -before $w.bf.ok
}

#
MSP_Application instproc open { {off 0} } {
	$self instvar net_ history_ ui_
	$self tkvar url_
	$self instvar desc_
	$self clean-up
	# Update the history list
	set ef [$self get_option entryFont]
	set h $url_
	$ui_(main).menubar.go.list insert 1 command -font $ef \
			-label "$h" -command "$self tkvar url_; set url_ $h; $self open"
	if {![info exists desc_]} {
		set desc_ ""
	}
	set err [$net_ open $url_ $desc_]
	if { $err != "" } {
		Dialog transient MessageBox -type ok -text $err \
			-image Icons(warning)
	}
	return
}

#
MSP_Application instproc offset { } {
	$self tkvar offset_
	return $offset_
}

#
MSP_Application instproc play-pause { } {
	$self instvar net_ slider_
	if {$slider_ == "ACTIVE"} {
		$net_ playOrPause
	}
}

#
MSP_Application instproc play-stop { } {
	$self tkvar offset_
	$self instvar net_ slider_
	if {$slider_ == "ACTIVE"} {
		set offset_ 0
		$net_ playOrPause STOP
	}
}

#
MSP_Application instproc show-balloon { x y desc color } {
	$self instvar uname_ ui_ id_

	set w .balloon

	if ![winfo exists $w] {
		toplevel $w
		wm overrideredirect $w 1
		message $w.msg -font [$self get_option smallfont] \
				-width 200 -bg white
		pack $w.msg -side left
	}
	wm overrideredirect $w 1
	set widget .main.scale.activity
	set x [expr [winfo rootx $widget]+$x]
	set y [expr [winfo rooty $widget]+$y + 10]
	$w.msg config -text $desc -fg $color
	wm geometry $w +$x+$y
}

#
MSP_Application instproc hide-balloon { } {
	$self instvar ui_ id_
	destroy .balloon
}

#
MSP_Application instproc update-activity { } {

	# acolor_ is the active color
	$self instvar ui_ spurts_ acolor_ uname_ seekto_ net_ bookmarks_
	$self tkvar url_
	#puts "==update-activity=="
	foreach x [array names bookmarks_] {
		set addr   [$bookmarks_($x) set attributes_(addr)]
		set offset [$bookmarks_($x) set attributes_(offset)]
		set color  [$bookmarks_($x) set attributes_(color)]
		set name  [$bookmarks_($x) set attributes_(name)]
		if {$url_ == $addr} {
			$self update-bookmark $offset $name $color
		}
	}

}

#
MSP_Application instproc update-bookmark {o n {color "black"}} {
	$self instvar ui_ net_


#	set g [lindex [split [wm geometry .] "+"] 0]
#	set w [lindex [split $g "x"] 0]
	set w 650

	set mark 0
	set e [$net_ set session_(endtime_)]
	set s [$net_ set session_(starttime_)]

	set st [expr ($w - 40) * ($o - $s)/($e - $s) + 20]
	set iid [$ui_(main).scale.activity create rect $st 10 [expr $st+3] 20 \
			-fill $color -outline $color -tag $color]
	$ui_(main).scale.activity bind $iid <ButtonPress-1> \
			"$self tkvar offset_;set offset_ [expr $o -$s]; $self play-offset"
	set mark [expr $st+3]
	$ui_(main).scale.activity bind $iid <Enter> "$self show-balloon %x %y {$n} $color"
	$ui_(main).scale.activity bind $iid <Leave> "$self hide-balloon"
}

#
MSP_Application instproc update-title {name info duration {elapsed 00:00:00} } {
	$self instvar ui_ app_
	$ui_(main).sdes.value configure -text $name
	$ui_(main).sinfo.value configure -text $info
	$ui_(main).dur.value configure -text "$elapsed/[duration_readable $duration]"
	set app_(duration) $duration
}

#
MSP_Application instproc update-elapsed { } {
	$self instvar ui_ app_ net_
	$self tkvar offset_
	set elapsed [$net_ elapsed $offset_]
	$ui_(main).dur.value configure -text "$elapsed/[duration_readable $app_(duration)]"
}

#
MSP_Application instproc clean-up { } {
	$self instvar vic_ vat_ ui_

	$self clean-net
	if [info exists vic_(agent)] {
		delete $vic_(agent)
	}
 	if [info exists vat_(agent)] {
		delete $vat_(agent)
	}
	destroy  .main.av
	$self build_av $ui_(main)
}

#
MSP_Application instproc exit { } {
	$self instvar net_

	$self clean-up
	if {[info exists net_]} {
		$net_ send "CLOSE"
	}
	exit 0
}

#
MSP_Application instproc play-update { label } {
	$self instvar ui_
	set label [string tolower $label]
	if {$label == "pause"} {
		$ui_(main).cp.playOrPause configure -text $label -image VcrIcons(pause)
		$self start-timer
	} else {
		$ui_(main).cp.playOrPause configure -text $label -image VcrIcons(splay)
	        $self cancel
	}
}

#
MSP_Application instproc start-timer { } {
	$self instvar net_ delta_

	# Convert to msec
	set delta_ [expr [$net_ duration] * 0.001 * 1000]
	$self start $delta_
}

#
MSP_Application instproc timeout { } {
	$self tkvar offset_
	$self instvar delta_

	#set offset_ [expr $offset_ + $delta_ * 0.001]
	$self update-elapsed
}

#
MSP_Application instproc add-bookmark { } {
	$self tkvar offset_ bname_ url_
	$self instvar bookmarks_ ui_ net_

	set timestamp [expr [$net_ set session_(starttime_)] + $offset_]
	set b [new Bookmark $bname_ $url_ $timestamp]
	set bookmarks_($url_:$timestamp) $b

	set idx "$url_:$timestamp"
	set ef [$self get_option entryFont]
	$ui_(main).menubar.bookmarks.list add command -font $ef \
			-label "$bname_ ($url_:$timestamp)" -command "[list $self jump-to $idx]"
	$self save_bookmark $b
	$self update-bookmark $timestamp $bname_
}

#
MSP_Application instproc get_value opt {
	return [$self get_option $opt]
}

#
MSP_Application private read_bookmarks { } {
	$self instvar ui_ bookmarks_
	$self tkvar url_

	if [file exists ~/.msp/bookmarks.bm] {
		set fd [open ~/.msp/bookmarks.bm]
		while { [gets $fd line] > 0 } {
			set f [split $line "^"]

			set addr   [lindex $f 0]
			set offset [lindex $f 1]
			set name   [lindex $f 2]
			set color  [string trim [lindex $f 3]]
			if {$color == ""} {
				set color "black"
			}
			set b  [new Bookmark $name $addr $offset $color]
			set bookmarks_($addr:$offset) $b
			set idx "$addr:$offset"

			set ef [$self get_option entryFont]
			$ui_(main).menubar.bookmarks.list add command -font $ef \
					-label "$name ($addr:$offset)" \
					-command "[list $self jump-to $idx]"
#			if {$url_ == $addr} {
#				puts "adding bookmark $name to canvas"
#				$self update-bookmark $offset $name $color
#			}

		}
		close $fd
	}
}

#
MSP_Application instproc edit_bookmark { w } {
	$self instvar slider_
	if {$slider_ == "INACTIVE"} {
		return
	}
	toplevel $w
	wm title $w "Add Bookmark"
	message $w.msg -width 200 -justify center -text "Label"
	pack $w.msg
	entry $w.url -width 40 -textvariable [$self tkvarname bname_]\
			-font [$self get_option entryFont] -bg white -fg black
	pack  $w.url
	frame $w.bf  -relief sunken
	pack  $w.bf -pady 5
	button $w.bf.ok -text "Add" -font [$self get_option mbFont] -width 5 -command "destroy $w; $self add-bookmark"
	pack   $w.bf.ok
	button $w.bf.quit -text "Cancel" -font [$self get_option mbFont] -width 5 -command "destroy $w"
	pack   $w.bf.quit -side right -before $w.bf.ok
}

#
MSP_Application instproc save_bookmark { b } {
	$self instvar net_
	cd ~
	if ![file exists .msp] {
		exec mkdir .msp
	}
	cd .msp
	set fd [open "bookmarks.bm" a+]
	set addr   [$b set attributes_(addr)]
	set name   [$b set attributes_(name)]
	set timestamp [$b set attributes_(offset)]
	#puts $fd "$addr\^$timestamp\^$name\^black"
	close $fd
}

#
MSP_Application instproc jump-to { idx } {
	$self tkvar offset_ url_
	$self instvar net_ bookmarks_
	#puts "jump-to $idx"
	set bm $bookmarks_($idx)
	set addr [$bm set attributes_(addr)]
	if { $addr == [$net_ set session_(uri_)]} {
		set offset_ [expr [$bm set attributes_(offset)] - [$net_ set session_(starttime_)]]
		$net_ send "PLAY"
	} else {
		Dialog transient MessageBox -type ok -text "This demo version permits only 1 stream!" \
			-image Icons(warning)
# We don't support multiple sessions
#		set url_ [$bm set attributes_(addr)]
#		set offset_ [expr [$bm set attributes_(offset)] - [$net_ set session_(starttime_)]]
#		$self open $offset_
	}
}

#
MSP_Application instproc display-stats { } {

}

#
MSP_Application instproc set-offset { o } {
	$self tkvar offset_
	set offset_ $o
}

#
# this is more or less what mui has to do...!
#
MSP_Application instproc init_resources o {
	$o load_preferences "msp"

	#
	# use 2 pixels of padding by default
	#
	option add *padX 2
	option add *padY 2
	#
	# don't put tearoffs in pull-down menus
	#
	option add *tearOff 0

	option add *Radiobutton.relief flat startupFile
	option add *Checkbutton.anchor w startupFile
	option add *Radiobutton.anchor w startupFile
	option add *Radiobutton.relief flat startupFile
	global tcl_platform
	# use the default colors if we are in windows
	if {$tcl_platform(platform) != "windows"} {
		option add *Scale.sliderForeground gray66 startupFile
		option add *Scale.activeForeground gray80 startupFile
		option add *Scale.background gray70 startupFile
		option add Msp.background gray85
	}
	option add *VatVU.foreground black startupFile
	option add *VatVU.peak gray50 startupFile
	option add *VatVU.hot firebrick1 startupFile
	option add *VatVU.hotLevel 90 startupFile

	#
	# These can be overridden.
	#
#	$self add_default geometry 400x620

	$o add_default defaultDesc ""
	$o add_default defaultmediaList "audio video"
	$o add_default videoAddr 224.8.8.2
	$o add_default videoPort 8000
	$o add_default videoTTL  16

	$o add_default audioAddr 224.8.9.2
	$o add_default audioPort 9000
	$o add_default audioTTL  16
	$o add_default mediaboardTTL  16
#	$o add_default serverAddr "rtsp://mirage.cs.berkeley.edu:2025/archive/CSCW4/CSCW4"
	$o add_default serverAddr "rtsp://rose.cs.berkeley.edu:2025/archive/CSCW4/CSCW4"
	$o add_default mtu 1024
	$o add_default network ip
	$o add_default framerate 8
	$o add_default defaultTTL 16
	$o add_default maxbw -1
	$o add_default bandwidth 1000000
	$o add_default iconPrefix "MARS Rover"
	$o add_default priority 10
	$o add_default confBusChannel 0

	$o add_default videoFormat h.261
	$o add_default sessionType rtpv2
	$o add_default grabber none
	$o add_default stampInterval 1000
	$o add_default switchInterval 5
	$o add_default dither Dither
	$o add_default tile 1
	$o add_default filterGain 0.25
	$o add_default statsFilter 0.0625
	$o add_default useHardwareDecode false
	$o add_default infoHighlightColor LightYellow2
	$o add_default useJPEGforH261 false
	$o add_default stillGrabber false
	$o add_default siteDropTime "300"

	#
	# color resources
	#
	$o add_default medianCutColors 150
	$o add_default gamma 0.7

	#FIXME
	$o add_default jvColors 32

	$o add_default foundry adobe

	$o add_default suppressUserName true

	$o add_default softJPEGthresh -1
	$o add_default softJPEGcthresh 6

	$o add_default sunvideoDevice 0
	$o add_default enableBVC false
	$o add_default audioFormat PCM2

	# true to allow voice-switch to switch to self
	$o add_default vain false

	# list of sdes items to display in info window
	$o add_default sdesList "cname tool email note"

	# resources used by audio widgets FIXME merge
	$o add_default disabledColor gray50
	$o add_default highlightColor gray95
	$o add_default idleDropTime "20"
	$o add_default defaultPriority "100"

	# MeGa Resources
	$o add_default megaVideoCtrl 224.4.5.24/50000/1
	$o add_default megaVideoFormat h261
	# multicast is default
	$o add_default megaVideoRecvPort 0
	$o add_default megaAudioRecvPort 0

	# (scuba) default session bandwidth (kb/s).
	$o add_default maxVideoSessionBW 128000
	# 60 seconds max startup wait for first message
	$o add_default megaStartupWait 60


### Vat startup defaults
	option add Msp.iconPrefix Client: startupFile

	# colors
	$o add_default titleReleased "gray95"
	$o add_default titleHave "#aaaaaa"
	$o add_default titlePinned "black"

	$o add_default inputGain "32"
	$o add_default mikeGain "32"
	$o add_default lineinGain "180"
	$o add_default linein2Gain "180"
	$o add_default linein3Gain "180"

	$o add_default outputGain 180
	$o add_default speakerGain "180"
	$o add_default jackGain "180"
	$o add_default lineoutGain "180"
	$o add_default lineout2Gain "180"

	$o add_default speakerMute "false"
	$o add_default mikeMute "true"

	$o add_default speakerMode "NetMutesMike"
	$o add_default jackMode "FullDuplex"
	$o add_default lineoutMode "NetMutesMike"
	$o add_default lineout2Mode "NetMutesMike"
	$o add_default maxPlayout "6"
	$o add_default lectureMode "false"
	$o add_default useNames "false"
	$o add_default defaultTTL "16"

	$o add_default filterLength "256"
	$o add_default filterMaxTaps "35"

	$o add_default meterEnable "true"
	$o add_default meterStyle "discrete"
	$o add_default inputPort {mike microphone mic}
	$o add_default outputPort speaker
	$o add_default mikeAGC "false"
	$o add_default mikeAGCLevel "0"
	$o add_default speakerAGC "false"
	$o add_default speakerAGCLevel "0"

	$o add_default defaultPriority "100"
	$o add_default idleDropTime "20"
	$o add_default autoRaise "true"
	$o add_default externalEchoCancel "false"
	$o add_default silenceThresh "20"
	$o add_default talkThresh "0"
	$o add_default echoThresh "70"
	$o add_default echoSuppressTime "400"
	$o add_default keepSites "false"
	$o add_default muteNewSites "false"
	$o add_default sortSites "true"
	$o add_default compactSites "true"
	$o add_default compressionSlope "0.0625"
	$o add_default key ""
	$o add_default afDevice "-1"
	$o add_default afBlocks "2"
	$o add_default afSoftOuputGain "0"
	$o add_default afSoftInputGain "0"
	$o add_default siteDropTime "300"
	$o add_default audioFileName "/dev/audio"
	$o add_default statTimeConst 0.1
	$o add_default statsFilter 0.0625

	$o add_default mtu 1024
	$o add_default network ip
	$o add_default maxbw -1
	$o add_default bandwidth 128
	$o add_default confBusChannel 0
	$o add_default sessionType rtp

	$o add_default foundry adobe
	$o add_default recvOnly false

	$o add_default suppressUserName true
}

#
MSP_Application instproc init_fonts o {
	new FontInitializer $o

	option add *Font [$o get_option helv12] startupFile
	# override some default fonts...
        $o add_default mbFont [$o get_option helv12]
        $o add_default helpFont [$o get_option times12]
        $o add_default entryFont [$o get_option courier12]
        $o add_default disableFont [$o get_option helv10o]
}

import MPlug/ScrolledUI

# This class allows the msp application to run as a MASH plug in.

Class MSP_Application/MPlug -superclass MSP_Application

#
MSP_Application/MPlug public init { argv } {
	$self instvar mplug_
	set mplug_ [new MPlug/ScrolledUI]

	# on success, the following function returns NPRES_DONE which is
	# defined to 0 in a .h file
	# FIXME: how do I pull in constants defined in .h files into tcl?
	if { [$mplug_ wait_for_stream] } {
		puts stderr "Could not retrieve stream"
		exit
	}

	if { [$mplug_ get mimetype] != "x-mash/x-msp" } {
		$self do_error "msp cannot handle mimetype:\
			[$mplug_ get mimetype]"
	}

	lappend argv -msp [$mplug_ get stream]
	$self next [$mplug_ root].[pid] $argv
	vwait forever
}

#
MSP_Application/MPlug private do_error { msg } {
	$self instvar mplug_
	label .label -text $msg -justify left -anchor w
	pack .label  -fill both -expand 1 -padx 10 -pady 10
	vwait forever
}
