# handler.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/hm/handler.tcl,v 1.52 2002/02/03 04:27:05 lim Exp $


import RTP/Video RTP/Audio SDPParser


set gwstr(video) VGW
set gwstr(sdp) SDGW
set gwstr(audio) AGW
set gwstr(mediaboard) MBGW
set gwstr(mb) MBGW
set gwstr(whiteboard) MBGW

Class GWHandler
Class GWHandler/RTPGW -superclass GWHandler
Class GWHandler/VGW -superclass { GWHandler/RTPGW RTP/Video }
Class GWHandler/AGW -superclass { GWHandler/RTPGW RTP/Audio }
Class GWHandler/MBGW -superclass GWHandler
Class GWHandler/SDGW -superclass GWHandler
Class GWHandler/Mars -superclass GWHandler
Class GWHandler/Aries -superclass GWHandler
Class GWHandler/FXTemp -superclass GWHandler
Class GWHandler/FXForwardBackEnd -superclass GWHandler
Class GWHandler/FXForwardFrontEnd -superclass GWHandler

Class ServiceCreator
Class ServiceCreator/MeGa -superclass ServiceCreator
Class ServiceCreator/Generic -superclass ServiceCreator
Class ServiceCreator/Mars -superclass ServiceCreator
Class ServiceCreator/Aries -superclass ServiceCreator
Class ServiceCreator/FXTemp -superclass ServiceCreator
Class ServiceCreator/FXForwardBackEnd -superclass ServiceCreator
Class ServiceCreator/FXForwardFrontEnd -superclass ServiceCreator

import ServiceCreator/MediaPad GWHandler/MediaPad
import ServiceCreator/Device GWHandler/Device

ServiceCreator instproc init { agent } {
	$self next
	$self set agent_ $agent
}

ServiceCreator/Generic instproc create_handler { srv_inst msg } {
	$self instvar agent_
	set h [new GWHandler $agent_ $srv_inst "" "" ""]
	return $h
}

ServiceCreator/FXTemp instproc create_handler {srv_inst msg} {
    $self instvar agent_
    set h [new GWHandler/FXTemp $agent_ $srv_inst $msg]
    return $h;
}

ServiceCreator/FXForwardBackEnd instproc create_handler {srv_inst msg} {
    $self instvar agent_
    set h [new GWHandler/FXForwardBackEnd $agent_ $srv_inst $msg]
    return $h;
}

ServiceCreator/FXForwardFrontEnd instproc create_handler {srv_inst msg} {
    $self instvar agent_
    set h [new GWHandler/FXForwardFrontEnd $agent_ $srv_inst $msg]
    return $h;
}

ServiceCreator/MeGa instproc init { agent } {
	$self next $agent
	$self set sdp_ [new SDPParser]
}

ServiceCreator/MeGa instproc destroy {} {
	$self instvar sdp_
	delete $sdp_
}


ServiceCreator/MeGa instproc create_handler { srv_inst msg } {
	$self instvar sdp_ agent_
	set msg [$sdp_ parse $msg]
	set gspec [$msg set caddr_]

	set media [$msg set allmedia_]
	set fmt [$media set fmt_]
	set mtype [$media set mediatype_]
	set rport [$media set port_]

	set clientaddr [$msg set createaddr_]

	if [$msg have_field b] {
		set bwval [$msg set bwval_]
	} else {
		# FIX THIS ###
		set bwval "default"
	}

	# For unicast use client address and use rport.  Otherwise, we pick
	# the port and address.
	set sport [$agent_ uniqport]
	if { $rport != 0 } {
		# unicast - use client recv port.
		set laddr $clientaddr
	} else {
		# multicast - we pick the ports.
		set rport $sport
		set laddr [$agent_ pick_mcastaddr]
	}

	# insert 'none' for format into specs
	set s [split $gspec /]
        set gspec [lindex $s 0]/[lindex $s 1]/none/[lindex $s 2]
	set lspec $laddr/$rport:$sport/none/1

	global gwstr
	if { $mtype == "video" } {
		set lscuba [$msg have_attr localscuba]
		set h [new GWHandler/VGW $agent_ $srv_inst $gspec $lspec $fmt \
				$lscuba $bwval]
	} else {
		set s $gwstr($mtype)
		set h [new GWHandler/$s $agent_ $srv_inst $gspec $lspec $fmt]
	}
	delete $msg
	return $h
}



ServiceCreator/Mars instproc create_handler {srv_inst msg} {

	$self instvar agent_

	# extract filename


	set h [new GWHandler/Mars $agent_ $srv_inst "" "" "" $msg]


	return $h


}

ServiceCreator/Aries instproc create_handler {srv_inst msg} {

	$self instvar agent_

	# extract filename


	set h [new GWHandler/Aries $agent_ $srv_inst "" "" "" $msg]


	return $h


}



GWHandler instproc init { agent sname gspec lspec fmt } {
	$self next

	$self instvar agent_ sname_ gspec_ lspec_ link_
	set agent_ $agent
	set sname_ $sname
	set gspec_ $gspec
	set lspec_ $lspec
	set link_ 0
	set format_ null
}

GWHandler instproc exec { fname } {
	$self instvar pid_ agent_ link_ gwctrl_

	if $link_ {
		$self instvar clientctrl_ bw_ ofmt_ gspec_ rportspec_

		# take out the format
		set s [split $gspec_ /]
		set sspec [lindex $s 0]/[lindex $s 1]/[lindex $s 3]
		set gspec_ none

		set linkargs "-megactrl $gwctrl_ -megaclient $clientctrl_ -sbw $bw_ -ofmt $ofmt_ -sspec $sspec -rport $rportspec_"
	} else {
		set linkargs "-megactrl $gwctrl_"
	}
	set execargs "[$self execargs] $linkargs"

	if { [$self get_option doFork] != "" } {
		set targ ">& /dev/null"
	} else {
		set targ ""
	}

	set path [$self get_option execPath]
	set execstr "$path/smash $fname $execargs"
	if { [catch "eval exec [list $execstr] $targ &" pid_] != 0 } {
		global errorCode
		$agent_ log "hm: error in exec of '$execstr': $errorCode"
		set pid_ -1
		return -1
	} else {
		$agent_ log "$execstr"
	}
	return 0
}


GWHandler/FXTemp instproc init {agent srv_int msg} {
    $self next $agent $srv_int "" "" "";

    $self instvar client_args_;

    set client_args_ $msg;
}

GWHandler/FXTemp instproc execargs {} {
    $self instvar client_args_ sname_

    return "$client_args_ -serv_inst $sname_"
}

GWHandler/FXForwardBackEnd instproc init {agent srv_int msg} {
    $self next $agent $srv_int "" "" "";

    $self instvar client_args_;

    set client_args_ $msg;
}

GWHandler/FXForwardBackEnd instproc execargs {} {
    $self instvar client_args_ sname_

    return "$client_args_ -serv_inst $sname_"
}

GWHandler/FXForwardFrontEnd instproc init {agent srv_int msg} {
    $self next $agent $srv_int "" "" "";

    $self instvar client_args_;

    set client_args_ $msg;
}

GWHandler/FXForwardFrontEnd instproc execargs {} {
    $self instvar client_args_ sname_

    return "$client_args_ -serv_inst $sname_"
}

GWHandler/RTPGW instproc destroy {} {
	$self instvar agent_ cb_
	if [info exists cb_] {
		$agent_ close_cb $cb_
	}

	$self next
}

GWHandler/RTPGW instproc exec { script } {
	$self instvar agent_ cb_
	set cb_ [$agent_ open_cb $self]
	$self init_callbacks

	$self next $script
}

GWHandler/RTPGW instproc alive { info } {
	$self instvar dstspec_
	if ![info exists dstspec_] {
		set dstspec_ 1
		$self cb_init
		update
	}
}

GWHandler/RTPGW instproc init_callbacks {} {
	$self next
	$self instvar cb_
	$cb_ register alive "$self alive"
	$cb_ register activate "$self src_activate"
}

GWHandler/RTPGW instproc src_activate { info src args } {
}

GWHandler/AGW instproc cb_init {} {
	$self instvar cb_ gspec_ lspec_ format_ dstspec_
	$cb_ send cb_init
	$cb_ send cb_sessions global=$gspec_!local=$lspec_
	$cb_ send cb_set global RC 0
	$cb_ send cb_set local RC 1
	$cb_ send cb_set global txonly 1
	$cb_ send cb_set local txonly 1

	$cb_ send cb_set global ofmt $format_
	$cb_ send cb_set local ofmt $format_
}


GWHandler/VGW instproc cb_init {} {
	$self instvar cb_ gspec_ lspec_ format_ dstspec_ lscuba_
	$cb_ send cb_init
	$cb_ send cb_sessions global=$gspec_!local=$lspec_
	if { $lscuba_ == "global" } {
		$cb_ send cb_set global RC 1
	} else {
		$cb_ send cb_set global RC 0
	}
	$cb_ send cb_set local RC 1
	if { $format_ == "null" } {
		$cb_ send cb_set local txonly 1
	}
	$cb_ send cb_set global color 1
	$cb_ send cb_set local color 1

	$cb_ send cb_set global ofmt $format_
	$cb_ send cb_set local ofmt $format_
	$self instvar agent_ cb_
	$agent_ log "DONE [$cb_ set channel_]"
}

GWHandler instproc cb_init {} {
}

GWHandler/VGW instproc init { agent sname gspec lspec fmt lscuba scubabw} {
	$self next $agent $sname $gspec $lspec $fmt

	$self instvar format_
	set format_ [$self rtp_type $fmt]
	if  { $format_ == "" } {
		set format_ null
	}

	$self instvar lscuba_
	if { $lscuba } {
		set lscuba_ local
	} else {
		set lscuba_ global
	}
	$self set gwname_ vgw
	$self set scubabw_ $scubabw
}

GWHandler/AGW instproc init { agent sname gspec lspec fmt } {
	$self next $agent $sname $gspec $lspec $fmt

	$self instvar format_
	set format_ [$self rtp_type $fmt]
	if  { $format_ == "" } {
		set format_ null
	}

	$self set gwname_ agw
}

GWHandler/SDGW instproc init args {
	eval $self next $args

	$self set gwname_ sdgw
}

GWHandler/MBGW instproc init args {
	eval $self next $args

	$self set gwname_ mbgw
}

GWHandler instproc execargs {} {
	return ""
}

GWHandler/VGW instproc execargs {} {
	$self instvar cb_ sname_ lscuba_ scubabw_
	set chan [$cb_ set channel_]

	return "-scuba $lscuba_ -scubabw $scubabw_ -usemega $sname_ -I $chan"
}

GWHandler/AGW instproc execargs {} {
	$self instvar cb_ sname_
	set chan [$cb_ set channel_]

	return "-usemega $sname_ -I $chan"
}

GWHandler/SDGW instproc execargs {} {
	$self instvar sname_ gspec_ lspec_

	return "-usemega $sname_ -gspec $gspec_ -lspec $lspec_"
}

GWHandler/MBGW instproc execargs {} {
	$self instvar sname_ gspec_ lspec_

	return "-usemega $sname_ -gspec $gspec_ -lspec $lspec_"
}

GWHandler/Mars instproc init {agent sname gspec lspec fmt ssd} {
	$self next $agent $sname $gspec $lspec $fmt
	$self instvar ssd_ serv_inst_

	set ssd_ $ssd
	set serv_inst_ $sname
}

GWHandler/Aries instproc init {agent sname gspec lspec fmt ssd} {
	$self next $agent $sname $gspec $lspec $fmt
	$self instvar ssd_ serv_inst_

	set ssd_ $ssd
	set serv_inst_ $sname
}
#
GWHandler/Mars instproc execargs {} {
	$self instvar ssd_ serv_inst_ agent_

	# check if we need a uniq port or not
	set unicast_port [lindex [split [lindex [split $ssd_ \n] 4]] 1]
	if { $unicast_port > 0 } {
		set uniqport [$agent_ uniqport]
		#FIXME:assume we will have at most 3 streams (audio + video + mb)
		$agent_ uniqport
		$agent_ uniqport
	} else {
		set uniqport 0
	}

	return "[list $ssd_] [list $serv_inst_] [list $uniqport]"
}


#
GWHandler/Aries instproc execargs {} {
	$self instvar ssd_ serv_inst_

	return "[list $ssd_] [list $serv_inst_]"
}
