# rtp-record-agent.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1996-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


import RTPAgent RTPApplication/Recorder

Module/RTPRecord instproc init {} {
	set nb_ 0
	$self next
}


# Used to record RTP packets.  We inherit from RTPAgent so that when a
# new source is discovered, the activate call does the right stuff for
# the recorder.
# Status: Beta
# Author: Angela Schuett

Class RTPRecordAgent -superclass RTPAgent


RTPRecordAgent instproc init { session addr } {
	$self instvar Media_ archive_session_
	set archive_session_ $session
	set media [$session media]
	set Media_ [string toupper [string index $media 0]][string range \
			$media 1 end]
	set app [new RTPApplication/Recorder $media]
	set ab [new AddressBlock $addr]
	eval $self next $ab
}

RTPRecordAgent instproc destroy {} {
	$self instvar streams_
	if [info exists streams_] {
		foreach strm $streams_ {
			delete $strm
		}
	}
	$self next
}



# Override RTP agent's default method.
# Called from C++ (through Source/RTP) when we start
# actively receiving data pkts from the given source.


RTPRecordAgent instproc activate src {
	$self instvar archive_session_ streams_
	set stream [new ArchiveStream/Record/RTP $archive_session_]
	set error [$stream bind $archive_session_]
	if { $error != "" } {
	    #FIXME attach  a null sink
	    $src data-handler [new Module/VideoDecoder/Null]
	    $src ctrl-handler ""
	    $self notify_observers archive_error $error
	    #FIXME
	    puts $error
	    exit 1
	    return
	}
	$stream write_headers
	set rcvr [new Module/RTPRecord]
	set crcvr [new Module/RTPRecordCtrl]
	$stream attach $rcvr $crcvr
	$stream source $src
	$rcvr attach $stream
	$crcvr attach $stream
	$src data-handler $rcvr
	$src ctrl-handler $crcvr

	lappend streams_ $stream

	$self next $src
}

RTPRecordAgent instproc deactivate src {
	# Close file??
	# Write data into catalog file??
	#puts "deactivate"
	$self next $src
}


# create-session called from RTPAgent
RTPRecordAgent instproc create_session {} {
	$self instvar Media_
	set session [new Session/RTP/${Media_}]
	if { $session == "" } {
		$self fatal "creation of Session/RTP/${Media_} failed"
		exit 1
	}

	return $session
}


ArchiveStream/Record/RTP instproc init { session } {
	$self instvar archive_session_
	set archive_session_ $session

	$self next $session
	$self init_file_header
}
