/*
 * mtrace.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/mash/mash-1/misc/mtrace.h,v 1.16 2002/02/03 04:11:42 lim Exp $
 */

#ifndef MASH_MTRACE_H
#define MASH_MTRACE_H


/*
 * IMPORTANT: If you change any of the #defines below, or add a new flag,
 * also update the tcl/common/mtrace.tcl file correspondingly
 */
typedef enum {
        trcNone =       0x00000000,
        trcNet =        0x00000001,
        trcSRM =        0x00000002,
        trcArchive =    0x00000004,
        trcMB =         0x00000008, /* MediaBoard */
        trcFCA =        0x00000010, /* Floor control Agent */
        trcLTS =        0x00000020, /* Logical Time System */
        trcTGMB=        0x00000040, /* TopGun MediaBoard */
        trcCB =         0x00000080, /* Coordination Bus */
	trcWC =         0x00000100, /* Web Cache */
        trcVerbose =    0x20000000, /* Verbose output */
        trcExcessive =  0x40000000, /* Excessively output */
        trcTmp =        0x80000000,
        trcAll =        0xFFFFFFFF
} MTrace_t;

#ifdef MTRACE

#include <stdarg.h>
#include <tclcl.h>
#include "misc/all-types.h"

class MTraceObject : public TclObject {
public:
	MTraceObject() : TclObject(), traceTypes(trcNone) { }
	~MTraceObject() { }

	void Flags(u_int32_t flags) {
		traceTypes = (MTrace_t)flags;
	}
	u_int32_t Flags() { return traceTypes; }
	void SetFlag(u_int32_t flag) {
		if (flag!=0)
			traceTypes = (MTrace_t) (traceTypes | flag);
		else
			traceTypes = (MTrace_t) flag;
	}
	void ResetFlag(u_int32_t flag) {
		traceTypes = (MTrace_t) ((u_int32_t)traceTypes & (~flag));
	}

	void Print(const char *fmt, ...);
	Bool IsSet(u_int32_t flag) {
		return (((u_int32_t)traceTypes & flag)==flag);
	}

	int command(int argc, const char*const* argv);

private:
	MTrace_t traceTypes;
};

class MLogObject {
public:
        MLogObject(uid_t uid=0);           // defaults to log files name:
                                           // /tmp/<addr>-<uid>.log
        MLogObject(const char* szFileName) { openLog(szFileName); }
        ~MLogObject() { closeLog(); }
        void openLog(const char* szFileName);
        void closeLog() {}
        void print(const char *fmt, ...);
private:
        FILE* logfile_;
};

extern MTraceObject *mtrace;


#define MTrace(flag, args)                                      \
do {                                                            \
	if ( mtrace && mtrace->IsSet(flag)==TRUE ) {            \
		mtrace->Print("[%s:%d] ", __FILE__, __LINE__);  \
		mtrace->Print args;                             \
		mtrace->Print("\n");                            \
	}                                                       \
} while (0)


#else // MTRACE

#define MTrace(type, args)

#endif // !MTRACE


#endif // MASH_MTRACE_H
