/*
 * drawboard.h --
 *
 *      1) DrawBoardTools exports simple drawing functions like drawline
 *         drawrect etc. - the intention is that we combine DrawBoard with a
 *         display mechanism e.g. tkWidget or tkCanvas and create a
 *         DrawingBoard
 *
 *      2) DrawBoardWgt inherits from DrawBoard and tkWidget, i.e. it is a
 *         version of drawboard that displays itself onto the tkwidget
 *
 *      History note:
 *          this module derives from NetView module of nam-0.8
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *  $Header: /usr/mash/src/repository/mash/mash-1/misc/drawboard.h,v 1.6 2002/02/03 04:11:42 lim Exp $
 */

#ifndef DRAWBOARD_H
#define DRAWBOARD_H

#include "str.h"
#include "tkwidget.h"
#include "transform.h"
#include "compat/tkcompat.h"

class DrawBoardTools : public TclObject
{
 public:
    DrawBoardTools(Tk_Window tkwin, int w, int h, XColor* pBg=NULL);
    ~DrawBoardTools();
    int rint(float x) { return int(x+0.5); }
    void line(float x0, float y0, float x1, float y1, XColor* color);
    void rect(float x0, float y0, float x1, float y1, XColor* color);
    void string(float x, float y, const char* s, int idx);
    void poly(const float* x, int n, XColor* color);
    void fill(const float* x, const float* y, int n, int color);
    void circle(float x, float y, float r, int color);

    void recalcMatrix();
    void setBBox(double x0, double y0, double x1, double y1);

    void resize(int width, int height);
    void fg2gc(XColor* color, GC& gc);
    GC getFontGCByIdx(int idx);
    Tk_Font getFontByIdx(int idx);
    int  setFontByIdx(int idx, const char* szFont, const char* szColor);
    void setBackGround(XColor *pBg);
    void clearOffScreen();
    void clearWindow();
    void draw(int isPartial);

    /* Tcl command hook */
    int command(int argc, const char*const* argv);

 protected:
    static int st_MaxFontN_;        /* maximum number of fonts to allow */

    /* transformation matrix to be used for all drawings */
    /* - used to map coordinates in the bounding box to width_ and height_ */
    Transform matrix_;

    /* coordinates of the bounding box for items */
    double bx0_, by0_, bx1_, by1_;

 private:
    /* target window to draw onto */
    Tk_Window tkwin_;
    /* offscreen bitmap for double buffering */
    Drawable offscreen_;
    /* size of the screen region occupied by the items */
    int width_, height_;
    GC bg_gc_;                  /* background GC */

    /* atlas we cannot free up the fontstructs with font ids alone, so have to
     *  keep the fontstructs for deletion in the end
     *  REVIEW: this should change with tk80, change it when you don't need
     *          to be compatible with tk42 anymore */

    /* array of GCs and Tk_Fonts indexed by font index */
    GC* arFontGCs_;
    Tk_Font* arTkfonts_;
};

class DrawBoardWidget: public TkWidget
{
 public:
    DrawBoardWidget(const char* path, const char* szDrawTools=NULL);
    virtual ~DrawBoardWidget();
    void draw(int isPartial);

    /* Called when full redraw is needed */
    virtual void draw() { draw(0); }
    /* Called when incremental redraw needed (i.e., no external damage) */
    virtual void update();
    virtual void resize();
    /*
     * Tcl command hooks.
     */
    virtual int command(int argc, const char*const* argv);

 private:
    DrawBoardTools* pDrawBdTools_;
    char* pOTclPainter_;
};


#endif /* #ifdef DRAWBOARD_H */
