/*
 * mash-init.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/mash/mash-1/mash-init.h,v 1.6 2002/02/07 03:17:39 wesley Exp $
 */


#ifndef MASH_INIT_H
#define MASH_INIT_H

extern void init_misc();
extern void init_tkmisc();

#ifdef __cplusplus
extern "C" {
#endif

extern char version[];

int Mash_TclInit(Tcl_Interp* interp);
int Mash_TkInit(Tcl_Interp* interp);

int Smash_Init(Tcl_Interp *interp);
int Mash_Init(Tcl_Interp *interp);

int Smash_AppInit(Tcl_Interp *interp);
int Mash_AppInit(Tcl_Interp *interp);


#ifdef WIN32

int Win_Tcl_Main(int argc, char **argv,
		 Tcl_AppInitProc* appInitProc);
int Win_Tk_Main(int argc, char **argv,
		Tcl_AppInitProc* appInitProc);

int outputErr(const char* szPrefix, Tcl_Interp* interp);
int Mash_TclPlatformInit(Tcl_Interp* interp);
int Mash_TkPlatformInit(Tcl_Interp* interp);
#define WIN32_OutputErr(interp, szPrefix) outputErr(szPrefix, interp)

#else

#define Mash_TclPlatformInit(interp) TCL_OK
#define Mash_TkPlatformInit(interp)  TCL_OK
#define WIN32_OutputErr(interp, szPrefix)

#endif


#ifdef __cplusplus
}
#endif


#endif /* MASH_INIT_H */
