/*
 * mosaic.h --
 *
 *      A Mosaic effect
 *
 * Copyright (c) 1993-2001 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/* @(#) $Header: /usr/mash/src/repository/mash/mash-1/fx/effects/mosaic.h,v 1.1 2002/02/07 04:18:02 chema Exp $ */


#ifndef mash_fx_effects_mosaic_h
#define mash_fx_effects_mosaic_h


#include "effect-module.h"
#include "effect-parameters.h"


class MosaicEffect : public EffectModule {
public:
	MosaicEffect(int decimation);
	int command(int argc, const char*const* argv);
	void trigger_effect (Uncompressed* input);

protected:
	struct real_parameter size0_;
	struct real_parameter size1_;
	struct real_parameter xpos0_;
	struct real_parameter xpos1_;
	struct real_parameter ypos0_;
	struct real_parameter ypos1_;
};



static class MosaicEffectClass : public TclClass {
public:
	MosaicEffectClass() : TclClass("Module/VideoEffect/Mosaic") {}
	TclObject* create(int argc, const char*const* argv) {
		if (argc != 5) {
			printf("invalid arguments passed to MosaicEffect\n");
			return (0);
		}
		int decimation = atoi(argv[4]);
		return (new MosaicEffect(decimation));
	}
} mosaicffect_class;


#endif

