/*
 * jpeg-hash.cc --
 *
 *      FIXME: This file needs a description here.
 */

/*
 * This code is derived from the Independent JPEG Group's JPEG software:
 *
 * Copyright (C) 1991, 1992, Thomas G. Lane.
 * This file is part of the Independent JPEG Group's software.
 * For conditions of distribution and use, see the accompanying
 * README.IJPG file.
 */

#include "jpeg.h"
#include "endian.h"

#include <stdlib.h>
#include <stdio.h>
#include <sys/param.h>
#include <netinet/in.h>

extern "C" {
void j_rev_dct_c(short*, u_char*);
void j_rev_dct(short*);
void init_pre_idct();
}

#if defined(__osf__) || defined(sgi)
#include <string.h>
#ifdef sgi
#include <bstring.h>
#endif
#elif !defined(__svr4__)
#include <bstring.h>
#endif

#define u_word u_int

/*
 * These two macros stolen from nv.
 */
/* Sick little macro which will limit x to [0..255] with logical ops */
#define UCLIMIT(x) ((t = (x)), (t &= ~(t>>31)), (t | ~((t-256) >> 31)))
/* A variant of above which will limit x to [-128..127] */
#define SCLIMIT(x) (UCLIMIT((x)+128)-128)

/*
 * ZAG[i] is the natural-order position of the i'th element of zigzag order.
 * If the incoming data is corrupted, huff_decode_mcu could attempt to
 * reference values beyond the end of the array.  To avoid a wild store,
 * we put some extra zeroes after the real entries.
 */
static const int ZAG[] = {
	0,  1,  8, 16,  9,  2,  3, 10,
	17, 24, 32, 25, 18, 11,  4,  5,
	12, 19, 26, 33, 40, 48, 41, 34,
	27, 20, 13,  6,  7, 14, 21, 28,
	35, 42, 49, 56, 57, 50, 43, 36,
	29, 22, 15, 23, 30, 37, 44, 51,
	58, 59, 52, 45, 38, 31, 39, 46,
	53, 60, 61, 54, 47, 55, 62, 63,
	/* extra entries in case k>63 below */
	0,  0,  0,  0,  0,  0,  0,  0,
	0,  0,  0,  0,  0,  0,  0,  0
};

class JpegDecoder_411 : public JpegDecoder {
 public:
	JpegDecoder_411(const config&);
	virtual int decode(u_char* in, int len);
};

class JpegDecoder_422 : public JpegDecoder {
 public:
	JpegDecoder_422(const config&);
	virtual int decode(u_char* in, int len);
};

JpegDecoder_411::JpegDecoder_411(const config& c) : JpegDecoder(c)
{
	decimation_ = 411;
}

JpegDecoder_422::JpegDecoder_422(const config& c) : JpegDecoder(c)
{
	decimation_ = 422;
}

JpegDecoder* JpegDecoder::create(const config& c)
{
	if (c.ncomp == 3 && c.comp[0].hsf == 2 &&
	    c.comp[1].hsf == 1 && c.comp[1].vsf == 1 &&
	    c.comp[2].hsf == 1 && c.comp[2].vsf == 1) {
		if (c.comp[0].vsf == 2)
			return (new JpegDecoder_411(c));
		if (c.comp[0].vsf == 1)
			return (new JpegDecoder_422(c));
	}
	return (0);
}

int quality_to_qfactor(int v)
{
	if (v < 1)
		v = 5000;
	else if (v < 50)
		v = 5000 / v;
	else if (v < 100)
		v = 200 - v * 2;
	else
		v = 1;

	return (v);
}

/*
 * Tables from IJPG software
 */
static const int std_luminance_quant_tbl[64] = {
  16,  11,  12,  14,  12,  10,  16,  14, 13,  14,  18,  17,  16,  19,  24,  40,
  26,  24,  22,  22,  24,  49,  35,  37, 29,  40,  58,  51,  61,  60,  57,  51,
  56,  55,  64,  72,  92,  78,  64,  68, 87,  69,  55,  56,  80, 109,  81,  87,
  95,  98, 103, 104, 103,  62,  77, 113, 121, 112, 100, 120,  92, 101, 103,  99
};

static const int std_chrominance_quant_tbl[64] = {
  17,  18,  18,  24,  21,  24,  47,  26, 26,  47,  99,  66,  56,  66,  99,  99,
  99,  99,  99,  99,  99,  99,  99,  99, 99,  99,  99,  99,  99,  99,  99,  99,
  99,  99,  99,  99,  99,  99,  99,  99, 99,  99,  99,  99,  99,  99,  99,  99,
  99,  99,  99,  99,  99,  99,  99,  99, 99,  99,  99,  99,  99,  99,  99,  99
};

static const unsigned char dc_luminance_bits[17] =
    { /* 0-base */ 0, 0, 1, 5, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0 };
static const unsigned char dc_luminance_val[] =
    { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 };

static const unsigned char dc_chrominance_bits[17] =
    { /* 0-base */ 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0 };
static const unsigned char dc_chrominance_val[] =
    { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 };

static const unsigned char ac_luminance_bits[17] =
    { /* 0-base */ 0, 0, 2, 1, 3, 3, 2, 4, 3, 5, 5, 4, 4, 0, 0, 1, 0x7d };
static const unsigned char ac_luminance_val[] =
    { 0x01, 0x02, 0x03, 0x00, 0x04, 0x11, 0x05, 0x12,
      0x21, 0x31, 0x41, 0x06, 0x13, 0x51, 0x61, 0x07,
      0x22, 0x71, 0x14, 0x32, 0x81, 0x91, 0xa1, 0x08,
      0x23, 0x42, 0xb1, 0xc1, 0x15, 0x52, 0xd1, 0xf0,
      0x24, 0x33, 0x62, 0x72, 0x82, 0x09, 0x0a, 0x16,
      0x17, 0x18, 0x19, 0x1a, 0x25, 0x26, 0x27, 0x28,
      0x29, 0x2a, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39,
      0x3a, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49,
      0x4a, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59,
      0x5a, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69,
      0x6a, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79,
      0x7a, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89,
      0x8a, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98,
      0x99, 0x9a, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
      0xa8, 0xa9, 0xaa, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6,
      0xb7, 0xb8, 0xb9, 0xba, 0xc2, 0xc3, 0xc4, 0xc5,
      0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xd2, 0xd3, 0xd4,
      0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xe1, 0xe2,
      0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea,
      0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8,
      0xf9, 0xfa };

static const unsigned char ac_chrominance_bits[17] =
    { /* 0-base */ 0, 0, 2, 1, 2, 4, 4, 3, 4, 7, 5, 4, 4, 0, 1, 2, 0x77 };
static const unsigned char ac_chrominance_val[] =
    { 0x00, 0x01, 0x02, 0x03, 0x11, 0x04, 0x05, 0x21,
      0x31, 0x06, 0x12, 0x41, 0x51, 0x07, 0x61, 0x71,
      0x13, 0x22, 0x32, 0x81, 0x08, 0x14, 0x42, 0x91,
      0xa1, 0xb1, 0xc1, 0x09, 0x23, 0x33, 0x52, 0xf0,
      0x15, 0x62, 0x72, 0xd1, 0x0a, 0x16, 0x24, 0x34,
      0xe1, 0x25, 0xf1, 0x17, 0x18, 0x19, 0x1a, 0x26,
      0x27, 0x28, 0x29, 0x2a, 0x35, 0x36, 0x37, 0x38,
      0x39, 0x3a, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48,
      0x49, 0x4a, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58,
      0x59, 0x5a, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68,
      0x69, 0x6a, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78,
      0x79, 0x7a, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
      0x88, 0x89, 0x8a, 0x92, 0x93, 0x94, 0x95, 0x96,
      0x97, 0x98, 0x99, 0x9a, 0xa2, 0xa3, 0xa4, 0xa5,
      0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xb2, 0xb3, 0xb4,
      0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xc2, 0xc3,
      0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xd2,
      0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda,
      0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9,
      0xea, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8,
      0xf9, 0xfa };

void JpegDecoder::defaults(JpegDecoder::config& c)
{
	c.width = 0;
	c.height = 0;

	c.precision = 8;
	c.ncomp = 3;
	/* Y */
	c.comp[0].id = 0;
	c.comp[0].hsf = 2;
	c.comp[0].vsf = 1;
	c.comp[0].quant_tbl_no = 0;
	/* U */
	c.comp[1].id = 1;
	c.comp[1].hsf = 1;
	c.comp[1].vsf = 1;
	c.comp[1].quant_tbl_no = 1;
	/* V */
	c.comp[2].id = 2;
	c.comp[2].hsf = 1;
	c.comp[2].vsf = 1;
	c.comp[2].quant_tbl_no = 1;

	c.dc_huffbits[0] = dc_luminance_bits;
	c.dc_huffval[0] = dc_luminance_val;
	c.dc_huffbits[1] = dc_chrominance_bits;
	c.dc_huffval[1] = dc_chrominance_val;
	c.ac_huffbits[0] = ac_luminance_bits;
	c.ac_huffval[0] = ac_luminance_val;
	c.ac_huffbits[1] = ac_chrominance_bits;
	c.ac_huffval[1] = ac_chrominance_val;
	for (int i = 2; i < 4; ++i) {
		c.ac_huffbits[i] = 0;
		c.ac_huffval[i] = 0;
		c.dc_huffbits[i] = 0;
		c.dc_huffval[i] = 0;
	}
	c.comp[0].dc_tbl_no = 0;
	c.comp[0].ac_tbl_no = 0;
	c.comp[1].dc_tbl_no = 1;
	c.comp[1].ac_tbl_no = 1;
	c.comp[2].dc_tbl_no = 1;
	c.comp[2].ac_tbl_no = 1;
}

void JpegDecoder::quantizer(JpegDecoder::config& c, int q)
{
	q = quality_to_qfactor(q);
	for (int i = 0; i < 64; i++) {
		int val = (q * std_luminance_quant_tbl[i] + 50) / 100;
		if (val < 0)
			val = 1;
		if (val > 32768)
			val = 32768;
		c.qtab[0][i] = val;
	}
	for (i = 0; i < 64; i++) {
		int val = (q * std_chrominance_quant_tbl[i] + 50) / 100;
		if (val < 0)
			val = 1;
		if (val > 32768)
			val = 32768;
		c.qtab[1][i] = val;
	}
}

JpegDecoder::JpegDecoder(const config& c) : color_(1), nojfif_(1),
	width_(-1), height_(-1), decimation_(0)
{
	for (int i = NUM_HUFF_TBLS; --i >= 0; ) {
		dcht_[i] = 0;
		acht_[i] = 0;
	}
	for (i = MAX_COMPS_IN_SCAN; --i >= 0; )
		comp_[i].frm = 0;

	bzero((char*)comp_, sizeof(comp_));
	init(c);
}

JpegDecoder::~JpegDecoder()
{
	freehufftab();
	delete comp_[0].frm;
}

void JpegDecoder::init(const config& c)
{
	restart_interval_ = 0;
	bcopy((char*)c.qtab, (char*)qt_, sizeof(qt_));
	ncomp_ = c.ncomp;/*FIXME*/
	if (width_ != c.width || height_ != c.height) {
		width_ = c.width;
		height_ = c.height;

		/*
		 * Allocate the frame store
		 */
		delete comp_[0].frm;
		int size = width_ * height_;
#ifdef notyet
		/*FIXME*/
#else
		/*FIXME this allocates more than we need for 4:1:1*/
		/*FIXME compute sizes based on decimation factors*/
		u_char* p = new u_char[2 * size];
		comp_[0].frm = p;
		p += size;
		comp_[1].frm = p;
		p += size / 2;
		comp_[2].frm = p;
		comp_[3].frm = 0;
		/* Initialize u,v planes to gray */
		memset((char*)comp_[1].frm, 0x80, size);
#endif
	}
	for (int i = ncomp_; --i >= 0; ) {
		int id = c.comp[i].id;
		comp_[id].hsf = c.comp[i].hsf;
		comp_[id].vsf = c.comp[i].vsf;
		comp_[id].quant_tbl_no = c.comp[i].quant_tbl_no;
		comp_[id].dc_tbl_no = c.comp[i].dc_tbl_no;
		comp_[id].ac_tbl_no = c.comp[i].ac_tbl_no;
	}
	/*
	 * FIXME should check if huffman table won't change
	 * before reallocating.
	 */
	freehufftab();
	for (i = 0; i < 4; ++i) {
		if (c.dc_huffval[i] != 0) {
			int id = c.comp[i].id;
			dcht_[id] = huffbuild(c.dc_huffbits[i],
					      c.dc_huffval[i]);
		}
		if (c.ac_huffval[i] != 0) {
			int id = c.comp[i].id;
			acht_[id] = huffbuild(c.ac_huffbits[i],
					      c.ac_huffval[i]);
		}
	}

	int maxh = 1;
	int maxv = 1;
	for (i = ncomp_; --i >= 0; ) {
		if (maxh < comp_[i].hsf)
			maxh = comp_[i].hsf;
		if (maxv < comp_[i].vsf)
			maxh = comp_[i].vsf;
	}
	ncol_ = (width_ + 8 * maxh - 1) / (8 * maxh);
	nrow_ = (height_ + 8 * maxv - 1) / (8 * maxv);
}

void JpegDecoder::freehufftab()
{
	for (int i = 0; i < 4; ++i) {
		if (dcht_[i] != 0)
			free(dcht_[i]);
		if (acht_[i] != 0)
			free(acht_[i]);
	}
}

void JpegDecoder::fill(u_int dc, u_char* out, int stride) const
{
	int t;
	dc = UCLIMIT(dc) & 0xff;
	dc |= dc << 8;
	dc |= dc << 16;
#ifdef INT_64
	INT_64 xdc = dc;
	xdc |= xdc << 32;
	*(INT_64 *)out = xdc;
	out += stride;
	*(INT_64 *)out = xdc;
	out += stride;
	*(INT_64 *)out = xdc;
	out += stride;
	*(INT_64 *)out = xdc;
	out += stride;
	*(INT_64 *)out = xdc;
	out += stride;
	*(INT_64 *)out = xdc;
	out += stride;
	*(INT_64 *)out = xdc;
	out += stride;
	*(INT_64 *)out = xdc;
#else
	*(u_word*)out = dc;
	*(u_word*)(out + 4) = dc;
	out += stride;
	*(u_word*)out = dc;
	*(u_word*)(out + 4) = dc;
	out += stride;
	*(u_word*)out = dc;
	*(u_word*)(out + 4) = dc;
	out += stride;
	*(u_word*)out = dc;
	*(u_word*)(out + 4) = dc;
	out += stride;
	*(u_word*)out = dc;
	*(u_word*)(out + 4) = dc;
	out += stride;
	*(u_word*)out = dc;
	*(u_word*)(out + 4) = dc;
	out += stride;
	*(u_word*)out = dc;
	*(u_word*)(out + 4) = dc;
	out += stride;
	*(u_word*)out = dc;
	*(u_word*)(out + 4) = dc;
#endif
}

/*
 * This routine mixes the DC & AC components of an 8x8 block of
 * pixels.  This routine is called for every block decoded so it
 * needs to be efficient.  It tries to do as many pixels in parallel
 * as will fit in a word.  The one complication is that it has to
 * deal with overflow (sum > 255) and underflow (sum < 0).  Underflow
 * & overflow are only possible if both terms have the same sign and
 * are indicated by the result having a different sign than the terms.
 * Note that underflow is more worrisome than overflow since it results
 * in bright white dots in a black field.
 * The DC term and sum are biased by 128 so a negative number has the
 * 2^7 bit = 0.  The AC term is not biased so a negative number has
 * the 2^7 bit = 1.  So underflow is indicated by (DC & AC & sum) != 0;
 */
#define JPEG_MIX_LOGIC \
	sum = dc + ac; \
	uflo = (dc ^ ac) & (dc ^ sum) & omask; \
	if (uflo) { \
		if ((ac = uflo & dc) != 0) { \
			/* integer overflows */ \
			ac |= ac >> 1; \
			ac |= ac >> 2; \
			ac |= ac >> 4; \
			sum |= ac; \
		} \
		if ((uflo &=~ ac) != 0) { \
			/* integer underflow(s) */ \
			uflo |= uflo >> 1; \
			uflo |= uflo >> 2; \
			uflo |= uflo >> 4; \
			sum &= ~uflo; \
		} \
	}

#ifdef INT_64
#define JPEG_MIX8(bp, out) \
	ac = *(INT_64*)(bp); \
	JPEG_MIX_LOGIC \
	*(INT_64*)(out) = sum; \
	(bp) += 8; \
	(out) += stride;
#else
#define JPEG_MIX4(bp, out) \
	ac = *(u_word*)(bp); \
	JPEG_MIX_LOGIC \
	*(u_word*)(out) = sum;

#define JPEG_MIX8(bp, out) \
	JPEG_MIX4(bp, out) \
	JPEG_MIX4(bp + 4, out + 4) \
	bp += 8; \
	out += stride;
#endif


void JpegDecoder::mix(u_int idc, const u_char* bp, u_char* out, int stride) const
{
	register int t;

	idc = UCLIMIT(idc) & 0xff;
	idc |= idc << 8;
	idc |= idc << 16;
#ifdef INT_64
	INT_64 dc = idc, ac, sum;
	dc |= dc << 32;
	INT_64 uflo, omask = 0x8080808080808080;
#else
	u_word dc = idc, ac, sum;
	u_word uflo, omask = 0x80808080;
#endif

	JPEG_MIX8(bp, out)
	JPEG_MIX8(bp, out)
	JPEG_MIX8(bp, out)
	JPEG_MIX8(bp, out)
	JPEG_MIX8(bp, out)
	JPEG_MIX8(bp, out)
	JPEG_MIX8(bp, out)
	JPEG_MIX8(bp, out)
}

#define MAXCODE 64
struct hcnode {
	struct hcnode *next;
	u_char pix[64];
	u_word n;
	u_word code[MAXCODE];
};

#define HASHSIZE (2*4096)
static struct hcnode *hashtab[HASHSIZE];
/*FIXME*/
#define NHC (2*HASHSIZE)
static struct hcnode *hcpool;
static int nhc;

static struct hcnode *
scavenge()
{
	register struct hcnode *p;

	int i = nhc;
	if (i >= NHC) {
		static int rover = 0;

		i = rover;
		do
			i = (i + 1) & (HASHSIZE - 1);
		while ((p = hashtab[i]) == 0);
		rover = i;
		hashtab[i] = p->next;
	} else {
		if (hcpool == 0)
			hcpool = new hcnode[NHC];
		p  = &hcpool[i];
		nhc = i + 1;
	}
	return (p);
}

static inline int
hchash(int n, u_word *code)
{
	int v = 0;

	while (--n >= 0)
		v += code[n] + 37;
	return ((v ^ v >> 16) & (HASHSIZE - 1));
}

static inline struct hcnode *
hclookup(int h, int n, u_word *code)
{
	struct hcnode *p;

	for (p = hashtab[h]; p != 0; p = p->next)
		if (p->n == n &&
		    bcmp((char*)p->code, (char*)code, n * sizeof(*code)) == 0)
			break;

	return (p);
}

static void
hcenter(struct hcnode *p, int h, int n, u_word *code, short* dctcoef)
{
	bcopy((char*)code, (char*)p->code, n * sizeof(*code));
	p->n = n;

	dctcoef[0] = 0;
	//j_rev_dct(dctcoef, p->pix);
	j_rev_dct(dctcoef);
	register u_int* pp = (u_int*)&p->pix[0];
	for (register int i = 0; i < 64; i += 4) {
		register int r, t;
#if BYTE_ORDER == LITTLE_ENDIAN
		r = SCLIMIT(dctcoef[i+3]) & 0xff;
		r = (r << 8) | (SCLIMIT(dctcoef[i+2]) & 0xff);
		r = (r << 8) | (SCLIMIT(dctcoef[i+1]) & 0xff);
		r = (r << 8) | (SCLIMIT(dctcoef[i]) & 0xff);
#else
		r = SCLIMIT(dctcoef[i]) & 0xff;
		r = (r << 8) | (SCLIMIT(dctcoef[i+1]) & 0xff);
		r = (r << 8) | (SCLIMIT(dctcoef[i+2]) & 0xff);
		r = (r << 8) | (SCLIMIT(dctcoef[i+3]) & 0xff);
#endif
		*pp++ = r;
	}

	p->next = hashtab[h];
	hashtab[h] = p;
}

int hcmiss;
int hchit;
int dcblk;
int bblk;
int sblk;

static int
length(struct hcnode *p)
{
	int n = 0;
	for (; p != 0; p = p->next)
		++n;
	return (n);
}

void
pstats()
{
	int i;
	int len;
	int bucket = 0;
	int maxlen = 0;

	for (i = 0; i < HASHSIZE; ++i) {
		if (hashtab[i] == 0)
			continue;
		++bucket;
		len = length(hashtab[i]);
		if (len > maxlen)
			maxlen = len;
	}
	printf("hit\t%d\n", hchit);
	printf("miss\t%d\n", hcmiss);
	printf("bucket\t%d\n", bucket);
	printf("maxlen\t%d\n", maxlen);
	printf("dcblk\t%d\n", dcblk);
	printf("bblk\t%d\n", bblk);
	printf("sblk\t%d\n", sblk);
}

#ifdef notdef
int JpegDecoder::decode_block(int ci, int off, int stride)
{
	int n, h;
	struct hcnode *p;
	const short* qt;
	int dc;
	short block[64];
	u_word code[128];

	/*FIXME*/
	component& c = comp_[ci];
	qt = qt_[c.quant_tbl_no];

	n = huffparse(ci, code);
	if (n == 0) {
		dc = c.dc * qt[0];
		fill((dc >> 3) + 128, c.frm + off, stride);
		++dcblk;
	} else if (n < MAXCODE) {
		++sblk;
		h = hchash(n, code);
		p = hclookup(h, n, code);
		if (p == 0) {
			++hcmiss;
			p = scavenge();
			if (huffblock(ci, n, code, block) < 0)
				return (-1);
			hcenter(p, h, n, code, block);
		} else
			++hchit;
		dc = c.dc * qt[0];
		mix((dc >> 3) + 128, p->pix, c.frm + off, stride);
	} else {
		u_char pix[64];

		++bblk;
		if (huffblock(ci, n, code, block) < 0)
			return (-1);
		//j_rev_dct_c(block, pix);
		j_rev_dct(block);
		for (register int i = 0; i < 64; ++i) {
			register int t;
			pix[i] = SCLIMIT(block[i]) & 0xff;
			//pix[i] = block[i];
		}
		mix(0, pix, c.frm + off, stride);
	}
	return (0);
}
#endif

short blk[320*240/64][64];
int skip;

int blkthresh = 100;

int blkdiff(short* b0, short* b1)
{
	int d = 0;
	for (int i = 0; i < 32; ++i) {
		int k = ZAG[i];
		int t = b0[k] - b1[k];
		if (t < 0)
			t = -t;
		d += t;
	}
	return (d < blkthresh);
}

/*FIXME*/
static int blkno;

int JpegDecoder::decode_block(int ci, int off, int stride)
{
	/*FIXME*/
	u_word code[128];
	int n = huffparse(ci, code);
	short block[64];
	if (huffblock(ci, n, code, block) < 0)
		return (-1);

	if (ci == 0) {
		int b = blkno++;
		if (blkdiff(block, blk[b])) {
			skip = 1;
			return (0);
		}
		bcopy((char*)block, (char*)blk[b], 64 * 2);
	}

	j_rev_dct(block);
	u_long Pix[64 / sizeof(u_long)];
	u_char* pix = (u_char*)Pix;

	for (int i = 0; i < 64; ++i) {
		int t;
		pix[i] = SCLIMIT(block[i]) & 0xff;
	}
	mix(128, pix, comp_[ci].frm + off, stride);

	return (0);
}
#ifdef notdef
#endif

int JpegDecoder::rdqt(const u_char* p)
{
	int len = *p++ << 8;
	len |= *p++;

	const u_char* ep = p + len - 2;
	while (p < ep) {
		int n = *p++;
		int prec = n >> 4;
		n &= 0x0F;
		if (n >= 4) {
			/*FIXME illegal number*/
			return (-1);
		}
		short* qt = qt_[n];
		for (int i = 0; i < 64; i++) {
			int v = *p++;
			if (prec)
				v = (v << 8) + *p++;
			qt[i] = v;
		}
	}
	return (len);
}

void JpegDecoder::restart()
{
	int c;
	nbb_ = 0;
	/*FIXMEwhat if ff is sitting in bit buffer?*/
	/* Scan for next JPEG marker */
	do {
		do {			/* skip any non-FF bytes */
			c = *inb_++;
		} while (c != 0xFF);
		do {
			/* skip any duplicate FFs */
			/* we don't increment nbytes here since extra FFs are legal */
			c = *inb_++;
		} while (c == 0xFF);
	} while (c == 0);		/* repeat if it was a stuffed FF/00 */
#ifdef notdef
	if (nbytes != 1)
		WARNMS2(cinfo->emethods,
			"Corrupt JPEG data: %d extraneous bytes before marker 0x%02x",
			nbytes-1, c);

#endif
#ifdef notdef
	if (c != (RST0 + cinfo->next_restart_num)) {
		/* Uh-oh, the restart markers have been messed up too. */
		/* Let the file-format module try to figure out how to resync. */
		(*cinfo->methods->resync_to_restart) (cinfo, c);
	} else
		TRACEMS1(cinfo->emethods, 2, "RST%d", cinfo->next_restart_num);
#endif
	/* Re-initialize DC predictions to 0 */
	for (int i = 0; i < MAX_COMPS_IN_SCAN; ++i)
		comp_[i].dc = 0;
#ifdef notdef
	cinfo->next_restart_num = (cinfo->next_restart_num + 1) & 7;
#endif
}

u_char* JpegDecoder::parseFIF(u_char* in)
{
	int t;
	while (in < end_) {
		if (*in++ != 0xff)
			continue;
		/*FIXME need more checks for buffer overflow*/
		switch (*in++) {

		default:
			/* Don't know.  Keep looking for SOS. */
			continue;

		case 0xdb:
			/* quantization table */
			t = rdqt(in);
			if (t < 0)
				/*FIXME*/
				return (end_);
			in += t;
			continue;

		case 0xdd:
			/* restart interval definition */
			t = *in++ << 8;
			t |= *in++;
			if (t != 4)
				/* FIXME bad length */
				;
			restart_interval_ = *in++ << 8;
			restart_interval_ |= *in++;
			restart_counter_ = 0;
			continue;

		case 0xda:
			/* start-of-scan marker */
			if (in + 2 <= end_) {
				/* skip over SOS */
				int t = *in++ << 8;
				t |= *in++;
				in += (t - 2);
			}
			return (in);
		}
	}
	/*FIXME*/
	return (end_);
}

int JpegDecoder_422::decode(u_char* in, int len)
{
	/*FIXME*/
	if (*in == 0xff)
		nojfif_ = 0;

	inb_ = in;
	end_ = in + len;
	nbb_ = 0;
	/*
	 * FIXME break this into a separate routine that gets called
	 * only when this crap is present
	 */
	if (!nojfif_)
		inb_ = parseFIF(inb_);

	int off0 = 0;
	int off1 = 0;
	huffreset();
	blkno = 0;/*FIXME*/
	for (int y = nrow_; --y >= 0; ) {
		for (int x = ncol_; --x >= 0; ) {
			if (restart_interval_) {
				if (--restart_counter_ <= 0) {
					restart_counter_ = restart_interval_;
					restart();
				}
			}
			skip = 0;
			if (decode_block(0, off0, width_) < 0)
				return (-1);
			off0 += 8;
			/*FIXME*/
			if (skip) {
				skip = 0;
				if (decode_block(0, off0, width_) < 0)
					return (-1);
				if (skip) {
					u_word code[128];
					off0 += 8;
					off1 += 8;
					(void)huffparse(1, code);
					(void)huffparse(2, code);
					continue;
				}
			} else
				if (decode_block(0, off0, width_) < 0)
					return (-1);
			off0 += 8;
			if (color_) {
				if (decode_block(1, off1, width_ / 2) < 0)
					return (-1);
				if (decode_block(2, off1, width_ / 2) < 0)
					return (-1);
				off1 += 8;
			} else if (huffskip(1) < 0 || huffskip(2) < 0)
				return (-1);
		}
		off0 -= width_;
		off0 += 8 * width_;
		off1 -= width_ / 2;
		off1 += 8 * width_ / 2;
	}
	return (0);
}

int JpegDecoder_411::decode(u_char* in, int len)
{
	/*FIXME*/
	if (*in == 0xff)
		nojfif_ = 0;

	inb_ = in;
	end_ = in + len;
	nbb_ = 0;
	/*
	 * FIXME break this into a separate routine that gets called
	 * only when this crap is present
	 */
	if (!nojfif_)
		inb_ = parseFIF(inb_);

	int off0 = 0;
	int off1 = 0;
	huffreset();
	for (int y = nrow_ / 2; --y >= 0; ) {
		for (int x = ncol_; --x >= 0; ) {
			if (restart_interval_) {
				if (--restart_counter_ <= 0) {
					restart_counter_ = restart_interval_;
					restart();
				}
			}
			/* FIXME this works only for hsamp = 2, vsamp = 2 */
			if (decode_block(0, off0, width_) < 0)
				return (-1);
			if (decode_block(0, off0 + 8, width_) < 0)
				return (-1);
			if (decode_block(0, off0 + 8 * width_, width_) < 0)
				return (-1);
			if (decode_block(0, off0 + 8 * width_ + 8, width_) < 0)
				return (-1);
			off0 += 16;
			if (color_) {
				if (decode_block(1, off1, width_ / 2) < 0)
					return (-1);
				if (decode_block(2, off1, width_ / 2) < 0)
					return (-1);
				off1 += 8;
			} else if (huffskip(1) < 0 || huffskip(2) < 0)
				return (-1);
		}
		off0 -= width_;
		off0 += 16 * width_;
		off1 -= width_ / 2;
		off1 += 8 * width_ / 2;
	}
	return (0);
}

/* Figure F.12: extend sign bit */

#ifdef notdef
#define huff_EXTEND(x,s)  ((x) < extend_test[s] ? (x) + extend_offset[s] : (x))

static const int extend_test[16] =   /* entry n is 2**(n-1) */
  { 0, 0x0001, 0x0002, 0x0004, 0x0008, 0x0010, 0x0020, 0x0040, 0x0080,
    0x0100, 0x0200, 0x0400, 0x0800, 0x1000, 0x2000, 0x4000 };

static const int extend_offset[16] = /* entry n is (-1 << n) + 1 */
  { 0, ((-1)<<1) + 1, ((-1)<<2) + 1, ((-1)<<3) + 1, ((-1)<<4) + 1,
    ((-1)<<5) + 1, ((-1)<<6) + 1, ((-1)<<7) + 1, ((-1)<<8) + 1,
    ((-1)<<9) + 1, ((-1)<<10) + 1, ((-1)<<11) + 1, ((-1)<<12) + 1,
    ((-1)<<13) + 1, ((-1)<<14) + 1, ((-1)<<15) + 1 };
#else
/* is this really faster? */
inline int
huff_EXTEND(int x, int s)
{
	register int b = x >> (s - 1);
	register int m = ((b & 1) - 1) << s;
	return ((x | m) + (~b & 1));
}
#endif

#define HUFFRQ(bb) \
 { \
	register int v; \
	register u_char *cp = inb_; \
 \
	bb <<= 16; \
	v = *cp++; \
	if (v == 0xff) ++cp; \
	bb |= v << 8; \
	v = *cp++; \
	if (v == 0xff) ++cp; \
	bb |= v; \
	inb_ = cp; \
 \
}

#define MASK(s) ((1 << (s)) - 1)

#define HUFF_DECODE(ht, nbb, bb, result) { \
	register int s_, v_; \
 \
	if (nbb < 16) { \
		HUFFRQ(bb); \
		nbb += 16; \
	} \
	v_ = (bb >> (nbb - 16)) & 0xffff; \
	s_ = (ht)[v_]; \
	nbb -= (s_ >> 8); \
	result = s_ & 0xff; \
 }

#define GET_BITS(n, nbb, bb, result) \
{ \
	nbb -= n; \
	if (nbb < 0)  { \
		HUFFRQ(bb); \
		nbb += 16; \
	} \
	(result) = ((bb >> nbb) & MASK(n)); \
}

#define SKIP_BITS(n, nbb, bb) \
{ \
	nbb -= n; \
	if (nbb < 0)  { \
		HUFFRQ(bb); \
		nbb += 16; \
	} \
}

int JpegDecoder::huffparse(int ci, u_word *code)
{
	component& p = comp_[ci];

	/* Decode a single block's worth of coefficients */

	/* Section F.2.2.1: decode the DC coefficient difference */
	register int bb = bb_;
	register int nbb = nbb_;
	u_short* ht = dcht_[p.dc_tbl_no];
	register int s, r;
	HUFF_DECODE(ht, nbb, bb, s);
	if (s != 0) {
		GET_BITS(s, nbb, bb, r);
		s = huff_EXTEND(r, s);
	}
	/* Convert DC difference to actual value, update predictor */
	s += p.dc;
	p.dc = s;

	/* Section F.2.2.2: decode the AC coefficients */
	ht = acht_[p.ac_tbl_no];
	register int n = 0;
	for (register int k = 1; k < 64; ) {
		/* Symbol-1 */
		register int v;
		HUFF_DECODE(ht, nbb, bb, v);
		s = v & 15;
		r = v >> 4;
		if (s != 0) {
			k += r;
			/* Symbol-2 */
			GET_BITS(s, nbb, bb, s);
			*code++ = (s << 8) | v;
			++n;
			++k;
		} else {
			if (r != 15)
				/* end of block */
				break;
			*code++ = v;
			++n;
			k += 16;
		}
	}
	nbb_ = nbb;
	bb_ = bb;

	return (n);
}

int JpegDecoder::huffskip(int ci)
{
	/* Decode a single block's worth of coefficients */

	/* Section F.2.2.1: decode the DC coefficient difference */
	register int bb = bb_;
	register int nbb = nbb_;
	component& p = comp_[ci];
	u_short* ht = dcht_[p.dc_tbl_no];
	register int s;
	HUFF_DECODE(ht, nbb, bb, s);
	if (s != 0) {
		SKIP_BITS(s, nbb, bb);
	}

	/* Section F.2.2.2: decode the AC coefficients */
	ht = acht_[p.ac_tbl_no];
	for (register int k = 1; k < 64; ) {
		/* Symbol-1 */
		register int v;
		HUFF_DECODE(ht, nbb, bb, v);
		s = v & 15;
		register int r = v >> 4;
		if (s != 0) {
			k += r;
			/* Symbol-2 */
			SKIP_BITS(s, nbb, bb);
			++k;
		} else {
			if (r != 15)
				/* end of block */
				break;
			k += 16;
		}
	}
	nbb_ = nbb;
	bb_ = bb;

	return (0);
}

void JpegDecoder::huffreset()
{
	nbb_ = 0;
	comp_[0].dc = 0;
	comp_[1].dc = 0;
	comp_[2].dc = 0;
	comp_[3].dc = 0;
}

/*
 * Build a 64k lookup table from the jpeg huffman table described
 * by the arguments.  The table is indexed by the next 16-bits
 * of the input stream.  The entry in the table tells us the
 * length (and value) of the next symbol.  (Of course, the value
 * is redundant with the input bits).
 */
u_short* JpegDecoder::huffbuild(const u_char* bits, const u_char* vals) const
{
	/* Figure C.1: make table of Huffman code length for each symbol */
	/* Note that this is in code-length order. */

	int nsym = 0;
	int huffsize[257];
	for (int codelen = 1; codelen <= 16; ++codelen) {
		for (int i = 1; i <= bits[codelen]; ++i)
			/*
			 * FIXME should sanity check that nsym stays
			 * below 256.
			 */
			huffsize[nsym++] = codelen;
	}
	huffsize[nsym] = 0;

	/* Figure C.2: generate the codes themselves */
	/* Note that this is in code-length order. */

	int code = 0;
	int si = huffsize[0];
	u_short huffcode[256];
	int p = 0;
	while (p < nsym) {
		while (huffsize[p] == si)
			huffcode[p++] = code++;

		code <<= 1;
		++si;
	}
	/*
	 * Build the direct-map lookup table.
	 */
	u_short *ht = new u_short[65536];
	bzero((char*)ht, 65536 * sizeof(u_short));
	for (int sym = 0; sym < nsym; ++sym) {
		int codelen = huffsize[sym];
		int nbit = 16 - codelen;
		int code = huffcode[sym] << nbit;
		int map = (codelen << 8) | vals[sym];
		/*
		 * The low nbit bits are don't cares.
		 * Spin through all possible combos.
		 */
		for (int n = 1 << nbit; --n >= 0; )
			ht[code | n] = map;
	}
	return (ht);
}

int JpegDecoder::huffblock(int ci, int n, u_word *code, short *blk) const
{
	register int k;
	register const short* qt;

	const component& p = comp_[ci];
	qt = qt_[p.quant_tbl_no];
	bzero((char*)blk, 64 * sizeof(*blk));
	/* Descale and output the DC coefficient (assumes ZAG[0] = 0) */
	blk[0] = p.dc * qt[0];

	/* Section F.2.2.2: decode the AC coefficients */
	/* Since zero values are skipped, output area must be zeroed
	   beforehand */
	for (k = 1; k < 64; ) {
		register int s, r;
		register int v;

		/*FIXME*/
		if (--n < 0)
			return (0);

		v = *code++;
		s = v & 0x0f;
		r = (v >> 4) & 0x0f;
		if (s != 0) {
			k += r;
			r = v >> 8;
			s = huff_EXTEND(r, s);
			/*
			 * Descale coefficient and output in natural
			 * (dezigzagged) order
			 */
			if (k >= 64)
				return (-1);
			s *= qt[k];
			/*
			 * Limit to a 12-bit signed value.
			 * Test for both conditions with a single
			 * conditional since this is rare.
			 */
			if ((s + 4096) & ~8191) {
				if (s < -4096)
					s = -4096;
				else if (s > 4095)
					s = 4095;
			}
			blk[ZAG[k]] = s;

			++k;
		} else {
			if (r != 15)
				/* end of block */
				break;
			k += 16;
		}
	}
	return (0);
}
