/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.code;

import bossa.syntax.LocatedString;
import bossa.syntax.Node;
import bossa.util.Internal;
import bossa.util.Location;
import gnu.bytecode.Access;
import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.ObjectType;
import gnu.bytecode.ParameterizedType;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.bytecode.TypeVariable;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import java.util.HashMap;
import mlsub.typing.BadSizeEx;
import mlsub.typing.FunType;
import mlsub.typing.Monotype;
import mlsub.typing.MonotypeConstructor;
import mlsub.typing.Polytype;
import mlsub.typing.TopMonotype;
import mlsub.typing.TypeConstructor;
import mlsub.typing.TypeSymbol;
import mlsub.typing.Typing;
import nice.tools.code.Import;
import nice.tools.code.SpecialArray;
import nice.tools.code.SpecialTypes;
import nice.tools.code.TupleType;
import nice.tools.code.TypeImport;
import nice.tools.typing.PrimitiveType;

public final class Types {
    private static HashMap tcToGBType;

    public static void set(TypeConstructor tc, Type type) {
        tcToGBType.put(tc, type);
    }

    private static void set(Monotype m, Type type) {
        tcToGBType.put(m, type);
    }

    public static Type get(TypeConstructor tc) {
        return (Type)tcToGBType.get(tc);
    }

    public static Type get(Monotype m) {
        return (Type)tcToGBType.get(m);
    }

    public static Type javaType(TypeConstructor tc) {
        Type res = Types.get(tc);
        if (res == null) {
            return Type.pointer_type;
        }
        return res;
    }

    public static void setBytecodeType(Monotype m) {
        TypeConstructor rigidTC;
        TypeConstructor tc;
        if ((m = nice.tools.typing.Types.equivalent(m)) instanceof mlsub.typing.TupleType) {
            Types.setBytecodeType(((mlsub.typing.TupleType)m).getComponents());
        }
        if ((tc = m.head()) == null) {
            return;
        }
        if (tc == PrimitiveType.arrayTC) {
            rigidTC = tc;
        } else {
            if (Types.get(tc) != null) {
                return;
            }
            rigidTC = Typing.lowestInstance(tc);
            if (rigidTC == null) {
                return;
            }
        }
        if (rigidTC == PrimitiveType.arrayTC) {
            Monotype param = ((MonotypeConstructor)m).getTP()[0];
            Types.setBytecodeType(param);
            Types.set(m, (Type)SpecialTypes.array(Types.javaTypeOrNull(param)));
        } else {
            Types.set(tc, Types.get(rigidTC));
        }
    }

    public static void setBytecodeType(Monotype[] ms) {
        for (int i = 0; i < ms.length; ++i) {
            Types.setBytecodeType(ms[i]);
        }
    }

    public static Type javaType(Monotype m) {
        Type res = Types.javaTypeOrNull(m);
        if (res != null) {
            return res;
        }
        return Type.pointer_type;
    }

    private static Type javaTypeOrNull(Monotype m) {
        Type res = Types.rawJavaType(nice.tools.typing.Types.equivalent(m));
        if (res == null) {
            return null;
        }
        boolean maybe = nice.tools.typing.Types.isMaybe(m.equivalent());
        if (maybe) {
            return Types.equivalentObjectType(res);
        }
        return res;
    }

    private static Type rawJavaType(Monotype m) {
        Type res = Types.get(m);
        if (res != null) {
            return res;
        }
        if (m instanceof mlsub.typing.TupleType) {
            return new TupleType(Types.javaType(((mlsub.typing.TupleType)m).getComponents()));
        }
        if (m instanceof FunType) {
            return Compilation.typeProcedure;
        }
        if (m == TopMonotype.instance) {
            return Type.pointer_type;
        }
        if (!(m instanceof MonotypeConstructor)) {
            return null;
        }
        MonotypeConstructor mc = (MonotypeConstructor)m;
        TypeConstructor tc = mc.getTC();
        if (tc == PrimitiveType.arrayTC) {
            return SpecialTypes.array(Types.javaTypeOrNull(mc.getTP()[0]));
        }
        return Types.javaType(tc);
    }

    public static Type[] javaType(Monotype[] ms) {
        if (ms == null) {
            return null;
        }
        Type[] res = new Type[ms.length];
        for (int i = 0; i < ms.length; ++i) {
            res[i] = Types.javaType(ms[i]);
        }
        return res;
    }

    public static Type javaType(Polytype t) {
        return Types.javaType(t.getMonotype());
    }

    public static Type lowestCommonSupertype(Monotype[] types) {
        Type res = Types.javaType(types[0]);
        for (int i = 1; res != null && i < types.length; ++i) {
            res = Type.lowestCommonSuperType(res, Types.javaType(types[i]));
        }
        if (res == null) {
            return Type.pointer_type;
        }
        return res;
    }

    static Type lowestCommonSupertype(Type[] types) {
        Type res = types[0];
        for (int i = 1; res != null && i < types.length; ++i) {
            res = Type.lowestCommonSuperType(res, types[i]);
        }
        if (res == null) {
            return Type.pointer_type;
        }
        return res;
    }

    public static Type lowestUpperBound(Expression[] exps) {
        if (exps.length == 0) {
            return Type.pointer_type;
        }
        Type res = Type.neverReturnsType;
        for (int i = 0; i < exps.length; ++i) {
            if ((res = Type.lowestCommonSuperType(res, exps[i].getType())) != null) continue;
            return Type.pointer_type;
        }
        return res;
    }

    public static Type componentType(ArrayType type, int rank) {
        if (type instanceof TupleType) {
            return ((TupleType)type).componentTypes[rank];
        }
        return type.getComponentType();
    }

    public static TypeConstructor typeConstructor(Type javaType) throws NotIntroducedClassException {
        TypeConstructor tc = Node.globalTypeScopeLookup(javaType.getName(), null);
        if (tc == null) {
            Internal.warning(javaType + " is not known");
            throw new NotIntroducedClassException(tc);
        }
        if (tc.getId() == -1) {
            throw new NotIntroducedClassException(tc);
        }
        return tc;
    }

    public static Monotype[] monotype(Type[] javaTypes, TypeVariable[] typeVariables, TypeSymbol[] niceTypeVariables) throws ParametricClassException, NotIntroducedClassException {
        int len = javaTypes.length;
        Monotype[] res = new Monotype[len];
        for (int i = 0; i < len; ++i) {
            res[i] = Types.monotype(javaTypes[i], true, typeVariables, niceTypeVariables);
        }
        return res;
    }

    public static Monotype monotype(Type javaType, boolean sure) throws ParametricClassException, NotIntroducedClassException {
        return Types.monotype(javaType, sure, null, null);
    }

    public static Monotype monotype(Type javaType, boolean sure, TypeVariable[] typeVariables, TypeSymbol[] niceTypeVariables) throws ParametricClassException, NotIntroducedClassException {
        Monotype res = Types.getMonotype(javaType, typeVariables, niceTypeVariables);
        if (javaType instanceof ObjectType && !(javaType instanceof TypeVariable)) {
            if (sure) {
                return nice.tools.typing.Types.sureMonotype(res);
            }
            return nice.tools.typing.Types.maybeMonotype(res);
        }
        return res;
    }

    private static Monotype getMonotype(Type javaType, TypeVariable[] typeVariables, TypeSymbol[] niceTypeVariables) throws ParametricClassException, NotIntroducedClassException {
        if (javaType.isVoid()) {
            return PrimitiveType.voidType;
        }
        if (javaType == SpecialTypes.intType) {
            return PrimitiveType.intType;
        }
        if (javaType == SpecialTypes.booleanType) {
            return PrimitiveType.boolType;
        }
        if (javaType == SpecialTypes.charType) {
            return PrimitiveType.charType;
        }
        if (javaType == SpecialTypes.byteType) {
            return PrimitiveType.byteType;
        }
        if (javaType == SpecialTypes.shortType) {
            return PrimitiveType.shortType;
        }
        if (javaType == SpecialTypes.longType) {
            return PrimitiveType.longType;
        }
        if (javaType == SpecialTypes.floatType) {
            return PrimitiveType.floatType;
        }
        if (javaType == SpecialTypes.doubleType) {
            return PrimitiveType.doubleType;
        }
        if (javaType instanceof ArrayType) {
            return new MonotypeConstructor(PrimitiveType.arrayTC, new Monotype[]{Types.monotype(((ArrayType)javaType).getComponentType(), true, typeVariables, niceTypeVariables)});
        }
        if (javaType instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)javaType;
            try {
                return new MonotypeConstructor(Types.typeConstructor(p.main), Types.monotype(p.parameters, typeVariables, niceTypeVariables));
            }
            catch (BadSizeEx ex) {
                throw new ParametricClassException(javaType.toString());
            }
        }
        if (javaType instanceof TypeVariable) {
            if (typeVariables != null) {
                for (int i = 0; i < typeVariables.length; ++i) {
                    if (typeVariables[i] != javaType) continue;
                    return (Monotype)((Object)niceTypeVariables[i]);
                }
            }
            Internal.warning("Type variable " + javaType.getName() + " is not known");
            throw new NotIntroducedClassException(null);
        }
        if (javaType == Type.pointer_type) {
            return TopMonotype.instance;
        }
        TypeConstructor tc = Node.globalTypeScopeLookup(javaType.getName(), null);
        if (tc == null) {
            Internal.warning(javaType.getName() + " is not known");
            throw new NotIntroducedClassException(tc);
        }
        if (tc.getId() == -1) {
            throw new NotIntroducedClassException(tc);
        }
        try {
            return nice.tools.typing.Types.unknownArgsMonotype(tc);
        }
        catch (BadSizeEx ex) {
            throw new ParametricClassException(tc.toString());
        }
    }

    public static final Type type(LocatedString name) {
        return Types.type(name.toString(), name.location());
    }

    public static final Type type(String s, Location loc) {
        if (s.length() == 0) {
            return null;
        }
        if (s.charAt(0) == '[') {
            Type res = Types.type(s.substring(1), loc);
            if (res == null) {
                return null;
            }
            return SpecialArray.create(res);
        }
        if (s.equals("void")) {
            return SpecialTypes.voidType;
        }
        if (s.equals("boolean")) {
            return SpecialTypes.booleanType;
        }
        if (s.equals("byte")) {
            return SpecialTypes.byteType;
        }
        if (s.equals("short")) {
            return SpecialTypes.shortType;
        }
        if (s.equals("int")) {
            return SpecialTypes.intType;
        }
        if (s.equals("long")) {
            return SpecialTypes.longType;
        }
        if (s.equals("char")) {
            return SpecialTypes.charType;
        }
        if (s.equals("float")) {
            return SpecialTypes.floatType;
        }
        if (s.equals("double")) {
            return SpecialTypes.doubleType;
        }
        return TypeImport.lookup(s, loc);
    }

    public static final Type typeRepresentationToBytecode(String type, Location loc) {
        if (type.charAt(0) == '[') {
            Type res = Types.typeRepresentationToBytecode(type.substring(1), loc);
            if (res == null) {
                return null;
            }
            return SpecialArray.create(res);
        }
        if (type.equals("Object") || type.equals("java.lang.Object")) {
            return Type.pointer_type;
        }
        TypeConstructor sym = Node.globalTypeScopeLookup(type, loc);
        return Types.get(sym);
    }

    public static Type equivalentObjectType(Type t) {
        if (t instanceof ObjectType) {
            return (ObjectType)t;
        }
        if (t == Type.boolean_type) {
            return Type.boolean_ctype;
        }
        if (t == Type.double_type || t == Type.float_type || t == Type.long_type || t == Type.int_type || t == Type.short_type || t == Type.byte_type) {
            return PrimType.number_type;
        }
        if (t == Type.char_type) {
            return PrimType.char_ctype;
        }
        if (t == Type.void_type) {
            return PrimType.void_type;
        }
        Internal.error("Equivalent type for " + t + " is not defined yet");
        return null;
    }

    public static void reset() {
        tcToGBType = new HashMap();
        Import.reset();
    }

    public static boolean legalAccess(TypeConstructor tc, String packageName) {
        Type type = Types.get(tc);
        if (!(type instanceof ClassType)) {
            return true;
        }
        return Access.legal((ClassType)type, packageName);
    }

    public static class NotIntroducedClassException
    extends Exception {
        public TypeSymbol symbol;

        NotIntroducedClassException(TypeSymbol symbol) {
            this.symbol = symbol;
        }
    }

    public static class ParametricClassException
    extends Exception {
        ParametricClassException(String message) {
            super(message);
        }
    }
}

