/*

Copyright (C) 2000, 2001, 2002 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <netdude/nd_debug.h>
#include <netdude/nd_prefs.h>
#include <netdude/nd_gui.h>
#include <netdude/nd_tcpdump.h>
#include <netdude/nd_packet_iterator.h>
#include "nd_tcp.h"
#include "nd_tcp_prefs.h"
#include "interface.h"

static GtkWidget *prefs;


static ND_PrefsEntry prefs_entries_tcp[] = {
  { "tcp_seqack_none",          ND_PREFS_INT, 1, ND_UNUSED, ND_UNUSED },
  { "tcp_seqack_once",          ND_PREFS_INT, 0, ND_UNUSED, ND_UNUSED },
  { "tcp_seqack_update_single", ND_PREFS_INT, 0, ND_UNUSED, ND_UNUSED },
  { "tcp_seqack_update_all",    ND_PREFS_INT, 0, ND_UNUSED, ND_UNUSED },
};


static void
tcp_prefs_refresh_trace(ND_Trace *trace, void *user_data)
{
  D(("Refreshing %s\n", trace->filename));
  nd_tcp_free_state(trace);
  nd_tcp_init_state(trace);
  nd_tcpdump_close(trace);
  nd_tcpdump_open(trace);

  if (nd_tcp_get_state_mode() == ND_TCP_STATE_UPDATE_ALL)
    {
      ND_PacketIterator     pit;

      D(("Refreshing TCP state for all packets\n"));
      for (nd_pit_init(&pit, trace, FALSE); nd_pit_get(&pit); nd_pit_next(&pit))
	nd_tcp_update_state(nd_pit_get(&pit), nd_pit_get_index(&pit));	  
    }

  nd_gui_list_update(trace, TRUE);

  return;
  TOUCH(user_data);
}



static void
tcp_prefs_apply_cb(GtkWidget *container,
		   ND_PrefsEntry *entries,
		   int num_entries)
{
  GtkWidget *w;

  D(("Apply options to TCP plugin\n"));

  nd_tcpdump_options_reset();
  
  w = gtk_object_get_data(GTK_OBJECT(container), "tcp_seqack_none");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)))
    {
      nd_tcpdump_options_add("-S");
      if (nd_tcp_set_state_mode(ND_TCP_STATE_NONE) !=
	  ND_TCP_STATE_NONE)
	{
	  nd_trace_registry_foreach(tcp_prefs_refresh_trace, NULL);
	}
      return;
    }

  w = gtk_object_get_data(GTK_OBJECT(container), "tcp_seqack_once");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)))
    {
      if (nd_tcp_set_state_mode(ND_TCP_STATE_ONCE) != 
	  ND_TCP_STATE_ONCE)
	{
	  nd_trace_registry_foreach(tcp_prefs_refresh_trace, NULL);
	}
      return;
    }

  w = gtk_object_get_data(GTK_OBJECT(container), "tcp_seqack_update_single");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)))
    {
      if (nd_tcp_set_state_mode(ND_TCP_STATE_UPDATE_SINGLE) !=
	  ND_TCP_STATE_UPDATE_SINGLE)
	{
	  nd_trace_registry_foreach(tcp_prefs_refresh_trace, NULL);
	}
      return;
    }
    
  w = gtk_object_get_data(GTK_OBJECT(container), "tcp_seqack_update_all");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)))
    {
      if (nd_tcp_set_state_mode(ND_TCP_STATE_UPDATE_ALL) !=
	  ND_TCP_STATE_UPDATE_ALL)
	{
	  nd_trace_registry_foreach(tcp_prefs_refresh_trace, NULL);
	}
      return;
    }

  return;
  TOUCH(entries);
  TOUCH(num_entries);
}


void      
nd_tcp_init_prefs(void)
{
  GtkWidget *gui;

  if (!prefs)
    {
      prefs = create_prefs_window();
      
      gui = gtk_object_get_data(GTK_OBJECT(prefs), "tcp_gui");
      D_ASSERT_PTR(gui);
      gtk_container_remove(GTK_CONTAINER(prefs), gui);

      nd_prefs_add_domain(_("TCP"), prefs, gui, prefs_entries_tcp,
			  sizeof(prefs_entries_tcp) / sizeof(ND_PrefsEntry),
			  tcp_prefs_apply_cb);
    }
}

