/*

Copyright (C) 2000, 2001 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __nd_ip_h
#define __nd_ip_h

#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>

#include <netdude/nd_packet.h>
#include <netdude/nd_trace.h>
#include <netdude/nd_protocol.h>
#include <netdude/nd_gui.h>

#define ND_IP_PAYLOAD_LENGTH(iphdr) (ntohs(iphdr->ip_len) - (iphdr->ip_hl << 2))
#define ND_IP_PAYLOAD(iphdr) (((guchar *) iphdr) + (iphdr->ip_hl << 2))
#define ND_IP_FRAG_OFFSET(iphdr) ((ntohs(iphdr->ip_off) & IP_OFFMASK) << 3)

extern ND_MenuData ip_menu_p_data[];
extern ND_MenuData ip_menu_tos_data[];
extern ND_MenuData ip_menu_ecn_data[];


/* These are the implementations for IPv4 of ND_Protocol's callbacks: */
GtkWidget *nd_ip_create_gui(ND_Trace *trace, ND_ProtoInfo *pinf);
void       nd_ip_set_gui(const ND_Packet *packet, ND_ProtoInfo *pinf);
void       nd_ip_init_packet(ND_Packet *packet, u_char *data, u_char *data_end);
gboolean   nd_ip_header_complete(const ND_Packet *packet, guint nesting);
gboolean   nd_ip_fix_packet(ND_Packet *packet, int index);

/* Generic accessor function for the IPv4 Protocol implementation: */
inline ND_Protocol *nd_ip_get(void);

/* Helper function that reports whether a packet's checksum is okay
   or not, given its current content. The correct checksum is passed
   through the correct_sum pointer as a result, if the pointer is
   provided. */
guint16    nd_ip_checksum(const struct ip *iphdr);
gboolean   nd_ip_csum_correct(const struct ip *iphdr, guint16 *correct_sum);

/* Helper functions to set a trace's IP GUI table to a packet's content: */
void       nd_ip_set_gui_v(ND_ProtoInfo *pinf, struct ip *iphdr);
void       nd_ip_set_gui_hl(ND_ProtoInfo *pinf, struct ip *iphdr);
void       nd_ip_set_gui_ecn(ND_ProtoInfo *pinf, struct ip *iphdr);
void       nd_ip_set_gui_tos(ND_ProtoInfo *pinf, struct ip *iphdr);
void       nd_ip_set_gui_len(ND_ProtoInfo *pinf, struct ip *iphdr);
void       nd_ip_set_gui_id(ND_ProtoInfo *pinf, struct ip *iphdr);
void       nd_ip_set_gui_rf(ND_ProtoInfo *pinf, struct ip *iphdr);
void       nd_ip_set_gui_df(ND_ProtoInfo *pinf, struct ip *iphdr);
void       nd_ip_set_gui_mf(ND_ProtoInfo *pinf, struct ip *iphdr);
void       nd_ip_set_gui_off(ND_ProtoInfo *pinf, struct ip *iphdr);
void       nd_ip_set_gui_ttl(ND_ProtoInfo *pinf, struct ip *iphdr);
void       nd_ip_set_gui_p(ND_ProtoInfo *pinf, struct ip *iphdr);
void       nd_ip_set_gui_sum(ND_ProtoInfo *pinf, struct ip *iphdr);
void       nd_ip_set_gui_src(ND_ProtoInfo *pinf, struct ip *iphdr);
void       nd_ip_set_gui_dst(ND_ProtoInfo *pinf, struct ip *iphdr);
void       nd_ip_set_gui_options(ND_ProtoInfo *pinf, struct ip *iphdr,
				 const ND_Packet *packet);

#endif
