/*

Copyright (C) 2000, 2001, 2002 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#ifndef __nd_icmp_h
#define __nd_icmp_h

#include <netdude/nd.h>
#include <netdude/nd_types.h>

#include <netinet/in.h>
#include <netinet/ip_icmp.h>


/* ICMP packet structure -- using our own for the funky stuff ... */

struct nd_icmphdr
{
  /* Common to all types: */
  guint8    type;
  guint8    code;
  guint16   checksum;
  
  union
  {
    struct
    {
      guint16   id;
      guint16   sequence;
      guint32   orig_ts;
      guint32   recv_ts;
      guint32   trans_ts;
    } ts; /* Timestamp request/reply */

    struct
    {
      guint16   id;
      guint16   sequence;
      struct in_addr in;
    } in; /* Subnet mask query */

    struct
    {
      guchar  num_addr;
      guchar  addr_size;
      guint16 lifetime;
      guchar  addr_data;
    } adv; /* Router advertisement */
  } un;
};

extern ND_MenuData icmp_menu_type_data[];
extern ND_MenuData icmp_menu_unreach_code_data[];
extern ND_MenuData icmp_menu_redirect_code_data[];

/* These are the implementations of ND_Protocol's callbacks: */
GtkWidget *nd_icmp_create_gui(ND_Trace *trace, ND_ProtoInfo *pinf);
void       nd_icmp_set_gui(const ND_Packet *packet, ND_ProtoInfo *pinf);
void       nd_icmp_init_packet(ND_Packet *packet, guchar *data, guchar *data_end);
gboolean   nd_icmp_header_complete(const ND_Packet *packet, guint nesting);
gboolean   nd_icmp_fix_packet(ND_Packet *packet, int index);

gboolean   nd_icmp_message_complete(const ND_Packet *packet);

/* ICMP checksum functions */
guint16    nd_icmp_checksum(const ND_Packet *packet);
gboolean   nd_icmp_csum_correct(const ND_Packet *packet, guint16 *correct_sum);

/* Test if this is an icmp error message: */
gboolean   nd_icmp_header_is_error(struct icmphdr *icmphdr);

/* Generic accessor function for the protocol implementation: */
ND_Protocol *nd_icmp_get(void);

/* Helper functions to set a trace's GUI table to a packet's content: */
void       nd_icmp_set_gui_type(ND_ProtoInfo *pinf, struct icmphdr *icmphdr);
void       nd_icmp_set_gui_code(ND_ProtoInfo *pinf, struct icmphdr *icmphdr);
void       nd_icmp_set_gui_cksum(ND_ProtoInfo *pinf, struct icmphdr *icmphdr,
				 const ND_Packet *packet);

void       nd_icmp_set_gui_echo(ND_ProtoInfo *pinf, struct icmphdr *icmphdr,
				const ND_Packet *packet);

void       nd_icmp_set_gui_data(ND_ProtoInfo *pinf, struct icmphdr *icmphdr,
				const ND_Packet *packet);

void       nd_icmp_set_gui_timestamp(ND_ProtoInfo *pinf, struct icmphdr *icmphdr,
				     const ND_Packet *packet);

void       nd_icmp_set_gui_info(ND_ProtoInfo *pinf, struct icmphdr *icmphdr,
				const ND_Packet *packet);

void       nd_icmp_set_gui_addr(ND_ProtoInfo *pinf, struct icmphdr *icmphdr,
				const ND_Packet *packet);

void       nd_icmp_set_gui_router_adv(ND_ProtoInfo *pinf, struct icmphdr *icmphdr,
				      const ND_Packet *packet);

#endif
