#
#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  based on work from
#  (C) Tenable Network Security
#
#  Ref: Stefan Esser
#
#  This script is released under the GNU GPL v2
#

if(description)
{
 script_id(15914);
 script_version ("$Revision: 1.3 $");
 script_bugtraq_id(11790);
 if ( defined_func("script_xref") ) script_xref(name:"OSVDB", value:"12177");

 name["english"] = "Serendipity XSS flaw";

 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running Serendipity, a weblog written in PHP.

The remote version  of this software is vulnerable to cross-site 
scripting attack due to a lack of sanity checks on searchTerm 
parameter in the compat.php script.

With a specially crafted URL, an attacker can cause arbitrary
code execution resulting in a loss of integrity.

Solution : Upgrade to Serendipity 0.7.1 or newer
Risk factor : Medium";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the presence of Serendipity XSS flaw";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 David Maciejak");
 family["english"] = "CGI abuses : XSS";
 script_family(english:family["english"]);
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

function check(loc)
{
 req = http_get(item:string(loc, "/index.php?serendipity%5Baction%5D=search&serendipity%5BsearchTerm%5D=%3Cscript%3Efoo%3C%2Fscript%3E"), port:port);			
 r = http_keepalive_send_recv(port:port, data:req, bodyonly:1);
 if( r == NULL )exit(0);
 if ( egrep(pattern:"<script>foo</script>", string:r))
 {
 	security_warning(port);
	exit(0);
 }
}

foreach dir ( make_list("/blog", cgi_dirs()) )
{
  check(loc:dir);
}
