/* Copyright (C) 2003 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#ifndef myx_aux_functions_h
#define myx_aux_functions_h

#include <sys/types.h>
#include <string.h>
#include <errno.h>

#include "glib.h"
#define PCRE_STATIC
#include "pcre.h"

#if !defined(__WIN__) && !defined(_WIN32) && !defined(_WIN64)
  #include <stdio.h>
  #include <sys/types.h>
  #include <unistd.h>
  #include <sys/time.h>
#else
  #include <winsock2.h>
  #include <windows.h>
#endif

#if defined(__WIN__) || defined(_WIN32) || defined(_WIN64)
  //defined in windows
# define MYX_INT_PTR UINT_PTR
#else
# define min(a,b) ((a)<(b)?(a):(b))
# define max(a,b) ((a)>(b)?(a):(b))
# define MYX_INT_PTR intptr_t
#endif


#if defined(__WIN__) || defined(_WIN32) || defined(_WIN64)
  #define MYX_PUBLIC_FUNC __declspec(dllexport)
  #define _br "\r\n"
  #define MYX_PATH_SEPARATOR '\\'
#else
  #define MYX_PUBLIC_FUNC
  #define _br "\n"
  #define MYX_PATH_SEPARATOR '/'
#endif

#define MYX_ORDPTR(value)  ((void*)(unsigned long)(value))

#ifdef __cplusplus
extern "C" {
#endif

#if defined(__WIN__) || defined(_WIN32) || defined(_WIN64)
  #ifndef strcasecmp
    #define strcasecmp stricmp
    #define strncasecmp strnicmp
  #endif
  #define bigint __int64
#else
  #define bigint long long
#endif

#if defined(__WIN__) || defined(_WIN32) || defined(_WIN64)
  typedef unsigned int uint;   
  typedef unsigned char uint8;
  typedef unsigned char uchar;
  typedef signed char int8;                   
  typedef unsigned short uint16;                 
  typedef short int16;                  
  typedef unsigned long uint32;                 
  typedef long int32;   
  typedef unsigned long ulong;
  typedef __int64 longlong;
  typedef unsigned __int64 ulonglong;
  
  typedef LARGE_INTEGER MYX_TIMER_VALUE;
#else
  typedef unsigned char uint8;
  typedef unsigned char uchar;
  typedef signed char int8;                   
  typedef unsigned short uint16;
  typedef short int16;                  
  typedef unsigned long uint32;                 
  typedef long int32; 
  #ifndef __GLIBC__
    typedef unsigned long ulong;
  #endif
  typedef long long longlong;
  typedef unsigned long long ulonglong;

  typedef struct timeval MYX_TIMER_VALUE;
#endif

/*
 * Enums
 */


/*
 * Structs
 */


/*
 * Functions
 */
MYX_PUBLIC_FUNC char *hex_decode(const char *hex_str, int *ret_str_len);
MYX_PUBLIC_FUNC char *hex_encode(const char *binary_string, int len);
MYX_PUBLIC_FUNC char *iconv_char_name(const char *mysql_character_set_name);
MYX_PUBLIC_FUNC char *unquote_identifier(char *identifier);
MYX_PUBLIC_FUNC char *quote_identifier(const char *identifier);
MYX_PUBLIC_FUNC char *quote_identifier_with(const char *identifier, char quote_char);
MYX_PUBLIC_FUNC int split_schema_table(const char *ident, char **schema, char **table);
MYX_PUBLIC_FUNC char *mask_out_string(char *str, const char open_trigger, const char close_trigger, const char mask);
MYX_PUBLIC_FUNC char *mask_out_string_re(char *str, const char *open_re, const char open_trigger, const char close_trigger, const char mask);
MYX_PUBLIC_FUNC char *str_g_replace(char *str, const char *search, const char *replace);
MYX_PUBLIC_FUNC char *str_g_append(char *base_str, const char *addon);
MYX_PUBLIC_FUNC char *str_g_append_and_free(char *base_str, char *addon);
MYX_PUBLIC_FUNC char *str_g_insert(const char *base_str, const char *addon, unsigned int index);

MYX_PUBLIC_FUNC char *strmov(register char *dst, register const char *src);
MYX_PUBLIC_FUNC int strcmp2(const char *str1, const char *str2);
MYX_PUBLIC_FUNC int strcmp3(const char *str1, const char *str2);
MYX_PUBLIC_FUNC unsigned int strlen2(const char *str);
MYX_PUBLIC_FUNC char *strcpy2(char *dst, const char *src);
MYX_PUBLIC_FUNC char *utf8_str_trim(char *str);
MYX_PUBLIC_FUNC char *str_trim(char *str);
MYX_PUBLIC_FUNC char *str_left(char *dest, char *src, unsigned int len);
MYX_PUBLIC_FUNC char *str_right(char *dest, char *src, unsigned int len);
MYX_PUBLIC_FUNC int sub_str_count(char *search_str, const char *src);
MYX_PUBLIC_FUNC char *name_of_str(char *dst, const char *src);
MYX_PUBLIC_FUNC char *value_of_str(char *dst, const char *src);
MYX_PUBLIC_FUNC int set_value(char **string_list, unsigned int string_list_num, char *name, char *new_value);
MYX_PUBLIC_FUNC int get_str_index(char **string_list, unsigned int string_list_num, const char *search);

MYX_PUBLIC_FUNC void strlist_g_append(char ***list, char *value);

MYX_PUBLIC_FUNC int g_utf8_casecollate(const char *str1, const char *str2);

MYX_PUBLIC_FUNC int str_beginswith(const char *str, const char *substr);
MYX_PUBLIC_FUNC int str_endswith(const char *str, const char *substr);
MYX_PUBLIC_FUNC char *str_toupper(char *str);
MYX_PUBLIC_FUNC char *strdup_toupper(char *str);

#if defined(__WIN__) || defined(_WIN32) || defined(_WIN64)
MYX_PUBLIC_FUNC int get_value_from_registry(HKEY root_key, const char *sub_key, const char *key, const char *def, char *value);
MYX_PUBLIC_FUNC int set_value_to_registry(HKEY root_key, const char *sub_key, const char *key, const char *value);
#else
FILE *myx_popen(char *const argv[], pid_t *pid_ret);
int myx_pclose(FILE *f, pid_t pid);
int myx_read_timeout(FILE *f, int timeout, char *result, size_t result_len);
#endif

MYX_PUBLIC_FUNC char *get_local_os_name();
MYX_PUBLIC_FUNC char *get_local_hardware_info();

MYX_PUBLIC_FUNC int copy_file(const char *orig_file, const char *new_fil);
  
MYX_PUBLIC_FUNC bigint get_file_size(const char *filename); 

MYX_PUBLIC_FUNC char *strcasestr_len(const char *haystack, int haystack_len, const char *needle);

MYX_PUBLIC_FUNC char * get_value_from_text(const char *txt, int txt_length, const char *regexpr);
MYX_PUBLIC_FUNC char * get_value_from_text_ex(const char *txt, int txt_length, const char *regexpr, unsigned int substring_nr);
MYX_PUBLIC_FUNC char * get_value_from_text_ex_opt(const char *txt, 
                                                  int txt_length,
                                                  const char *regexpr,
                                                  unsigned int substring_nr,
                                                  int options_for_exec);

MYX_PUBLIC_FUNC const char *strfindword(const char *str, const char *word);

MYX_PUBLIC_FUNC char *subst_pcre(const char *pattern, const char *repl, 
                                 int flags, int max_matches,
                                 const char *string);

MYX_PUBLIC_FUNC char *subst_pcre_matches(const char *src, int *matches, int matchcount, const char *repl);

MYX_PUBLIC_FUNC void build_field_subst(const char ** column_name,
                                       const char ** column_name_end,
                                       MYSQL_FIELD * res_fields,
                                       MYSQL_FIELD * res_fields_end,
                                       unsigned int * i_field);

MYX_PUBLIC_FUNC int mysql_version_is_later_or_equal_than(MYSQL *mysql,
                                                         int major_version,
                                                         int minor_version);
MYX_PUBLIC_FUNC int mysql_full_version_is_later_or_equal_than(MYSQL *mysql,
                                                              int major_version, int minor_version,
                                                              int patchlevel);

MYX_PUBLIC_FUNC int use_schema_store_old_one(MYSQL * mysql,
                                             const char * schema_name,
                                             char ** old_schema_name);
MYX_PUBLIC_FUNC void restore_old_schema(MYSQL * mysql, char * old_schema_name);


MYX_PUBLIC_FUNC void timer_start(MYX_TIMER_VALUE *tval);
MYX_PUBLIC_FUNC double timer_stop(MYX_TIMER_VALUE *tval);

MYX_PUBLIC_FUNC void *vec_insert_resize(void *vec, guint size, guint *vecsize, guint pos, void *data);
MYX_PUBLIC_FUNC void *vec_remove(void *vec, guint size, guint *vecsize, guint pos);

MYX_PUBLIC_FUNC char *escape_xml_entities(const char *str);
MYX_PUBLIC_FUNC char *escape_html_entities(const char *str);
MYX_PUBLIC_FUNC char *unescape_html_entities(const char *str);

MYX_PUBLIC_FUNC int myx_mkdir(const char *filename, int mode);
  
#ifdef __cplusplus
};
#endif

#endif
