/* Copyright (C) 2005 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */


#ifndef _MGCANVAS_H_
#define _MGCANVAS_H_

#include <gtkmm/drawingarea.h>
#include <GL/gl.h>
#include <GL/glx.h>


#include <vector>

#include "myx_gc_canvas.h"

class MGCanvas : public Gtk::DrawingArea, CGCListener {
    GLXContext _context;
    
    CGenericCanvas *_canvas;
    double _zoom;
    double _offsetX, _offsetY;

    double _clickX, _clickY;
    
    TGCSelectionInfo _ocursorType;
    vector<Gdk::Cursor*> _cursors;
    
    virtual void on_realize();
    virtual bool on_expose_event(GdkEventExpose* event);
    virtual bool on_configure_event(GdkEventConfigure* event);

    virtual bool on_button_press_event(GdkEventButton* event);
    virtual bool on_button_release_event(GdkEventButton* event);
    virtual bool on_scroll_event(GdkEventScroll* event);
    virtual bool on_motion_notify_event(GdkEventMotion* event);
    
    virtual void OnChange(void* AObject, TGCChangeReason Reason);
    virtual void OnError(const char* Message);
    virtual void OnInvalidate(void);
    
    bool set_scroll_adjustments(Gtk::Adjustment& hadjustment,
                                Gtk::Adjustment& vadjustment);

    void update_viewport();
  public:
    MGCanvas();
    virtual ~MGCanvas();
    
    
    CGenericCanvas *canvas() { return _canvas; };
};

#endif /* _MGCANVAS_H_ */
