unit AdminReplication;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, InstanceSections, ComCtrls, ImgList,
  AdditionalClasses, myx_admin_public_interface, myx_public_interface,
  ApplicationDataModule, MySQLConnection, AuxFuncs,
  Options, MyxError, TntExtCtrls, TntComCtrls, TntStdCtrls, gnugettext;

type
  TAdminReplicationForm = class(TInstanceSectionForm)
    ReplicationPnl: TTntPanel;
    ReplicationPageControl: TTntPageControl;
    OverviewTabSheet: TTabSheet;
    Panel5: TTntPanel;
    OverviewBevel: TTntBevel;
    Label8: TTntLabel;
    Image3: TTntImage;
    Panel3: TTntPanel;
    BottomBtnPnl: TTntPanel;
    Button1: TTntButton;
    LogImageList: TImageList;
    ServerInformationTabSheet: TTabSheet;
    Panel1: TTntPanel;
    InformationBevel: TTntBevel;
    Label1: TTntLabel;
    Image1: TTntImage;
    Panel2: TTntPanel;
    ServerInformationListView: TTntListView;
    ReplOverviewPnl: TTntPanel;
    AddInstanceToMonitoringListBtn: TTntButton;
    RefreshBtn: TTntButton;
    RemoveInstancefromMonitoringListBtn: TTntButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ReplicationPnlResize(Sender: TObject);
    procedure GenerateReplicationOverview;
    procedure ReplicationPageControlChange(Sender: TObject);
    procedure RefreshHostList;

    procedure Disconnected(var Message: TMessage); message WM_Disconnected;
    procedure Reconnected(var Message: TMessage); message WM_Reconnected;
    procedure ServerInformationListViewSelectItem(Sender: TObject;
      Item: TListItem; Selected: Boolean);
    procedure AddInstanceToMonitoringListBtnClick(Sender: TObject);
    procedure RemoveInstancefromMonitoringListBtnClick(Sender: TObject);

    procedure CheckUserReplHostBtns;
    procedure RefreshBtnClick(Sender: TObject);
  private
    { Private declarations }
    ReplHosts: TMYX_REPL_HOSTS;
    UserReplHosts: TMYX_USER_REPL_HOSTS;

    UserReplHostsFilename: WideString;
  public
    { Public declarations }
  end;

var
  AdminReplicationForm: TAdminReplicationForm;

implementation

{$R *.dfm}

procedure TAdminReplicationForm.FormCreate(Sender: TObject);
begin
  InitForm(self);

  DockedPanel:=ReplicationPnl;

  //GenerateReplicationOverview;

  ReplHosts:=nil;
  UserReplHosts:=nil;

  UserReplHostsFilename:=MYXCommonOptions.UserDataDir+
    'mysqlx_replication_hosts_'+
    MySQLConn.user_connection.hostname+'.xml';

  if(MySQLConn.Connected)then
    RefreshHostList
  else
    DisableEnablePages(ReplicationPageControl, False);
end;

procedure TAdminReplicationForm.FormDestroy(Sender: TObject);
begin
  if(ReplHosts<>nil)then
    ReplHosts.Free;

  if(ReplHosts<>nil)then
    UserReplHosts.Free;
end;

procedure TAdminReplicationForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  //
end;

procedure TAdminReplicationForm.ReplicationPnlResize(Sender: TObject);
var InitSheetWidth, InitSheetHeight: integer;
begin
  InitSheetWidth:=563;
  InitSheetHeight:=451;

  //Adjust Page Control
  ReplicationPageControl.Width:=ReplicationPnl.Width-591+571;
  ReplicationPageControl.Height:=ReplicationPnl.Height-501+479;

  //Overview Tab Sheet
  OverviewBevel.Width:=OverviewTabSheet.Width-InitSheetWidth+535;

  ReplOverviewPnl.Width:=OverviewTabSheet.Width-InitSheetWidth+535;
  ReplOverviewPnl.Height:=OverviewTabSheet.Height-InitSheetHeight+353;

  //Information Tab Sheet
  InformationBevel.Width:=ServerInformationTabSheet.Width-InitSheetWidth+535;

  ServerInformationListView.Width:=OverviewTabSheet.Width-InitSheetWidth+535;
  ServerInformationListView.Height:=OverviewTabSheet.Height-InitSheetHeight+353;
end;

procedure TAdminReplicationForm.ReplicationPageControlChange(
  Sender: TObject);
begin
  ReplicationPnlResize(self);
end;

procedure TAdminReplicationForm.GenerateReplicationOverview;
var theReplModel: TReplicationModel;
  LizReplNode, AnnaReplNode, BettyReplNode, GraceReplNode: TReplicationNode;
begin
  theReplModel:=TReplicationModel.Create(ReplOverviewPnl);
  theReplModel.Parent:=ReplOverviewPnl;
  theReplModel.Align:=alClient;

  LizReplNode:=theReplModel.AddNode('Liz', rsRunning, 300, 40);

  AnnaReplNode:=theReplModel.AddNode('Anna', rsRunning, 180, 140);
  theReplModel.LinkNodes(LizReplNode, AnnaReplNode);
  BettyReplNode:=theReplModel.AddNode('Betty', rsRunning, 300, 160);
  theReplModel.LinkNodes(LizReplNode, BettyReplNode);
  GraceReplNode:=theReplModel.AddNode('Grace', rsRunning, 420, 140);
  theReplModel.LinkNodes(LizReplNode, GraceReplNode);
end;

procedure TAdminReplicationForm.RefreshHostList;
var PUserHosts: PMYX_USER_REPL_HOSTS;
  PReplHosts: PMYX_REPL_HOSTS;
  error: MYX_ADMIN_LIB_ERROR;
  i: integer;
  ListItem: TListItem;
begin
  ServerInformationListView.Items.Clear;

  if(ReplHosts<>nil)then
    ReplHosts.Free;

  if(UserReplHosts=nil)then
    if(FileExists(UserReplHostsFilename))then
    begin
      PUserHosts:=myx_read_repl_user_hosts(
        UserReplHostsFilename,
        @error);

      if(PUserHosts<>nil)then
      begin
        try
          UserReplHosts:=TMYX_USER_REPL_HOSTS.Create(PUserHosts);
        finally
          if(PUserHosts<>nil)then
            myx_free_repl_user_hosts(PUserHosts);
        end;
      end
      else
        UserReplHosts:=TMYX_USER_REPL_HOSTS.Create;
    end
    else
    begin
      UserReplHosts:=TMYX_USER_REPL_HOSTS.Create;
    end;

  if(UserReplHosts<>nil)then
  begin
    PReplHosts:=myx_show_repl_hosts_status(MySQLConn.MySQL,
      UserReplHosts.get_record_pointer, @error);
    if(error<>MYX_ADMIN_NO_ERROR)then
      raise EMyxSQLError.Create(_('Error while fetching the replication information.'),
        myx_mysql_errno(MySQLConn.MySQL),
        myx_mysql_error(MySQLConn.MySQL));

    if(PReplHosts<>nil)then
    begin
      try
        ReplHosts:=TMYX_REPL_HOSTS.create(PReplHosts);

        for i:=0 to ReplHosts.hosts.Count-1 do
        begin
          ListItem:=AddListViewItem(ServerInformationListView, nil,
            ReplHosts.hosts[i].host,
            Ord(ReplHosts.hosts[i].status),
            ReplHosts.hosts[i]);

          if(ReplHosts.hosts[i].server_id<>0)then
            ListItem.SubItems.Add(IntToStr(ReplHosts.hosts[i].server_id))
          else
            ListItem.SubItems.Add('');

          if(ReplHosts.hosts[i].port<>0)then
            ListItem.SubItems.Add(IntToStr(ReplHosts.hosts[i].port))
          else
            ListItem.SubItems.Add('');

          if(ReplHosts.hosts[i].is_master=1)then
            ListItem.SubItems.Add('MASTER')
          else
            ListItem.SubItems.Add('SLAVE');

          case ReplHosts.hosts[i].status of
            MYX_RHS_AVAILABLE:
              ListItem.SubItems.Add(_('Available'));
            MYX_RHS_NEW_HOST:
              ListItem.SubItems.Add(_('New Instance'));
          else
            ListItem.SubItems.Add(_('Not Available'));
          end;

          if(ReplHosts.hosts[i].is_master=1)then
          begin
            ListItem.SubItems.Add(ReplHosts.hosts[i].binlog_file);
            ListItem.SubItems.Add(ReplHosts.hosts[i].binlog_pos);
          end;
        end;
      finally
        myx_free_repl_hosts_status(PReplHosts);
      end;
    end;
  end;
end;

procedure TAdminReplicationForm.Disconnected(var Message: TMessage);
begin
  DisableEnablePages(ReplicationPageControl, False);
end;

procedure TAdminReplicationForm.Reconnected(var Message: TMessage);
begin
  DisableEnablePages(ReplicationPageControl, True);

  RefreshHostList;
end;

procedure TAdminReplicationForm.CheckUserReplHostBtns;
begin
  AddInstanceToMonitoringListBtn.Enabled:=False;
  RemoveInstancefromMonitoringListBtn.Enabled:=False;

  if(ServerInformationListView.Selected<>nil)then
    if(ServerInformationListView.Selected.Data<>nil)then
    begin
      if(TMYX_REPL_HOST(ServerInformationListView.Selected.Data).status=MYX_RHS_NEW_HOST)then
        AddInstanceToMonitoringListBtn.Enabled:=True
      else
        RemoveInstancefromMonitoringListBtn.Enabled:=True;
    end;
end;

procedure TAdminReplicationForm.ServerInformationListViewSelectItem(
  Sender: TObject; Item: TListItem; Selected: Boolean);
begin
  CheckUserReplHostBtns;
end;

procedure TAdminReplicationForm.AddInstanceToMonitoringListBtnClick(
  Sender: TObject);
var UserReplHost: TMYX_USER_REPL_HOST;
  ReplHost: TMYX_REPL_HOST;
begin
  if(ServerInformationListView.Selected<>nil)then
    if(ServerInformationListView.Selected.Data<>nil)then
    begin
      ReplHost:=TMYX_REPL_HOST(ServerInformationListView.Selected.Data);

      UserReplHost:=TMYX_USER_REPL_HOST.create(ReplHost.host);

      UserReplHosts.hosts.Add(UserReplHost);

      ReplHost.status:=MYX_RHS_AVAILABLE;
      ServerInformationListView.Selected.ImageIndex:=Ord(ReplHost.status);

      CheckUserReplHostBtns;

      if(UserReplHosts<>nil)then
        myx_save_repl_user_hosts(UserReplHosts.get_record_pointer,
          UserReplHostsFilename);
    end;
end;

procedure TAdminReplicationForm.RemoveInstancefromMonitoringListBtnClick(
  Sender: TObject);
var i: integer;
  ReplHost: TMYX_REPL_HOST;
begin
  if(ServerInformationListView.Selected<>nil)then
    if(ServerInformationListView.Selected.Data<>nil)then
    begin
      ReplHost:=TMYX_REPL_HOST(ServerInformationListView.Selected.Data);

      for i:=0 to UserReplHosts.hosts.Count-1 do
        if(CompareText(UserReplHosts.hosts[i].name, ReplHost.host)=0)then
        begin
          UserReplHosts.hosts.Delete(i);
          
          ReplHost.status:=MYX_RHS_NEW_HOST;
          ServerInformationListView.Selected.ImageIndex:=Ord(ReplHost.status);
          break;
        end;

      CheckUserReplHostBtns;

      if(UserReplHosts<>nil)then
        myx_save_repl_user_hosts(UserReplHosts.get_record_pointer,
          UserReplHostsFilename);
    end;
end;

procedure TAdminReplicationForm.RefreshBtnClick(Sender: TObject);
begin
  RefreshHostList;
  CheckUserReplHostBtns;
end;

end.
