// windowtable.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// Specialized WaveTable classes with ability to "window" an array of values
// internally.

#ifndef WINDOWTABLE_H
#ifdef __GNUG__
#pragma interface
#endif
#define WINDOWTABLE_H

#include "wavetable.h"

class WindowingTable : public WaveTable {
	typedef WaveTable Super;
public:
	WindowingTable(int size) : WaveTable(size) {}
	void applyTo(float* frame);
	void applyTo(double* frame);
};

class HanningWindow : public WindowingTable {
	typedef WindowingTable Super;
public:
	HanningWindow(int size=1024);
	virtual ~HanningWindow() {}
};

class HammingWindow : public WindowingTable {
	typedef WindowingTable Super;
public:
	HammingWindow(int size=1024);
	virtual ~HammingWindow() {}
};

#endif
