/***************************************************************************
                          asyncdns.cpp  -  description
                             -------------------
    begin                : Mon Oct 7 2002
    copyright            : (C) 2002 by Max Zaitsev
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "mutella.h"
#include "mthread.h"
#include "xsleep.h"
#include "tstring.h"
#include "common.h"
#include <fcntl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <unistd.h>

#include "asyncdns.h"
#include "asyncsocket.h"

class MADnsDelayed : public MAsyncSocket
{
public:
	MADnsDelayed();
	~MADnsDelayed();

	void Enqueue(MAsyncDns* pRequest);
protected:
	MMutex m_mutex;
	std::deque< TSmartPtr<MAsyncDns> > m_queueRequest;
	//
	SOCKET  m_hOtherSide;
	//
	virtual void OnReceive(int nErrorCode);
};

MAsyncDnsThread::MAsyncDnsThread()
{
	m_pDelayed = new MADnsDelayed;
	m_bContinue = true;
	m_nNextRequestID = 0;
}

MAsyncDnsThread::~MAsyncDnsThread()
{
	delete m_pDelayed;
}

void MAsyncDnsThread::run()
{
	MAsyncDns* pAD;
	hostent * phe;
	m_mutex.lock();
	while (1)
	{
		if (m_queue.empty())
			if(!m_wait.wait(&m_mutex))
				continue;
		if (!m_bContinue)
			break;
		pAD = m_queue.front();
		m_mutex.unlock();
		//
		g_GetHostByNameMutex.lock();
		phe = ::GetHostByName(pAD->m_sHostName.c_str());
		pAD->m_errno = errno;
		if (phe)
		{
			memcpy(&pAD->m_nHostS_addr, phe->h_addr_list[0], 4);
			pAD->m_bSuccess = true;
		}
		g_GetHostByNameMutex.unlock();
		//
		pAD->m_bFinished = true;
		//
		if (pAD->m_bSuccess)
			pAD->OnResolve();
		else
			pAD->OnError();
		//
		pAD->m_wait.wakeAll();
		m_mutex.lock();
		//
		m_pDelayed->Enqueue(pAD);
		m_queue.pop();
	}
	m_mutex.unlock();
}

long MAsyncDnsThread::NextRequestID()
{
	MLock lock(m_mutex);
	if (m_nNextRequestID < 0)
		m_nNextRequestID = 0;
	return m_nNextRequestID++;
}

void MAsyncDnsThread::AddRequest(MAsyncDns* pAD)
{
	MLock lock(m_mutex);
	m_queue.push(pAD);
	m_wait.wakeAll();
}

static MAsyncDnsThread* s_pAsyncDnsThread = NULL;

void MAsyncDnsThread::StopThread()
{
	if (s_pAsyncDnsThread)
	{
		s_pAsyncDnsThread->m_mutex.lock();
		s_pAsyncDnsThread->m_bContinue = false;
		s_pAsyncDnsThread->m_wait.wakeAll();
		if (!s_pAsyncDnsThread->finished())
			s_pAsyncDnsThread->wait(&s_pAsyncDnsThread->m_mutex);
		s_pAsyncDnsThread->m_mutex.unlock();
		delete s_pAsyncDnsThread;
		s_pAsyncDnsThread = NULL;
	}
}

/////////////////////////////////////////////////////////////////////////////////

MADnsDelayed::MADnsDelayed()
{
	int sock_pair[2];
	if (socketpair(AF_UNIX, SOCK_STREAM, 0, sock_pair))
	{
		cout << "Failed to create pair of sockets\n";
		exit(1);
	}
	// make sockets non-blocking
	::fcntl(sock_pair[0],F_SETFL,O_NONBLOCK);
	::fcntl(sock_pair[1],F_SETFL,O_NONBLOCK);
	// disable Nagle algorithm
	//int val = 1;
	//setsockopt(sock_pair[0],SOL_SOCKET,SO_NODELAY,(char*)&val,sizeof(val));
	//setsockopt(sock_pair[1],SOL_SOCKET,SO_NODELAY,(char*)&val,sizeof(val));
	//
	m_hOtherSide = sock_pair[0];
	Attach(sock_pair[1],FD_READ);
}

MADnsDelayed::~MADnsDelayed()
{
	::close(m_hOtherSide);
}

void MADnsDelayed::Enqueue(MAsyncDns* pRequest)
{
	m_mutex.lock();
	m_queueRequest.push_back(pRequest);
	//
	::send(m_hOtherSide, "d", 1, 0);
	//
	m_mutex.unlock();
}

void MADnsDelayed::OnReceive(int nErrorCode)
{
	static char tmp[128];
	MAsyncDns* pAD;
	m_mutex.lock();
	while (m_queueRequest.size())
	{
		pAD = m_queueRequest.front();
		m_mutex.unlock();
		// call the async notifiers
		if (pAD->m_bSuccess)
			pAD->OnResolveDelayed();
		else
			pAD->OnErrorDelayed();
		//
		m_mutex.lock();
		m_queueRequest.pop_front();
	}
	//
	while (Receive(tmp, 128)>0);
	//
	m_mutex.unlock();
}

///////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////

MAsyncDns::MAsyncDns(const CString& sHost) :
	m_bFinished (false),
	m_bSuccess (false),
	m_errno (0),
	m_sHostName (sHost)
{
	m_nHostS_addr = 0;
	//
	if (!s_pAsyncDnsThread)
	{
		s_pAsyncDnsThread = new MAsyncDnsThread();
		s_pAsyncDnsThread->start(); // this is in principle a race condition
	}
	m_nRequestID = s_pAsyncDnsThread->NextRequestID();
	s_pAsyncDnsThread->AddRequest(this);
}

MAsyncDns::~MAsyncDns()
{
	ASSERT(m_bFinished);
}

void MAsyncDns::Wait()
{
	m_mutex.lock();
	m_wait.wait(&m_mutex);
	m_mutex.unlock();
}


