#include <iostream>
#include <fstream>
#include <string>

using namespace std;
int main(int argc, char **argv)
{
  if (argc <  3 || argc > 5)
    {
      cerr << "usage: " << argv[0] << " [--strip-trailing] [--no-static] <filename> <arrayname> " << endl;
      exit(1);
    }

  bool do_strip_trailing = false;
  string static_decl("static ");
  int i = 1;
  if (string(argv[i]) == "--strip-trailing")
    {
      do_strip_trailing = true;
      i++;
    }
  if (string(argv[i]) == "--no-static")
    {
      static_decl = "";
      i++;
    }
  ifstream fin(argv[i++]);
  string arr(argv[i++]);

  if (!fin)
    {
      cerr << "could not open " << argv[1] << " for reading" << endl;
      exit(1);
    }

  char c;
  string dat;
  while(fin.get(c))
    dat += c;

  if (do_strip_trailing)
    {
      int last = dat.find_last_not_of(" \t\n");
      dat.erase(last + 1);
    }

  cout << "// DO NOT EDIT\n"
       << "// this file is automatically generated from " << argv[do_strip_trailing?2:1] << ",\n"
       << "// any changes you make will be destroyed when it is regenerated\n"
       << "\n\n"
       << static_decl
       << "char const " << arr << "_constant[" << (dat.size() + 1) << "] = {\n";
  
  for (unsigned int i = 0; i < dat.size(); ++i)
    {
      if (i == 0) cout << "\t";
      else if (i % 20 == 0) cout << ",\n\t";
      else cout << ", ";
      cout << static_cast<int>(dat[i]);
    }
  cout << ", 0\n};\n";
}
