/* 
 *   Creation Date: <2002/01/09 22:42:56 samuel>
 *   Time-stamp: <2002/01/20 20:15:40 samuel>
 *   
 *	<MolExt.h>
 *	
 *	
 *   
 *   Copyright (C) 2002 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#ifndef _H_MOLEXT
#define _H_MOLEXT

#include <IOKit/IOService.h>


class MolExt : public IOService {

	OSDeclareDefaultStructors(MolExt)

public:
	virtual bool 		init( OSDictionary *dictionary = 0 );
	virtual void		free( void );
	virtual bool		attach( IOService *provider);
	virtual void		detach( IOService *provider);
	virtual IOService	*probe(IOService *provider, SInt32 *score );
	
	virtual bool		start( IOService *provider );
	virtual void		stop( IOService *provider );

	virtual IOReturn	newUserClient( task_t owningTask, void *security_id, UInt32 type, 
					       IOUserClient **handler );
#if 0
	/* Client functions */
	IOReturn		ccGetMolModVersion( int *ret );
	IOReturn		ccMapMregs( int sess_id, char **ret_addr );
	IOReturn		ccInit( int wanted_sess_id, int sess_magic );
	IOReturn		ccCleanup(  int sess_id );
#endif
#if 0
	/* DEBUG/TEST */
	IOReturn		clientFunc0( void );
	IOReturn		clientFunc1( int arg1, int arg2 );
	IOReturn		clientFunc2( int arg1, int *ret1 );
	IOReturn		clientFunc3( int arg1, int arg2, int *data, IOByteCount count );

	IOReturn		clientFunc4(  int *in, int *out, IOByteCount inSize, IOByteCount *outSize );

	IOReturn		clientFunc5( int scalar1, int scalar2, void *retdata );
	IOReturn		clientFunc6( int scalar1, int scalar2, void *retdata, IOByteCount *length );
#endif
};


#endif   /* _H_MOLEXT */
