///////////////////////////////////////////////////////////////////////////////
// $Id: tilegroup.h,v 1.3 2004/09/29 20:08:08 krake Exp $
//
// Package:   MOAGG Edit - Level Editor for MOAGG
// Copyright: Kevin Krammer, 2003
//
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
///////////////////////////////////////////////////////////////////////////////

/*! \file    tilegroup.h
    \author  Kevin Krammer, kevin.krammer@gmx.at
    \brief   Declaration of the tile group/category class
*/

#ifndef TILEGROUP_H
#define TILEGROUP_H

// Qt includes
#include <qintdict.h>

// forward declarations
class QImage;
class QPixmap;
class TileCache;

///////////////////////////////////////////////////////////////////////////////

//! This class holds the tile pixmaps for a single category
/*!
*/

class TileGroup {
public:
	TileGroup();
	TileGroup(const TileGroup& other) {
		copy(other);
	}

	~TileGroup();

	TileGroup& operator=(const TileGroup& other) {
		if (&other == this) return *this;
		copy(other);

		return *this;
	}

	bool load(const QString& filename);

	void setName(const QString& name) { m_name = name; }

	QString name() const { return m_name; }

	uint count() const { return m_count; }

	QPixmap* pixmap(uint index);

	TileCache* createPixmapCache(int alpha, int brightness);
	
protected:
	QString m_name;
	uint m_count;
	QIntDict<QImage>  m_images;
	QIntDict<QPixmap> m_pixmaps;

private:
	void copy(const TileGroup& other);
};

#endif

// End of file

