#!/usr/bin/env perl
#   @author DanielD
#
#   ========== licence begin  GPL
#   Copyright (c) 2004 SAP AG
#
#   This program is free software; you can redistribute it and/or
#   modify it under the terms of the GNU General Public License
#   as published by the Free Software Foundation; either version 2
#   of the License, or (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#   ========== licence end


sub buildpython {
    my ($sourceroot, $buildtoolsTarget) = @_;
    my ($pythonarchive) =  "$sourceroot/extern/python/Python-2.3.4.tgz";
    my ($pythondir) = 'Python-2.3.4';

    if (! -r "$pythondir/configure") {
        system ("gunzip -c $pythonarchive | tar xf -") == 0
            or die "unpack of sources failed";
    }

    chdir $pythondir || die "chdir failed";

    if (! -r "Makefile") {
        system ("./configure --prefix=$buildtoolsTarget/python --bindir=$buildtoolsTarget/python") == 0
            or die "configure step failed";
    }
    if (! -x "python") {
        system ("make") == 0
            or die  "make failed";
    }
    if (! -x "$buildtoolsTarget/python/python") {
        system ("make install") == 0
            or die "make install failed";
    }
    if (! -x "$buildtoolsTarget/python/python") {
	system ("cp python "$buildtoolsTarget/python/python");
    }
}

&buildpython ($ENV{sourceroot}, $ENV{buildtoolsTarget});


