(* @(#)pascl/p1m2.P

    ========== licence begin LGPL
    Copyright (C) 2002 SAP AG

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    ========== licence end

 *)

(* p1m2.p *)

#include "../common/globals.i"
#include "../common/stab.h"
#include "../pascl/globals1.i"
#include "../pascl/scanner.h"
#include "../pascl/pcexit.h"
#include "../pascl/p1m2.h"

const
   LongMsg = 49;
   ShortMsg = 40;

type
   LongString = packed array [1..51] of char;
   ShortString = packed array [1..21] of char;

var
   LongErrorMsg: array [0 .. LongMsg] of LongString;
   ShortErrorMsg : array [0 .. ShortMsg] of ShortString;
   Column : integer;
   errpfx : char;


procedure P1m2I;

var
    i, j : integer;

begin
   (* initialize long error messages               *)
   (* message is specified by array index + 100    *)
                   (* '12345678901234567890123456789012345678901234567890' *)
   LongErrorMsg[0] := 'Invalid constant expression\0';
   LongErrorMsg[1] := 'Conflict with ENTRY declare\0';
   LongErrorMsg[2] := 'Duplicate declaration\0';
   LongErrorMsg[3] := 'Not a procedure or function\0';
   LongErrorMsg[4] := 'Require scalar for case/select\0';
   LongErrorMsg[5] := 'Too many select expressions\0';
   LongErrorMsg[6] := 'Illegal INITIAL procedure\0';
   LongErrorMsg[7] := 'Interpreter underflow\0';
   LongErrorMsg[8] := 'Interpreter overflow\0';
   LongErrorMsg[9] := 'String constant too long\0';
   LongErrorMsg[10]:= 'String table space exceeded\0';
   LongErrorMsg[11]:= 'Bad pointer in node\0';
   LongErrorMsg[12]:= 'Proc body too large\0';
   LongErrorMsg[13]:= 'Bad 1st parm-link chain\0';
   LongErrorMsg[14]:= 'Bad 2nd parm-link chain\0';
   LongErrorMsg[15]:= 'Identifier list overflow\0';
   LongErrorMsg[16]:= 'Expression list overflow\0';
   LongErrorMsg[17]:= 'Symbol table overflow\0';
   LongErrorMsg[18]:= 'No more temps\0';
   LongErrorMsg[19]:= 'Must abort\0';
   LongErrorMsg[20]:= 'Bad pascal2\0';
   LongErrorMsg[21]:= 'Input line too long\0';
   LongErrorMsg[22]:= 'External procedures or functions must be level 1\0';
   LongErrorMsg[23]:= '''external'' or ''forward'' expected\0';
   LongErrorMsg[24]:= 'Unable to open source file\0';
   LongErrorMsg[25]:= 'Include syntax error - expected '' or "\0';
   LongErrorMsg[26]:= 'Include nesting limit exceeded\0';
   LongErrorMsg[27]:= 'Unable to open include file\0';
   LongErrorMsg[28]:= 'Unrecognized directive\0';
   LongErrorMsg[29]:= 'Failed to assign function result\0';
   LongErrorMsg[30]:= 'Backwards range in case label\0';
   LongErrorMsg[31]:= 'Duplicate case labels\0';
   LongErrorMsg[32]:= 'Unable to open object file\0';
   LongErrorMsg[33]:= 'Packed array of char expected\0';
   LongErrorMsg[34]:= 'Local variable expected\0';
   LongErrorMsg[35]:= 'Case label out of range\0';
   LongErrorMsg[36]:= 'Illegal assignment: file component in record\0';
   LongErrorMsg[37]:= 'File in type or variable not allowed\0';
   LongErrorMsg[38]:= 'Goto-statement outside this block\0';
   LongErrorMsg[39]:= 'Label defined in a structured statement\0';
   LongErrorMsg[40]:= 'Don''t use identifier "main" here\0';
   LongErrorMsg[41]:= 'Can''t compare records with variant parts\0';
   LongErrorMsg[42]:= 'Assignment to control variable not allowed\0';
   LongErrorMsg[43]:= 'PAC lower bound must be one when used as a string\0';
   LongErrorMsg[44]:= 'Character array is unpacked or lower bound <> 1\0';
   LongErrorMsg[45]:= 'Control variable could be changed\0';
   LongErrorMsg[46]:= 'Expression value out of range\0';
   LongErrorMsg[47]:= 'Cannot take succ of last element of a range\0';
   LongErrorMsg[48]:= 'Cannot take pred of first element of a range\0';
   LongErrorMsg[49]:= 'Structured type for return value not allowed\0';
                   (* '12345678901234567890123456789012345678901234567890' *)
   (* initialize short error messages *)
                     (* '12345678901234567890' *)
   ShortErrorMsg[0]  := 'Type conflict\0';
   ShortErrorMsg[1]  := 'Illegal type\0';
   ShortErrorMsg[2]  := 'Not a type\0';
   ShortErrorMsg[3]  := 'Not declared\0';
   ShortErrorMsg[4]  := 'Expression type\0';
   ShortErrorMsg[5]  := 'Too many constants\0';
   ShortErrorMsg[6]  := 'Illegal scope level\0';
   ShortErrorMsg[7]  := 'Procedure nesting\0';
   ShortErrorMsg[8]  := 'Parameter count\0';
   ShortErrorMsg[9]  := 'Inv actual parameter\0';
   ShortErrorMsg[10] := 'Array dimension\0';
   ShortErrorMsg[11] := 'Index type conflict\0';
   ShortErrorMsg[12] := 'Include error\0';
   ShortErrorMsg[13] := 'Illegal number\0';
   ShortErrorMsg[14] := 'Illegal string\0';
   ShortErrorMsg[15] := 'Illegal character\0';
   ShortErrorMsg[16] := 'Too many exports\0';
   ShortErrorMsg[17] := 'Short error 17\0';
   ShortErrorMsg[18] := 'Not a variable\0';
   ShortErrorMsg[19] := 'Not a record\0';
   ShortErrorMsg[20] := 'Illegal record field\0';
   ShortErrorMsg[21] := 'Not an array\0';
   ShortErrorMsg[22] := 'Array elem not a rec\0';
   ShortErrorMsg[23] := 'Mul array indices\0';
   ShortErrorMsg[24] := 'Subscript range\0';
   ShortErrorMsg[25] := 'Proc name long\0';
   ShortErrorMsg[26] := 'Not a procedure\0';
   ShortErrorMsg[27] := 'Not implemented\0';
   ShortErrorMsg[28] := 'Syntax error\0';
   ShortErrorMsg[29] := 'Not a pointer\0';
   ShortErrorMsg[30] := 'Invalid I/O item\0';
   ShortErrorMsg[31] := 'Text file expected\0';
   ShortErrorMsg[32] := 'File expected\0';
   ShortErrorMsg[33] := 'String expected\0';
   ShortErrorMsg[34] := 'Not a function\0';
   ShortErrorMsg[35] := 'Illegal label\0';
   ShortErrorMsg[36] := 'Duplicate label\0';
   ShortErrorMsg[37] := 'Illegal low bound\0';
   ShortErrorMsg[38] := 'String too long\0';
   ShortErrorMsg[39] := 'Illegal assignment\0';
   ShortErrorMsg[40] := 'xxxxxxxx\0';
                     (* '12345678901234567890' *)
end;

			(* EF4: 11-08-86 WB; External for error message *)
procedure error (var str: char; var mess: char;
		 a3, a4, a5: integer); external;


procedure ErrorMsg
   (ErrorNumber: integer;
    ColumnNumber: integer);

(* The error number selects the error message to be printed *)

var
   s: STRING;

begin
   ErrorCount := ErrorCount + 1;
   errpfx := 'E';
   s := '%s';
   s[2] := chr(0);
   Column := ColumnNumber;
   if ErrorNumber < 100 then
      error(s[0], ShortErrorMsg[ErrorNumber, 1], 0, 0, 0)
   else
      error(s[0], LongErrorMsg[ErrorNumber - 100, 1], 0, 0, 0);
end  (* ErrorMsg *);


procedure DclError
   (Name,
    Card,
    File,
    ErrorNumber: integer);
var
   i: integer;
   s: STRING;
begin
   ErrorCount := ErrorCount + 1;
   GetString (Name, s [0]);

   writeln (output);
   writeln (output, Card:1, '	', s:GetStringLength (Name));
   writeln (output, Card:1, '	^');
   GetString (File, s [0]);
   write (output, s:GetStringLength (File), ' : ', Card:1, ' E: ');
   if ErrorNumber < 100 then begin
      writeln (output, ShortErrorMsg [ErrorNumber]);
   end
   else begin
      writeln (output, LongErrorMsg [ErrorNumber - 100]);
   end;
   flush (output);  (* empty buffer *)
end;


procedure werror;

var
   len: integer;

begin
   len := 0;
   while (message [len] <> chr (0)) do
      len := len + 1;
   writeln (output);
   writeln (output, 'warning: ', message:len);
   flush (output);
end;


procedure FatalErrorMsg
   (ErrorNumber: integer;
    ColumnNumber: integer);

begin
   ErrorMsg (ErrorNumber, ColumnNumber);
   sql__exit (1);
end  (* FatalErrorMsg *);

procedure WarnStrCmp(lno : integer);

var
   s: STRING;
begin
   GetString (CurrentFile, s [0]);
   writeln (output, s:GetStringLength(CurrentFile), ': ', lno:1,
      ': warning: comparison of strings with different lengths');
end;
