#!/usr/bin/perl

# 2002-10-31: Version 0.1 by d038447
# (c) SAP AG

#####################################################################
# use-Area
#####################################################################
BEGIN {
	push(@INC, "/devtool/local/bin");
	push(@INC, "/devtool/TOOL/tool/bin");
	push(@INC, "/devtool/TOOL/tool/lib/perl5");
}

use strict;
use Sys::Hostname;
use Net::SMTP;
use Perforce::P4Admin;
use Perforce::P4Info;
use Perforce::P4Sync;
#use Mail::Sendmail;

#####################################################################

$ENV{'P4PORT'}	= 'perforce3006:3006';
$ENV{'PATH'}	= $ENV{'PATH'} . ":/usr/local/bin";

my $P4Port = "perforce5001.wdf.sap.corp:5001";
my $P4User = "remuser";
my $P4Client = mktemp();
my $DestDir  = ($^O =~ /Win32/i) ? "D:\\SAP_DB\\TESTDB\\tests" : "/SAP_DB/TESTDB/tests";
my $SvrPath  = "//prodprojects/vmake/dev/src/_tools/maketools/sys/src/QATools/tests/...";
my @view     = ("$SvrPath //$P4Client/...");
my $hostname = hostname();
my $highPri = 0;
my $mailtext = "";

print "Creating Perforce client..";
if (P4SetClient($P4Port, $P4Client, "$DestDir", $P4User, undef, undef, undef, \@view)) {
    print "..OK\n";
} else {
    print "..FAILED ($P4Client)!\n\nCannt continue without P4Client -> Exiting...\n";
    exit(1);
}

print "Getting change list..";
my $chlist = P4GetChangeList($P4Port, $P4User, "$SvrPath");
if ($chlist) {
    print "..OK\n";
} else {
    print "..FAILED!\n";
    CleanExit(1);
}

print "Retrieving files..";
if (P4Sync($P4Port, $P4User, $P4Client, $SvrPath, $chlist)) {
    print "..OK\n";
} else {
    print "..FAILED!\n";
    CleanExit(1);
}

&doCmd("rm -f /SAP_DB/TESTDB/testdb.p?");
&doCmd("rm -f /SAP_DB/TESTDB/tp2.pl");
&doCmd("rm -f /SAP_DB/TESTDB/wisconsin.pl");
&doCmd("cp /SAP_DB/TESTDB/tests/testdb.p? /SAP_DB/TESTDB/tests/tp2.pl /SAP_DB/TESTDB/tests/wisconsin.pl /SAP_DB/TESTDB");
&doCmd("perl -c /SAP_DB/TESTDB/testdb.pl");
&doCmd("perl -c /SAP_DB/TESTDB/testdb.pm");
&doCmd("perl -c /SAP_DB/TESTDB/tp2.pl");
&doCmd("perl -c /SAP_DB/TESTDB/wisconsin.pl");
if ($^O !~ /Win32/i)
{
    &doCmd("cp /SAP_DB/TESTDB/chr_run.sh /SAP_DB/TESTDB/_chr_run.bak");
    &doCmd("rm -f /SAP_DB/TESTDB/chr_*");
    &doCmd("cp /SAP_DB/TESTDB/tests/chr_* /SAP_DB/TESTDB");
    my $chrrun_found = 0;
    if (opendir (DIR, "/SAP_DB/TESTDB"))
    {
        my @chrs = grep { /chr_.*/ } readdir(DIR);
        closedir (DIR);
        foreach my $chrfile (@chrs)
        {
            if ($chrfile =~ /chr_run\.sh/)
            {
                $chrrun_found = 1;
            }
            &doCmd("perl -c /SAP_DB/TESTDB/$chrfile");
        }
    }
    
    &doCmd("mv /SAP_DB/TESTDB/_chr_run.bak /SAP_DB/TESTDB/chr_run.sh") unless ($chrrun_found);
}

CleanExit(0);

sub doCmd {
	my $cmd = pop (@_);
	open (CMDOUT, "$cmd |");

	my @cmdoutput = <CMDOUT>;
	close (CMDOUT);
	
	my $retval = ($? >> 8);
	
	if ($retval != 0) {
		$highPri = 1;
	}
	
	$mailtext .= "########################################\n$cmd \n";
	$mailtext .= "Return-Value = $retval \n";
	foreach my $x (@cmdoutput) {
		chomp $x;
		$mailtext .= ($x . "\n");
	}
}

sub mktemp
{
    my @time = localtime(time);
    
    return "QATOOL_$time[0]$time[1]$time[2]$time[3]$time[4]$time[5]";
}

sub CleanExit
{
    my ($rc) = @_;
    
    print "Removing P4Client..";
    if (P4RemClient($P4Port, $P4Client))
    {
        print "..OK\n";
    }
    else
    {
        print "..FAILED!\n";
    }

	my $smtp = Net::SMTP->new("mail.sap.corp");
	
	$smtp->mail("remuser\@${hostname}.sap.corp");
	$smtp->to("falko.flessner\@sap.com,ulrich.jansen\@sap.com");
	$smtp->data();
	$smtp->datasend("To: falko.flessner\@sap.com,ulrich.jansen\@sap.com\n");
	$smtp->datasend("Subject: getCtrl-Run on ${hostname} \n");
	if ($highPri == 1) {
		$smtp->datasend("Priority: Urgent\nX-Priority: 1 (Highest)\n");
	}
	$smtp->datasend("\n");
	$smtp->datasend($mailtext);
	$smtp->dataend();
	$smtp->quit;

    exit($rc);
}

