/*
 * Calculate and display Pascal's Triangle.
 *
 * Copyright (C) 2004 George Gesslein II.
 *
 * Usage: matho-pascal [number-of-lines]
 */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <errno.h>
#include <math.h>
#include <assert.h>
#include <sys/ioctl.h>
#include <termios.h>

#define	true	1
#define	false	0

#define	MAX_LINES	1000
#define	CELL_SIZE	6

int		lines = 20;
double		*array[MAX_LINES];
int		screen_columns = 80;
int		centered = true;

char	*prog_name;

main(int argc, char *argv[])
{
	int	i, j, k;
	int	i1;
	char	buf[1000];
	char	buf2[100];
	struct winsize	ws;

	prog_name = argv[0];
	ws.ws_col = 0;
	ws.ws_row = 0;
	ioctl(1, TIOCGWINSZ, &ws);
	if (ws.ws_col) {
		screen_columns = ws.ws_col;
	}
	if (argc == 2) {
		centered = false;
		lines = atoi(argv[1]);
	} else if (argc != 1) {
		fprintf(stderr, "Too many arguments.\n");
		fprintf(stderr, "Usage: %s [number-of-lines]\n", prog_name);
		exit(1);
	}
	if (lines <= 0 || lines > MAX_LINES) {
		fprintf(stderr, "Number of lines out of range.  Max = %d\n", MAX_LINES);
		exit(1);
	}
	for (i = 0; i < lines; i++) {
		array[i] = (double *) malloc(sizeof(double) * lines);
	}
	for (i = 0; i < lines; i++) {
		for (j = 0; j <= i; j++) {
			if (j == 0 || j == i) {
				array[i][j] = 1;
			} else {
				array[i][j] = array[i-1][j-1] + array[i-1][j];
			}
		}
		if (centered) {
			buf[0] = '\0';
			for (j = 0; j <= i; j++) {
				sprintf(buf2, "%.14g", array[i][j]);
				/* first center in the cell */
				for (k = i1 = (CELL_SIZE - strlen(buf2)) / 2; k > 0; k--) {
					strcat(buf, " ");
				}
				strcat(buf, buf2);
				for (k = strlen(buf2) + i1; k < CELL_SIZE; k++) {
					strcat(buf, " ");
				}
			}
			/* now center on the screen */
			if (strlen(buf) >= screen_columns) {
				break;	/* stop here because of wrap-around */
			}
			for (j = (screen_columns - strlen(buf)) / 2; j > 0; j--) {
				printf(" ");
			}
			printf("%s", buf);
		} else {
			for (j = 0; j <= i; j++) {
				printf("%.14g ", array[i][j]);
			}
		}
		printf("\n");
	}
	exit(0);
}
