/***************************************************************************
 $RCSfile: limit.cpp,v $
 -------------------
 cvs         : $Id: limit.cpp,v 1.3 2003/06/04 10:50:33 cstim Exp $
 begin       : Fri Jan 17 2003
 copyright   : (C) 2003 by Fabian Kaiser
 email       : fabian@openhbci.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "assert.h"

#ifdef __declspec
# if BUILDING_DLL
#  define DLLIMPORT __declspec (dllexport)
# else /* Not BUILDING_DLL */
#  define DLLIMPORT __declspec (dllimport)
# endif /* Not BUILDING_DLL */
#else
# define DLLIMPORT
#endif

#include "limit.h"

namespace HBCI {
   
  Limit::Limit(const Value &limitValue, LimitType type, int days) :
	_limitType(type),
	_limitValue(limitValue),
    _limitDays(days) {
  }

  bool Limit::isValid() const { 
	return (_limitValue.isValid() && (_limitType != NO_LIMIT));
  }

  LimitType Limit::typeFromChar(char type_char) 
  {
    LimitType type;

    switch (type_char) 
      {
      case 'T': type = LIMIT_DAY;
	break;
      case 'E': type = LIMIT_JOB;
	break;
      case 'W': type = LIMIT_WEEK;
	break;
      case 'M': type = LIMIT_MONTH;
	break;
      case 'Z': type = LIMIT_TIME;
	break;
      default: type = NO_LIMIT;
	break;
      }
    return type;
  }

  char Limit::typeToChar(LimitType type_enum) 
  {
    char type;

    switch (type_enum) 
      {
      case LIMIT_DAY: type = 'T';
	break;
      case LIMIT_JOB: type = 'E';
	break;
      case LIMIT_WEEK: type = 'W';
	break;
      case LIMIT_MONTH: type = 'M';
	break;
      case LIMIT_TIME: type = 'Z';
	break;
      default: type = '\0';
	break;
      }
    return type;
  }


} // namespace HBCI


int HBCI_Limit_isValid(const HBCI_Limit *l) {
  assert(l);
  return l->isValid();
}
void HBCI_Limit_delete(HBCI_Limit *d) {
  delete d;
}
const HBCI_Value *HBCI_Limit_value(const HBCI_Limit *l)
{
  assert(l);
  return &(l->value());
}
LimitType HBCI_Limit_type(const HBCI_Limit *l)
{
  assert(l);
  return l->type();
}
int HBCI_Limit_daysForTimeLimit(const HBCI_Limit *l)
{
  assert(l);
  return l->daysForTimeLimit();
}
