/***************************************************************************
                          hbcideskey.cpp  -  description
                             -------------------
    begin                : Sat Jun 30 2001
    copyright            : (C) 2001 by fabian kaiser
    email                : fabian.kaiser@gmx.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "deskey.h"

#include <openssl/rand.h>
#include <openssl/des.h>
#include <openssl/bn.h>
#include <stdlib.h>

//#include <strstream>
//#include <sstream>

namespace HBCI {

DESKey::DESKey(string password) {
	des_cblock left, right;
	keyData = "";
	
	// transform password to 2 keys
	des_string_to_2keys(password.c_str(), &left, &right);
	
	// set the keydata
	for (int i=0; i<8; i++)
		keyData += left[i];
	for (int i=0; i<8; i++)
		keyData += right[i];	
	
}
DESKey::DESKey(){
	keyData = "";
}
DESKey::~DESKey(){
}


DESKey DESKey::createKey() {
	int result = 1;
	des_cblock nativeDESKey;
	des_key_schedule key;

	DESKey *newKey = new DESKey();
	newKey->keyData = "";
	
 	RAND_seed(getRndData(1024), 1024);

	while (result != 0) {
		des_random_key(&nativeDESKey);
		result = des_set_key_checked(&nativeDESKey, key);
	}
	for (int i=0; i<8; i++)
		newKey->keyData += nativeDESKey[i];
	
 	result = 1;
	while (result != 0) {
		des_random_key(&nativeDESKey);
		result = des_set_key_checked(&nativeDESKey, key);
	}
	for (int i=0; i<8; i++)
		newKey->keyData += nativeDESKey[i];

	return *newKey;	
}


unsigned char* DESKey::getRndData(int length) {
	unsigned char* result = new unsigned char[length];
	
	for (int i = 0; i < length; i++)
		result[i] = (unsigned char) rand();
		
	return result;
}

bool DESKey::encrypt() {
	paddWithANSIX9_23();
	return crypt(DES_ENCRYPT);
}

bool DESKey::decrypt() {
	bool success = crypt(DES_DECRYPT);
	if (success)
		unpaddWithANSIX9_23();
	return success;
}

bool DESKey::crypt(int enDeCrypt) {
	//2-key-tripple-des
	//dataToCrypt.length() % 8 has to be 0, padding/ depadding in calling method
	
	des_cblock left, right;
	keyData.copy((char*) &left,8);	
	keyData.copy((char*) &right,8,8);

	des_cblock initVector;
	des_key_schedule key1, key2;
	unsigned char source[intData.length()];
	unsigned char dest[intData.length()];
	for (unsigned int i=0; i<intData.length(); i++)
		source[i]=intData[i];
		
	des_set_key(&left, key1);
	des_set_key(&right, key2);
	for (int i=0; i<8; i++)
		initVector[i] = 0;	

	des_ede2_cbc_encrypt((unsigned char*) &source, (unsigned char*) &dest, intData.length(),
		key1, key2, &initVector, enDeCrypt);

	intData = string((const char*) &dest, intData.length());
	
	return true;
}

void DESKey::paddWithANSIX9_23() {
	//append 8-(n mod 8) counts of chr(n mod 8)
	int paddLength = 8 - (intData.length() % 8);
	string paddString = string(paddLength,(char) paddLength);
	
	intData += paddString;
}

void DESKey::unpaddWithANSIX9_23() {
	//see paddWithANSIX9_23(..)
	int paddLength = intData[intData.length() - 1];
	intData =  intData.substr(0,intData.length() - paddLength);
}

string DESKey::encryptRSAKey(RSAKey *rsaKey) {
	intData = rsaKey->toString();
	encrypt();
	return intData;
}
	
RSAKey* DESKey::decryptRSAKey(const string &encryptedKey) {
	intData = encryptedKey;
	decrypt();

		
	RSAKey *rsaKey = new RSAKey();
	rsaKey->loadDataFromString(intData);
	
	return rsaKey;
}

} // namespace HBCI
