/***************************************************************************
 $RCSfile: accountsegs.h,v $
                             -------------------
    cvs         : $Id: accountsegs.h,v 1.21 2003/05/18 03:01:14 aquamaniac Exp $
    begin       : Mon Nov 26 2001
    copyright   : (C) 2001 by Martin Preuss
    email       : openhbci@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


/*
 */


#ifndef ACCOUNTSEGS_H
#define ACCOUNTSEGS_H

#include <string>

#include <openhbci/pointer.h>
#include <openhbci/date.h>
#include <openhbci/value.h>
#include <openhbci/balance.h>
#include <openhbci/account.h>
#include <openhbci/seg.h>
#include <openhbci/transaction.h>
#include <openhbci/standingorder.h>

namespace HBCI {
/**
 * @author Martin Preuss<openhbci@aquamaniac.de> but mostly stolen from
 * Fabian Kaiser (his original version)
 */
class DLLIMPORT SEGGetBalance: public Seg {
private:
    Pointer<Account> _acc;

public:
    /**
     * Constructor.
     * A segment is created by a job (and by no one else), and the
     * job is done on someones behalf, so it is most natural that the
     * segment has to see the customer as well.
     * @param cust pointer to the customer who owns the job which
     * creates this segment.
     */
    SEGGetBalance(Pointer<Customer> cust);
    ~SEGGetBalance();

    /**
     * This method is called whenever a job is to be compiled into
     * a message, that is to be send to the server.
     * In fact the MessageBox calls "toString" on a job which in turn
     * calls this method here on all the segments which belong to that
     * job.
     * @param segnr the number of this segment in the current message
     */
    string toString(int segnr);

    /**
     * This task for this class is to get the balance of an account.
     * For this reason this class needs to know for WHICH account
     * it should get the balance.
     * @param params struct that describes the account (account number,
     * institute code etc).
     */
    void setData(Pointer<Account> params) { _acc=params;};

    /**
     * This method is not needed with this class.
     */
    bool parse(const string& segment, unsigned int pos) { return false; };

};


/**
 * @author Martin Preuss<openhbci@aquamaniac.de>
 */
class DLLIMPORT SEGBalance: public Seg {
private:
    AccountBalance _balance;

    Balance _parseBalance(string group);

public:
    SEGBalance(Pointer<Customer> cust);
    ~SEGBalance();

    string toString(int segnr) { return ""; };

    bool parse(const string& segment, unsigned int pos);
    AccountBalance getBalance() { return _balance;};

};


/**
 * @author Martin Preuss<openhbci@aquamaniac.de>
 */
class DLLIMPORT SEGSingleTransferBase: public Seg {
protected:
    Transaction _xaction;
    string _segName;
    string _segParamName;
    int _versionMin;
    int _versionMax;

public:
    SEGSingleTransferBase(Pointer<Customer> cust,
                          string segName,
                          string segParamName);
    ~SEGSingleTransferBase();

    string toString(int segnr);

    bool parse(const string& segment, unsigned int pos) { return false;};

    void setData(Transaction xa);
};




/**
 * @author Martin Preuss<openhbci@aquamaniac.de>
 */
class DLLIMPORT SEGSingleTransfer: public SEGSingleTransferBase {
public:
    SEGSingleTransfer(Pointer<Customer> cust);
    ~SEGSingleTransfer();
};


/**
 * @author Martin Preuss<openhbci@aquamaniac.de>
 */
class DLLIMPORT SEGGetTurnover: public Seg {
private:
    Pointer<Account> _acc;
    Date _fromdate;
    Date _todate;
    string _attachPoint;

public:
    SEGGetTurnover(Pointer<Customer> cust);
    ~SEGGetTurnover();

    string toString(int segnr);

    void setData(Pointer<Account> acc,
                 Date fromDate,
                 Date toDate,
		 string attachPoint = "");
};


/**
 * @author Martin Preuss<openhbci@aquamaniac.de>
 */
class DLLIMPORT SEGDebitNote: public SEGSingleTransferBase {
public:
    SEGDebitNote(Pointer<Customer> cust);
    ~SEGDebitNote();

};


/**
 * @author Fabian Kaiser<openhbci@derzach.de>
 */
class DLLIMPORT SEGGetStandingOrders: public Seg {
private:
    Pointer<Account> _acc;
    string _attachPoint;

public:
    SEGGetStandingOrders(Pointer<Customer> cust);
    ~SEGGetStandingOrders();

    string toString(int segnr);

    /**
     * @param account The account for which the standing orders should
     * be retrieved
     * @param attachPoint 
     */
    void setData(Pointer<Account> account, string attachPoint="");

    /**
     * Extract the returned data
     */
    bool parse(const string& segment, unsigned int pos);
};

/**
 * @author Fabian Kaiser<openhbci@derzach.de>
 */
class DLLIMPORT SEGStandingOrder: public Seg {
public:
    string _myInstituteCode;
	int _myCountryCode;
	string _myAccountNumber;
	string _myAccountSuffix;
	string _recInstituteCode;
	int _recCountryCode;
	string _recAccountNumber;
	string _recAccountSuffix;
	string _recName1;
	string _recName2;
	Value _value;
	string _textKey1;
	string _textKey2;
	list<string> _purpose;
	Date _date;
	string _jobId;
	// details
	Date _firstExecution;
	Date _lastExecution;
	bool _monthly;
	int _cycle;
	int _execDay;


    SEGStandingOrder(Pointer<Customer> cust);
	SEGStandingOrder();
    ~SEGStandingOrder();

    string toString(int segnr, const string& segId);

	/**
	 * Extract the returned data
	 */
    bool parse(const string& segment, unsigned int pos);

	/**
	 * 
	 */
    Pointer<StandingOrder> getOrder();
};

} /* namespace HBCI */
#endif



