# $Id: qt2.m4,v 1.9 2003/03/31 01:49:44 aquamaniac Exp $
# (c) 2002 Martin Preuss<martin@libchipcard.de>
# These functions search for QT 2


AC_DEFUN(AQ_CHECK_QT2,[
dnl PREREQUISITES:
dnl   AQ_CHECK_OS must be called before this
dnl IN: 
dnl   $1 = "yes" if QT2 is needed, "no" if QT2 is optional
dnl   $2 = subdirs to include when QT2 is available
dnl   You may preset the return variables.
dnl   All variables which already have a value will not be altered
dnl OUT:
dnl   Variables:
dnl     have_qt2 - set to "yes" if QT2 exists
dnl     qt2_includes - path to includes
dnl     qt2_libs - path to libraries
dnl     qt2_app - kde apps given as the argument to this funtion
dnl     qt2_uic - name and path of the uic tool
dnl     qt2_moc - name and path of the moc tool
dnl   Defines:
dnl     HAVE_QT2

lforce="$1"
lsd="$2"

AC_MSG_CHECKING(if QT2 is allowed)
AC_ARG_ENABLE(qt2,
  [  --enable-qt2         enable qt2 (default=yes)],
  enable_qt2="$enableval",
  enable_qt2="yes")
AC_MSG_RESULT($enable_qt2)

if test "$enable_qt2" = "no"; then
   qt2_libs=""
   qt2_includes=""
   qt2_app=""
   qt2_moc=""
   qt2_uic=""
   have_qt2="no"
else


dnl paths for qt2 includes
AC_MSG_CHECKING(for qt2 includes)
AC_ARG_WITH(qt2-includes, 
  [  --with-qt2-includes=DIR      uses qt2 includes from given dir],
  [local_qt2_includes="$withval"],
  [local_qt2_includes="\
  	$QTDIR/include \
        /usr/include/qt2 \
        /usr/local/include/qt2 \
        /usr/lib/qt2/include \
        /usr/local/lib/qt2/include \
        /opt/qt2/include \
        /usr/include/qt \
        /usr/local/include/qt \
        /usr/lib/qt/include \
        /usr/local/lib/qt/include \
        /usr/include \
        /usr/local/include \
        /opt/qt/include \
        "
  ]
)

if test -z "$qt2_includes"; then
	for i in $local_qt2_includes; do
		if test -z "$qt2_includes"; then
                  if test -f "$i/qglobal.h"; then
                    lv1=`grep -h "#define QT_VERSION_STR" $i/qglobal.h`
                    case $lv1 in
                    *2.*)
                  	qt2_includes="-I$i"
                        break;
                        ;;
                    esac
                  fi
 		fi
        done
fi
if test -n "$qt2_includes"; then
	AC_MSG_RESULT($qt2_includes)
else
	AC_MSG_RESULT(not found)
fi


AC_MSG_CHECKING(if threaded qt2 may be used)
AC_ARG_ENABLE(qt2-threads,
  [  --enable-qt2-threads         enable qt2-mt library (default=yes)],
  enable_qt2_threads="$enableval",
  enable_qt2_threads="yes")
AC_MSG_RESULT($enable_qt2_threads)


dnl paths for qt2 libs
AC_MSG_CHECKING(for qt2 libraries)
AC_ARG_WITH(qt2-libs, 
  [  --with-qt2-libs=DIR      uses qt2 libs from given dir],
  [local_qt2_libs="$withval"],
  [local_qt2_libs="\
  	$QTDIR/lib \
        /usr/lib/qt2 \
        /usr/local/lib/qt2 \
        /usr/lib/qt2/lib \
        /usr/local/lib/qt2/lib \
        /opt/qt2/lib \
        /usr/lib/qt \
        /usr/local/lib/qt \
        /usr/lib/qt/lib \
        /usr/local/lib/qt/lib \
        /usr/lib \
        /usr/local/lib \
        /opt/qt/lib \
        "
  ]
)

if test "$enable_qt2_threads" != "no"; then
	if test -z "$qt2_libs"; then
		AQ_SEARCH_FOR_PATH([libqt-mt.so.2],[$local_qt2_libs])
       		if test -n "$found_dir" ; then
       			qt2_libs="-L$found_dir -lqt-mt"
       		fi
	fi
fi
if test -z "$qt2_libs"; then
 	AQ_SEARCH_FOR_PATH([libqt.so.2],[$local_qt2_libs])
     	if test -n "$found_dir" ; then
     	   qt2_libs="-L$found_dir -lqt"
       	fi
fi

if test -n "$qt2_libs"; then
	AC_MSG_RESULT($qt2_libs)
else
	AC_MSG_RESULT(not found)
fi


dnl paths for qt2 moc
AC_MSG_CHECKING(for qt2 moc)
AC_ARG_WITH(qt2-moc, 
  [  --with-qt2-moc=DIR      uses given qt2 moc],
  [local_qt2_moc="$withval"],
  [local_qt2_moc="\
  	$QTDIR/bin \
        /usr/lib/qt2/bin \
        /usr/local/lib/qt2/bin \
        /opt/qt2/bin \
        /usr/lib/qt/bin \
        /usr/local/lib/qt/bin \
        /usr/bin \
        /usr/local/bin \
        /opt/qt/bin \
        "
  ]
)
if test -z "$qt2_moc"; then
	AQ_SEARCH_FOR_PATH([moc],[$local_qt2_moc])
       	if test -n "$found_dir" ; then
       		qt2_moc="$found_dir/moc"
       	fi
fi
if test -n "$qt2_moc"; then
	AC_MSG_RESULT($qt2_moc)
else
	AC_MSG_RESULT(not found)
fi


dnl paths for qt2 uic
AC_MSG_CHECKING(for qt2 uic)
AC_ARG_WITH(qt2-uic, 
  [  --with-qt2-uic=DIR      uses given qt2 uic],
  [local_qt2_uic="$withval"],
  [local_qt2_uic="\
  	$QTDIR/bin \
        /usr/lib/qt2/bin \
        /usr/local/lib/qt2/bin \
        /opt/qt2/bin \
        /usr/lib/qt/bin \
        /usr/local/lib/qt/bin \
        /usr/bin \
        /usr/local/bin \
        /opt/qt/bin \
        "
  ]
)
if test -z "$qt2_uic"; then
	AQ_SEARCH_FOR_PATH([uic],[$local_qt2_uic])
       	if test -n "$found_dir" ; then
       		qt2_uic="$found_dir/uic"
       	fi
fi
if test -n "$qt2_uic"; then
	AC_MSG_RESULT($qt2_uic)
else
	AC_MSG_RESULT(not found)
fi


# check if all necessary qt2 components where found
if test -z "$qt2_includes" || \
   test -z "$qt2_moc" || \
   test -z "$qt2_uic" || \
   test -z "$qt2_libs"; then
	qt2_libs=""
	qt2_moc=""
	qt2_uic=""
   	qt2_includes=""
   	qt2_app=""
   	have_qt2="no"
   	if test "$lforce" = "yes"; then
        	AC_MSG_ERROR([
 Compilation of QT applications is enabled but I could not find some QT
 components (see which are missing in messages above).
 If you don't want to compile KDE applications please use "--disable-qt2".
 ])
   	else
        	AC_MSG_WARN([
 QT2 is not explicitly disabled and I could not find some QT2 components 
 (see which are missing in messages above).
 If you don't want to compile QT2 applications please use "--disable-qt2".
 ])
   	fi
else
dnl TODO: AC_TRY_RUN, check whether kdeversion.h has matching versions
   qt2_app="$lsd"
   have_qt2="yes"
   AC_DEFINE(HAVE_QT2)
fi


dnl end of if "$enable_qt2"
fi


AS_SCRUB_INCLUDE(qt2_includes)
AC_SUBST(qt2_app)
AC_SUBST(qt2_libs)
AC_SUBST(qt2_includes)
AC_SUBST(qt2_moc)
AC_SUBST(qt2_uic)

])






