/* 
 * $Id: iface.c,v 1.5 2000/08/25 19:42:31 terpstra Exp $
 *
 * libarr - a screen management toolkit
 *
 * Copyright (C) 2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Author: Chris Bond
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include "arr.h"
#include "misc.h"

/*
 * These functions (as they will be expanded to) are here to allow me to change
 * internal data structures without dynamically linked programs being affected.
 */
#define EXTERN_STRUCT_MEMBER(type, member, name)		\
                type arr_ ## name(void) {			\
			return arr_scr->member;			\
		}

EXTERN_STRUCT_MEMBER(arr_color_t, pen_color, get_col)
EXTERN_STRUCT_MEMBER(short, seek.x, get_x)
EXTERN_STRUCT_MEMBER(short, seek.y, get_y)
EXTERN_STRUCT_MEMBER(char, main[TERM_SEEK(arr_scr)].chr, get_chr)
EXTERN_STRUCT_MEMBER(short, term.co, scr_x)
EXTERN_STRUCT_MEMBER(short, term.li, scr_y)

void
arr_set_col(color)
	arr_color_t color;
{
	arr_scr->pen_color = color;
}

arr_color_t
arr_get_col_xy(x, y)
	int x, y;
{
	return arr_scr->main[((arr_scr->term.co * y) + x)].color;
}

char
arr_get_chr_xy(x, y)
	int x, y;
{
	return arr_scr->main[((arr_scr->term.co * y) + x)].chr;
}

void
arr_set_col_xy(x, y, color)
	int x, y;
	arr_color_t color;
{
	arr_scr->main[((arr_scr->term.co * y) + x)].color = color;
}

void
arr_goto_xy(x, y)
	int x, y;
{
	arr_scr->seek.x = x;
	arr_scr->seek.y = y;
}
