.TH SLARRF l "15 June 2000" "LAPACK version 3.0" ")"
.SH NAME
SLARRF - the initial representation L D L^T and its cluster of close eigenvalues (in a relative measure), W( IFIRST ), W( IFIRST+1 ), ..
.SH SYNOPSIS
.TP 19
SUBROUTINE SLARRF(
N, D, L, LD, LLD, IFIRST, ILAST, W, DPLUS,
LPLUS, WORK, IWORK, INFO )
.TP 19
.ti +4
INTEGER
IFIRST, ILAST, INFO, N
.TP 19
.ti +4
INTEGER
IWORK( * )
.TP 19
.ti +4
REAL
D( * ), DPLUS( * ), L( * ), LD( * ), LLD( * ),
LPLUS( * ), W( * ), WORK( * )
.SH PURPOSE
Given the initial representation L D L^T and its cluster of close eigenvalues (in a relative measure), W( IFIRST ), W( IFIRST+1 ), ... W( ILAST ), SLARRF finds a new relatively robust representation
L D L^T - SIGMA I = L(+) D(+) L(+)^T such that at least one of the
eigenvalues of L(+) D(+) L(+)^T is relatively isolated.
.br

.SH ARGUMENTS
.TP 8
N       (input) INTEGER
The order of the matrix.
.TP 8
D       (input) REAL array, dimension (N)
The n diagonal elements of the diagonal matrix D.
.TP 8
L       (input) REAL array, dimension (N-1)
The (n-1) subdiagonal elements of the unit bidiagonal
matrix L.
.TP 8
LD      (input) REAL array, dimension (N-1)
The n-1 elements L(i)*D(i).
.TP 8
LLD     (input) REAL array, dimension (N-1)
The n-1 elements L(i)*L(i)*D(i).
.TP 8
IFIRST  (input) INTEGER
The index of the first eigenvalue in the cluster.
.TP 8
ILAST   (input) INTEGER
The index of the last eigenvalue in the cluster.
.TP 8
W       (input/output) REAL array, dimension (N)
On input, the eigenvalues of L D L^T in ascending order.
W( IFIRST ) through W( ILAST ) form the cluster of relatively
close eigenalues.
On output, W( IFIRST ) thru' W( ILAST ) are estimates of the
corresponding eigenvalues of L(+) D(+) L(+)^T.
.TP 8
SIGMA   (input) REAL
The shift used to form L(+) D(+) L(+)^T.
.TP 8
DPLUS   (output) REAL array, dimension (N)
The n diagonal elements of the diagonal matrix D(+).
.TP 8
LPLUS   (output) REAL array, dimension (N)
The first (n-1) elements of LPLUS contain the subdiagonal
elements of the unit bidiagonal matrix L(+). LPLUS( N ) is
set to SIGMA.
.TP 8
WORK    (input) REAL array, dimension (???)
Workspace.
.SH FURTHER DETAILS
Based on contributions by
.br
   Inderjit Dhillon, IBM Almaden, USA
.br
   Osni Marques, LBNL/NERSC, USA
.br

