/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *	Ohio Trollius
 *
 *	$Log: getbuf.c,v $
 *	Revision 6.3  2002/10/09 21:00:53  brbarret
 *	* Update tree to match the latest, greatest, license for LAM/MPI.  And this
 *	  one is even done properly :)
 *
 *	Revision 6.2  1999/05/27 20:07:04  kmeyer1
 *	added copyright
 *	
 *	Revision 6.1  1996/11/24 00:35:49  nevin
 *	Ohio Release
 *	
 * Revision 6.0  96/02/29  14:06:24  gdburns
 * Ohio Release
 * 
 * Revision 5.2  94/08/22  14:17:30  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  12:58:43  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:46:50  gdburns
 * Ohio Release
 * 
 * Revision 2.2  93/05/10  16:36:24  raja
 * pre-release to 2.3
 * 
 *	We are just putting our stamp on this for housekeeping reasons.
 */

/*
 * This file is originally from dLibs 1.2 by Dale Schumacher et al.
 * It was modified for Trollius by MB, 88/12.
 * It was modified again for portability by GDB, 91/08.
 * And yet again by JRV for LAM, 93/05.
 */

#include <tstdio.h>

/*
 * external functions
 */
extern char *malloc();

void
_getbuf(fp)		/* allocate a buffer for a stream */
	register TFILE *fp;
{
	if((fp->_flag & _TIONBF)
	|| ((fp->_base = (unsigned char *)
	malloc((unsigned int) (fp->_bsiz = TBUFSIZ))) == NULL))
	{
		fp->_flag &= ~(_TIOFBF | _TIOLBF | _TIONBF);
		fp->_flag |= _TIONBF;
		fp->_base = &(fp->_ch);			/* use tiny buffer */
		fp->_bsiz = 1;
	}
	else
		fp->_flag |= _TIOMYBUF;			/* use big buffer */
	fp->_ptr = fp->_base;
	fp->_cnt = 0;		/* start out with an empty buffer */
}
