/***************************************************************************
                          wcard.cpp  -  description
                             -------------------
    begin                : Mon Nov 11 2002
    copyright            : (C) 2002 by Matthias Reif
    email                : matthias.reif@informatik.tu-chemnitz.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


//#include <linux/kernel.h>
#include <iostream.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "wcard.h"

WCard::WCard(const char *dev)
{

  ethFD = socket(AF_INET, SOCK_DGRAM, 0);

/*  pwrq = (struct iwreq*)malloc(sizeof(struct iwreq));


*/
  device = (char*)malloc(20);

  strcpy(device, dev);
  
  stats = (iwstat*)malloc(sizeof(iwstat));
  range = (iwrange*)malloc(sizeof(iwrange));


  procBuffer = (char*)malloc(100);
  

}

WCard::~WCard()
{
	free(device);
	free(procBuffer);
}

/** No descriptions */
void WCard::setDevice(const char* name)
{
  strcpy(device, name);
}

/** No descriptions */
char* WCard::getDevice()
{
  return device;
}

/** No descriptions */
int WCard::getLinkQual(int &link, int &avg, int &signal, int &noise)
{
  wrq.u.data.length = 0;
  wrq.u.data.flags = 1;
  strncpy(wrq.ifr_name, device, IFNAMSIZ);
      
  wrq.u.data.pointer = (caddr_t) stats;
  if(ioctl(ethFD , SIOCGIWSTATS, &wrq) < 0)
    return -1;

  int q = (int)stats->qual.qual;
  int s = (int)stats->qual.level;
  int n = (int)stats->qual.noise;

  wrq.u.data.pointer = (caddr_t) range;
  if(ioctl(ethFD , SIOCGIWRANGE, &wrq) < 0)
    return -1;
 
  int maxQ = (int)range->max_qual.qual;
  int maxS = (int)range->max_qual.level;
  int maxN = (int)range->max_qual.noise;

  int avgQ = (int)range->avg_qual.qual;
  
  float zw;

  zw = 100*((float)q / (float)maxQ);
  link   = (int)zw;

  avg = avgQ;

  if(link == 0)
  {
    zw = 100*((float)s / (float)maxS);
    signal = (int)zw;

    zw = 100*((float)n / (float)maxN);
    noise  = (int)zw;
  }else{
    signal = s;
    noise  = n;
  }
  
  return 0;
}

/** No descriptions */
int WCard::getNetID()
{
  strncpy(wrq.ifr_name, device, IFNAMSIZ);
  ioctl(ethFD , SIOCGIWNWID, &wrq);
  return wrq.u.nwid.value;
}

/** No descriptions */
char* WCard::getIP()
{
  struct ifreq ifrq;
  memset(&ifrq, 0, sizeof(struct ifreq));

  strcpy(ifrq.ifr_name, device);

  ioctl(ethFD, SIOCGIFADDR, &ifrq);
  
  struct sockaddr_in *addr;
  addr = (sockaddr_in*)(&ifrq.ifr_addr);

  return inet_ntoa(addr->sin_addr);
}

/** No descriptions */
int WCard::getProtocol(char *protocol)
{
  strncpy(wrq.ifr_name, device, IFNAMSIZ);
  if( ioctl(ethFD , SIOCGIWNAME, &wrq) < 0)
  {
    return -1;
  }
  else
  {
    strncpy(protocol , wrq.u.name, strlen(wrq.u.name)+1 );
    return 0;
  }
}
/** No descriptions */
int WCard::getMode()
{
  strncpy(wrq.ifr_name, device, IFNAMSIZ);
  ioctl(ethFD , SIOCGIWMODE, &wrq);
  return wrq.u.mode;  
}
/** No descriptions */
int WCard::setMode(int mode)
{
  strncpy(wrq.ifr_name, device, IFNAMSIZ);
  wrq.u.mode = mode;
  ioctl(ethFD , SIOCSIWMODE, &wrq);

 return getMode();
}

/** No descriptions */
int WCard::getFreq()
{
  strncpy(wrq.ifr_name, device, IFNAMSIZ);
  if(ioctl(ethFD , SIOCGIWFREQ, &wrq)<0)
    return 0;
  else
    return wrq.u.freq.m;
}

/** No descriptions */
int WCard::getBitRate(BitRates *br, int &index)
{

  strncpy(wrq.ifr_name, device, IFNAMSIZ);
  if(ioctl(ethFD , SIOCGIWRATE, &wrq) < 0)
    return -1;

  int rate = wrq.u.bitrate.value;

  strncpy(wrq.ifr_name, device, IFNAMSIZ);  
  wrq.u.data.pointer = (caddr_t) range;
  if(ioctl(ethFD , SIOCGIWRANGE, &wrq) < 0)
    return -1;

  br->num = range->num_bitrates;

  for( int i=0; i<br->num; i++)
  {
    br->bitRate[i].value = range->bitrate[i];

    if( br->bitRate[i].value == rate )
      index = i;

    int cnt = 0;
    while( (br->bitRate[i].value / 1000) >= 1 )
    {
      br->bitRate[i].value = br->bitRate[i].value / 1000;
      cnt++;
    }

    switch (cnt)
    {
			case	0: strcpy(br->bitRate[i].unit, "bps\0"); break;
			case	1: strcpy(br->bitRate[i].unit, "kbps");  break;
			case	2: strcpy(br->bitRate[i].unit, "Mbps");  break;
			case	3: strcpy(br->bitRate[i].unit, "Gbps");  break;
			case	4: strcpy(br->bitRate[i].unit, "Tbps");  break;
    }
    
  }

  return 0;

}

/** No descriptions */
int WCard::getAPMac(char *s)
{
  strncpy(wrq.ifr_name, device, IFNAMSIZ);
  if( ioctl(ethFD , SIOCGIWAP, &wrq) < 0 )
  	return -1;

  struct ether_addr *addr;
  addr = (ether_addr*)(&wrq.u.ap_addr.sa_data);

  sprintf(s, "%02X:%02X:%02X:%02X:%02X:%02X" , addr->ether_addr_octet[0], addr->ether_addr_octet[1], addr->ether_addr_octet[2], addr->ether_addr_octet[3], addr->ether_addr_octet[4], addr->ether_addr_octet[5]);

  return 0;
}

/** No descriptions */
int WCard::getChannel(int &numFreq, double &freq, char* eh, int &numChannel, int &channel)
{


  strncpy(wrq.ifr_name, device, IFNAMSIZ);
  if(ioctl(ethFD , SIOCGIWFREQ, &wrq) <0 )
    return -1;

  int m = wrq.u.freq.m;
  int e = wrq.u.freq.e;
  double freq2 = (double)wrq.u.freq.m;
  int ten = wrq.u.freq.e;
  int index = wrq.u.freq.i;

   
  while( ten > 0 )
  {
    freq2 = freq2 * 10;
    ten--;
  }

  while( (freq2 / 1000) >= 1 )
  {
    freq2 = freq2 / 1000;
    ten+=3;
  }

  switch (ten)
  {
    case  0: strncpy(eh, "Hz\0",  3);  break;
    case  3: strncpy(eh, "kHz\0", 4);  break;
    case  6: strncpy(eh, "MHz\0", 4);  break;
    case  9: strncpy(eh, "GHz\0", 4);  break;
    case 12: strncpy(eh, "THz\0", 4);  break;
  }

  freq = freq2;


  wrq.u.data.pointer = (caddr_t) range;
  if(ioctl(ethFD , SIOCGIWRANGE, &wrq) < 0)
    return -1;

  numFreq = range->num_frequency;
  numChannel = range->num_channels;

  for(int i=0; i<numFreq; i++)
  {
    if( (range->freq[i].m == m) && (range->freq[i].e == e) )
    {
      channel = range->freq[i].i;
      break;
    }
  }

  return 1;
      
}
/** No descriptions */
bool WCard::isWave()
{
  strncpy(wrq.ifr_name, device, IFNAMSIZ);
  if( ioctl(ethFD , SIOCGIWNAME, &wrq) < 0)
  {
    return false;
  }
  else
  {
    return true;
  }
}
/** No descriptions */
int WCard::getTransmitPower(char *unit)
{
  strncpy(wrq.ifr_name, device, IFNAMSIZ);
  if( ioctl(ethFD , SIOCGIWTXPOW, &wrq) < 0 )
  {
    return -1;
  }else{
		if( (wrq.u.txpower.flags & IW_TXPOW_DBM) == IW_TXPOW_DBM )
		{
			strcpy(unit , "dBm\0");
		}else if((wrq.u.txpower.flags & IW_TXPOW_MWATT) == IW_TXPOW_MWATT )
		{
			strcpy(unit , "mW\0");
		}else
		{
			unit[0] = '\0';
		}
    return wrq.u.txpower.value;
  }
}

/** No descriptions */
bool WCard::getEncode(char* key)
{
  wrq.u.encoding.pointer = (caddr_t)key;
  wrq.u.encoding.length  = IW_ENCODING_TOKEN_MAX;
  wrq.u.encoding.flags   = 0;

  strncpy(wrq.ifr_name, device, IFNAMSIZ);
  if( ioctl(ethFD , SIOCGIWENCODE, &wrq) >= 0 )
  {
		if( (wrq.u.encoding.flags & IW_ENCODE_DISABLED) == IW_ENCODE_DISABLED)
		{
	    return false;
	 	}else{
			return true;
		}
  }
	return false;
}

/** No descriptions */
int WCard::getSensitivity(int &valueS, int &rangeS)
{
  strncpy(wrq.ifr_name, device, IFNAMSIZ);
  if( ioctl(ethFD , SIOCGIWSENS, &wrq) < 0 )
  {
    return -1;
  }else{
    valueS = wrq.u.sens.value;
  }

  wrq.u.data.pointer = (caddr_t) range;
  if(ioctl(ethFD , SIOCGIWRANGE, &wrq) < 0)
  {
    return -1;
  }else{
    rangeS = range->sensitivity;
  }

  return 0;
}
int WCard::setSensitivity(int value)
{
  strncpy(wrq.ifr_name, device, IFNAMSIZ);
  wrq.u.sens.value = value;
  if( ioctl(ethFD , SIOCSIWSENS, &wrq) < 0 )
  {
    return -1;
  }

  return 0;
}


/** No descriptions */
int WCard::getRTS(int &value)
{
  strncpy(wrq.ifr_name, device, IFNAMSIZ);

  if( ioctl(ethFD ,SIOCGIWRTS , &wrq) >= 0 )
  {
		value = wrq.u.rts.value;
	  return 0;
  }else{
    return -1;
	}
   
}

/** No descriptions */
bool WCard::hasLink()
{
  wrq.u.data.length = 0;
  wrq.u.data.flags = 1;
  strncpy(wrq.ifr_name, device, IFNAMSIZ);

  wrq.u.data.pointer = (caddr_t) stats;
  if(ioctl(ethFD , SIOCGIWSTATS, &wrq) < 0)
    return false;

  if( (int)stats->qual.qual > 0 )
    return true;
  else
    return false;

  return false;
}
/** No descriptions */
int WCard::setBitRate(int index)
{

  strncpy(wrq.ifr_name, device, IFNAMSIZ);
  wrq.u.data.pointer = (caddr_t) range;
  if(ioctl(ethFD , SIOCGIWRANGE, &wrq) < 0)
    return -1;

  if( index >= 0 && index < range->num_bitrates )
  {
    long value = range->bitrate[index];
    wrq.u.bitrate.value = value;
    wrq.u.bitrate.fixed = 1;
  
    if(ioctl(ethFD, SIOCSIWRATE, &wrq) < 0)
      return -1;
  }else{
    return -2;
  }

  return 0;
}

/** No descriptions */
int WCard::getESSID(char *value)
{
  wrq.u.essid.pointer = (caddr_t)value;
  wrq.u.essid.length  = IW_ENCODING_TOKEN_MAX;
  wrq.u.essid.flags   = 0;

  strncpy(wrq.ifr_name, device, IFNAMSIZ);
  if( ioctl(ethFD , SIOCGIWESSID, &wrq) >= 0 )
  {
    return 0;
  }else{
    return -1;
  }  
}

/** No descriptions */
int WCard::setESSID(const char *value)
{

	char *buffer;
	buffer = (char*)malloc(strlen(value)+1);
	strcpy(buffer , value);
  if( strlen(buffer)==0 || strncmp(buffer, "any", strlen(buffer))==0 )
  {
    buffer[0]='\0';
  }


  wrq.u.essid.pointer = (caddr_t)buffer;
  wrq.u.essid.length  = strlen(buffer)+1;
  wrq.u.essid.flags   = 1;

  strncpy(wrq.ifr_name, device, IFNAMSIZ);
  if( ioctl(ethFD , SIOCSIWESSID, &wrq) >= 0 )
  {
		free(buffer);
    return 0;
  }

	free(buffer);
  return -1;
}

/** No descriptions */
bool WCard::getTraffic(int &sent, int &recv)
{
  procFile = fopen("/proc/net/dev", "r");

	do
	{
		fgets(procBuffer, 99, procFile);
	}while( (strstr(procBuffer, device) == NULL) && (feof(procFile)==0) );

	if( feof(procFile) )
	{
		sent = -1;
		recv = -1;
	}else{

		int	rec = 0;
		int	sen = 0;
		

		for(int i = 7; i<=14; i++)
		{
			if(procBuffer[i]>='0')
			{
				rec = rec * 10;
				rec = rec + (procBuffer[i]-48);
			}
		}

		for(int i =66; i<=73; i++)
		{
			if(procBuffer[i]>='0')
			{
				sen = sen * 10;
				sen = sen + (procBuffer[i]-48);				
			}
		}

		recv = rec;
		sent = sen;

	}
	
	fclose(procFile);

	if(sent < 0)
		return false;
	else
		return true;
}
/** No descriptions */
int WCard::getNetworkID()
{

  strncpy(wrq.ifr_name, device, IFNAMSIZ);
  if(ioctl(ethFD , SIOCGIWNWID, &wrq) < 0)
    return -1;

  int id = wrq.u.nwid.value;

  return id;
}
/** No descriptions */
int WCard::getNickName(char *name)
{
  wrq.u.data.pointer = (caddr_t)name;
  wrq.u.data.flags   = 0;

  strncpy(wrq.ifr_name, device, IFNAMSIZ);
  if( ioctl(ethFD , SIOCGIWNICKN, &wrq) >= 0 )
  {
    return 0;
  }else{
    return -1;
  }
	
}
/** No descriptions */
int WCard::getRetryLimit(int &value)
{
  strncpy(wrq.ifr_name, device, IFNAMSIZ);
  if( ioctl(ethFD , SIOCGIWRETRY, &wrq) >= 0 )
  {
		value = wrq.u.retry.value;
    return 0;
  }else{
    return -1;
  }
	
}
