/***************************************************************************
                          clientsidemap.cpp  -  description
                             -------------------
    begin                : Mon Jul 8 2002
    copyright            : (C) 2002 by Colin Desmond
    email                : colin.desmond@btopenworld.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _CLIENTSIDEMAP_H_
#include "clientsidemap.h"
#endif

#include <qstring.h>
#include <qfile.h>
#include <qregexp.h>
#include <qtextstream.h>

#include <iostream>
using namespace std;

//This class maps a Server Side Image Map onto a
//Client Side Image Map
ClientSideMap::ClientSideMap(QTextStream& serverSideMap, QFile& file, const QString& tempDir)
{
	QByteArray map;
	QTextOStream stream (map);

	stream << "<HTML><BODY>" << endl;
	stream << "<IMG SRC=\"" << tempDir << "graphViz.jpg" <<"\" USEMAP=\"#kprof\">" << endl;

	stream << "<MAP NAME=\"kprof\">" << endl;

	QString line;
	serverSideMap.setEncoding(QTextStream::Latin1);

	QString shape;
	QString name;
	QString coordOne;
	QString coordTwo;
	QString N;
	QString E;
	QString S;
	QString W;

	line = serverSideMap.readLine();   //first line is a comment
	line = serverSideMap.readLine();   //second line is redundant
	line = serverSideMap.readLine();   //third line is a comment
	
	while (!serverSideMap.eof())
	{
		line = serverSideMap.readLine();
		if (line.length() && line[0] != 35)
		{
			int beginPos = line.find(" ", 0);
			int endPos = line.find(".html", 0);
			QString goodName = line.mid(beginPos+1, endPos-beginPos);
			goodName =goodName.replace(QRegExp(" "), "_");
			goodName.append("html");
			
			line = line.replace( QRegExp(" \\["), "[" );
			line = line.replace( QRegExp(" del"), "_del");
			line = line.replace( QRegExp(", "), ",");
			line = line.replace( QRegExp("( "), "(");
			line = line.replace( QRegExp(") "), ")");
			
			shape = line.section(' ', 0,0);        //First element is the shape of the object
			name = line. section('.html',1,1);        //Second is the name of the file to be referenced
			coordOne = line.section(' ',-2,-2);  //Third is the first coordinate
			coordTwo = line.section(' ',-1,-1); //Fourth is the last coordinate
			N = coordOne.section(',',0,0);
			W = coordOne.section(',',1,1);
			S = coordTwo.section(',',0,0);
			E = coordTwo.section(',',1,1);
			stream << "<AREA SHAPE=\"RECT\" COORDS = \"" << N << "," << W << "," << S << "," << E << "\" HREF = \"" << goodName << "\" />" << endl;
		}
	}

	stream << "</MAP>" << endl;
	stream << "</BODY></HTML >" << endl;

	file.writeBlock (map);

}


