/* @(#) koalatypes.h 1.49 @(#) */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*
*	Module: Types
\***************************************************************/

#ifndef _KOALAMUD_KOALATYPES_H
#define _KOALAMUD_KOALATYPES_H "@(#) nitehawk@winghove.1ststep.net|include/koalatypes.h|20001105025140|21362 @(#)"

#include "config.h"

/* Type predefinitions */
struct TAG_PLAYER;
struct TAG_HUBSERVER;
struct TAG_CLIENTSERVER;
struct TAG_ZONESERVER;

/* Types */
typedef enum {FALSE=0, TRUE=-1} bool;

typedef enum
{
	KESUCCESS = 0x0,
	KEINVALIDOPTION = ERRKOALABASE,
	KENOGETOPT,
	KEBADPORT,
	KEBADOPT,
	KEMISSINGARG,
	KENOPROTO,
	KENONETWORK,
	KEBIND,
	KENOACCEPT,
	KENOMEM,
	KEFORK,
	KEPGROUP,
	KENOHOST,
	KENOUPLINK,
	KEINVALIDCONFIG,
	KEUNKNOWNDAEMONTYPE,
	KESELECTFAIL,
	KEBADDESCRIPTORTYPE,
	KEREADERROR,
	KEUNIMPLEMENTED,
	KEUNKNOWNMESSAGE,
	KENETFAIL,
	KENOTENOUGH,
	KEFOPEN,
	KEDBFATAL,
	KEDBMOUNTERROR,
	KECONFSECTIONNOTFOUND,
} koalaerror;

typedef struct TAG_KOALAOPTIONS
{
	unsigned verbosity;
	enum {
		DAEMON_UNKNOWN,
		DAEMON_CLIENT,
		DAEMON_ZONE,
		DAEMON_HUB
	} daemontype;
	bool spawnbackground;
	bool rebooted;
	unsigned int ticklen;
	unsigned int reportingperiod;
	char *dbrootpath;
} koalaoptions;
extern koalaoptions koptions;

typedef struct TAG_KOALASTATE
{
	unsigned int nodeid;
	enum {
		DSTATE_RUNNING,
		DSTATE_SHUTDOWN,
		DSTATE_REBOOT,
		DSTATE_REBOOTING,  // We are on the flip side of the reboot
	} running;
} koalastate;
extern koalastate kstate;

// Used in uplink message handling 
typedef struct TAG_UPLINKMSG_HEADER
{
	unsigned int messageid;
	unsigned int sourcenodeid;
	unsigned int destnodeid;	// Should be 0 if destination ID is
						// unknown to source
						// First hub that knows the destination will fill in
						// this field of the header
	unsigned short messagetype;	// See 'msgtype' enum in uplinkprotocol.h
	unsigned short messagedatalen;	// Length of the message data - Needed to
									// do a block read of the entire message
} uplinkmsg_header;


typedef struct TAG_DESCRIPTOR
{
	enum {
		DESCRIPTOR_NULL = 0,
		DESCRIPTOR_DUMMY,
		DESCRIPTOR_UNKNOWN,
		DESCRIPTOR_LISTEN,
		DESCRIPTOR_HUBSRV,
		DESCRIPTOR_ZONESRV,
		DESCRIPTOR_CLIENTSRV,
		DESCRIPTOR_PLAYER
	} type;
	/* Order is important on these.  They should start with the earliest
	 * status in the lifetime of a descriptor and proceed to the latest
	 */
	enum {
		STATUS_CONNECTING = 0x10,
		STATUS_TYPESENT = 0x20,
		STATUS_NOMINAL = 0x30,
		STATUS_DISCONNECT = 0x40,
		STATUS_CLOSE = 0x50
	} status;
	int socket;	// Socket handle
	union {
		struct TAG_CHARACTER *character;
		struct TAG_HUBSERVER *hubsrv;
		struct TAG_ZONESERVER *zonesrv;
		struct TAG_CLIENTSERVER *clientsrv;
	} data;
	unsigned int nodeid;
	char hostname[MAXHOSTNAMELEN];
	int port;
	/* Buffer data */
	struct {
		char outring[OUTRINGSIZE + 1];	/* Output buffer ring */
		int outhead;				/* Output buffer position */
		int outtail;
		char inring[INRINGSIZE + 1];	/* Input buffer ring */
		int inhead;					/* Input buffer position */
		int intail;
	} buffer;
} descriptor;
typedef descriptor *pdescriptor;

typedef struct TAG_CHARACTER
{
	pdescriptor desc;
	char *name;
	enum {
		STATE_GETNAME = 0,
		STATE_PLAYING
	} state;
	bool abbreviate;
} character;

typedef struct TAG_HUBSERVER
{
	pdescriptor desc;
	uplinkmsg_header curmsg;	// Zero msgid == no message bufferd
} hubsrvdata;

typedef struct TAG_CLIENTSERVER
{
	pdescriptor desc;
	uplinkmsg_header curmsg;	// Zero msgid == no message bufferd
} clientsrvdata;

typedef struct TAG_ZONESERVER
{
	pdescriptor desc;
	uplinkmsg_header curmsg;	// Zero msgid == no message bufferd
} zonesrvdata;

#endif
