/* ****************************************************************************
  This file is part of KMathTool

  Copyright (C) 2003 by Marco Wegner <mail@marcowegner.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */


#ifndef KMTTREEVIEW_H
#define KMTTREEVIEW_H

#include <qlistview.h>

class KMathToolModule;
class ModuleView;


class ModuleTreeItem : public QListViewItem
{
  public:
    ModuleTreeItem(QListView* parent, const QString& text);
    ModuleTreeItem(QListViewItem* parent, const QString& text);

    void setModule(KMathToolModule* module) { _module = module; }
    KMathToolModule* module( ) const { return _module; }
    void setModuleView(ModuleView* view) { _view = view; }
    ModuleView* view( ) const { return _view; }

  private:
    KMathToolModule* _module;
    ModuleView* _view;
};


class ModuleTreeView : public QListView
{
  Q_OBJECT

  public:
    ModuleTreeView(QWidget* parent, const char* name = 0);

    void createTreeItems(KMathToolModule* module);

  signals:
    void signalShowView(KMathToolModule*, ModuleView*);

  private:
    ModuleTreeItem* createGroupItems(const QStringList& groups);
    ModuleTreeItem* findChildItem(ModuleTreeItem* parent, const QString& label);

  private slots:
    void slotItemSelected(QListViewItem* item);
};

#endif // KMTTREEVIEW_H

