/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __customSize_dlg_h
#define __customSize_dlg_h

#include <kdialogbase.h>
#include "kicker.h"
class KIntNumInput;

class customSizeDialog : public KDialogBase
{ 
    Q_OBJECT

    public:
        customSizeDialog(QWidget* parent = 0, const char* name = 0);
        ~customSizeDialog();

        void setMinMax(int minSize = Kicker::MIN_DIMENSION, int maxSize = Kicker::MAX_DIMENSION);
        void setCurrentSize(int currentSize = Kicker::DEFAULT_CUSTOM_DIMENSION);

        int size();

    signals:
        void newCustomSize(int);

    protected slots:
        virtual void slotOk();
        virtual void slotApply();
        void slotChanged();

    protected:
        KIntNumInput* sizeInput;

    private:
        bool dataChanged;
};

#endif // FORM1_H
