/***************************************************************************
                          windowsettingswidget.cpp  -  description
                             -------------------
    begin                : fre mar 1 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qbuttongroup.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kconfig.h>
#include <kapplication.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "windowsettingswidget.h"
#include "kbear.h"

//-----------------------------------------------
WindowSettingsWidget::WindowSettingsWidget(QWidget *parent, const char *name )
	:	WindowSettingsBase(parent,name)
{
	readSettings();
	connect( p_childFrameRadioButton, SIGNAL( toggled( bool ) ),
			childFrameModeButtonGroup, SLOT( setEnabled( bool ) ) );
}
//-----------------------------------------------
WindowSettingsWidget::~WindowSettingsWidget(){
}
//-----------------------------------------------
void WindowSettingsWidget::setChildFrameMode( unsigned int mode ) {
	switch( mode ) {
		case KBear::Cascade:
			p_cascade->setChecked( true);break;
		case KBear::CascadeMaximized:
			p_cascadeMaximized->setChecked( true );break;
		case KBear::ExpandVertical:
			p_expandVertical->setChecked( true );break;
		case KBear::ExpandHorizontal:
			p_expandHorizontal->setChecked( true );break;
		case KBear::AnodinesTile:
			p_anodinesTile->setChecked( true );break;
		case KBear::PragmasTile:
			p_pragmasTile->setChecked( true );break;
		case KBear::TileVertically:
			p_tileVertically->setChecked( true );break;
	}
}
//-----------------------------------------------
unsigned int WindowSettingsWidget::getChildFrameMode() {
	if( p_cascade->isChecked() )
		return KBear::Cascade;
	else if( p_cascadeMaximized->isChecked() )
		return	KBear::CascadeMaximized;
	else if( p_expandVertical->isChecked() )
		return KBear::ExpandVertical;
	else if( p_expandHorizontal->isChecked() )
		return KBear::ExpandHorizontal;
	else if( p_anodinesTile->isChecked() )
		return KBear::AnodinesTile;
	else if( p_pragmasTile->isChecked() )
		return KBear::PragmasTile;
	else if( p_tileVertically->isChecked() )
		return KBear::TileVertically;

	return KBear::NoMode;
}
//-----------------------------------------------
void WindowSettingsWidget::readSettings() {
	QString oldGroup = kapp->config()->group();
	kapp->config()->setGroup("View Options");
	int tmpMdiMode = kapp->config()->readNumEntry( "MDI mode", QextMdi::ChildframeMode);
	if( tmpMdiMode== QextMdi::ToplevelMode )
		p_topLevelRadioButton->setChecked( true );
	else if( tmpMdiMode == QextMdi::ChildframeMode )
		p_childFrameRadioButton->setChecked( true );
	else
		p_tabPageRadioButton->setChecked( true );
	setChildFrameMode( kapp->config()->readUnsignedNumEntry( "ChildFrameMode", KBear::TileVertically ) );
	p_rememberPosCheckBox->setChecked(kapp->config()->readBoolEntry( "Remember Child Positions", true ) );
	p_maximizedChildFrameMode->setChecked(kapp->config()->readBoolEntry( "Maximized Childframes", false ) );
	p_useAutoChildFrameMode->setChecked( kapp->config()->readBoolEntry( "Auto ChildFrameMode", true ) );

	kapp->config()->setGroup( oldGroup );
}
//-----------------------------------------------
void WindowSettingsWidget::saveSettings() {
	QString oldGroup = kapp->config()->group();
	kapp->config()->setGroup("View Options");
	if( p_topLevelRadioButton->isChecked() )
		kapp->config()->writeEntry( "MDI mode", QextMdi::ToplevelMode);
	else if( p_childFrameRadioButton->isChecked() )
		kapp->config()->writeEntry( "MDI mode", QextMdi::ChildframeMode);
	else
		kapp->config()->writeEntry( "MDI mode", QextMdi::TabPageMode);

	kapp->config()->writeEntry( "ChildFrameMode", getChildFrameMode() );
	kapp->config()->writeEntry( "Remember Child Positions", p_rememberPosCheckBox->isChecked() );
	kapp->config()->writeEntry( "Maximized Childframes", p_maximizedChildFrameMode->isChecked() );
	kapp->config()->writeEntry( "Auto ChildFrameMode", p_useAutoChildFrameMode->isChecked() );

	kapp->config()->setGroup( oldGroup );
	kapp->config()->sync();
}
//-----------------------------------------------
#ifndef NO_INCLUDE_MOCFILES
#include "windowsettingswidget.moc"
#endif
