/***************************************************************************
                          mixedsettingswidget.h  -  description
                             -------------------
    begin                : tor feb 28 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MIXEDSETTINGSWIDGET_H
#define MIXEDSETTINGSWIDGET_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qcombobox.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <klineedit.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "base/mixedsettingsbase.h"

/**
  *@author Bjrn Sahlstrm
  */

class MixedSettingsWidget : public MixedSettingsBase {
   Q_OBJECT
public:
	/** */
	enum ViewMode {
		ReadOnly = 0,
		ReadWrite = 1,
		Ask = 2
	};
	/** */
	MixedSettingsWidget( QWidget *parent=0, const char *name=0);
	/** */
	~MixedSettingsWidget();
	/**  */
	void setDefaultEmail( const QString& email );
	/**  */
	QString defaultEmail() { return p_emailComboBox->currentText(); }
public slots:
	/** */
	void saveSettings();
protected:
	/** */
	void readSettings();
};

#endif
