/***************************************************************************
                          tokenprovider.cpp  -  description
                             -------------------
    begin                : Fre Sep 19 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "tokenprovider.h"
#include "sqltables.h"
#include "kbarcodesettings.h"

// Qt includes
#include <qdatetime.h>
#include <qpaintdevicemetrics.h>
#include <qsqlquery.h>
#include <qregexp.h>
#include <time.h>

TokenProvider::TokenProvider( QPaintDevice* paintdevice )
    : m_printer( paintdevice )
{
    m_index = 0;
    m_page = 0;
    m_update = false;
    m_contains_update = false;

    article_no =  barcode_no =  customer_no =  encoding_type_name = group = label_name = serial = QString::null;

    // Get the label time at start of labels so all labels get same time basis

    label_time = time(&label_time) ;
    localtime_r(&label_time,&label_time_struct) ;
    date_reg_exp.setPattern("\\[date:(%[a-zA-Z])\\]");
}

TokenProvider::~TokenProvider()
{
}

QString TokenProvider::parse( const QString & text )
{
    QString t = QString( text );
    for( int i = 0; i < 10; i++ ) {
        const QString c = QString("line%1").arg( i );
        if( SqlTables::isConnected() && t.contains( "["+c+"]" ) && !article_no.isEmpty() ) {
            QString ret = query( "SELECT " +  c + " FROM " + TABLE_CUSTOMER_TEXT + " WHERE article_no='" +  article_no  + "' AND customer_no='" + customer_no + "'");
            t.replace( DSREPLACE( "["+c+"]" ), ret );
        }
    }

    if( SqlTables::isConnected() && t.contains( "[article_no_customer]" ) && !article_no.isEmpty() ) {
      QString ret = query( QString("SELECT article_no_customer FROM ") + TABLE_CUSTOMER_TEXT + " WHERE article_no='" +  article_no  + "' AND customer_no='" + customer_no + "'");
      t.replace( DSREPLACE( "[article_no_customer]" ), ret );
    }

    if( SqlTables::isConnected() && t.contains( "[barcode_no_customer]" ) && !article_no.isEmpty() ) {
      QString ret = query( QString("SELECT barcode_no FROM ") + TABLE_CUSTOMER_TEXT + " WHERE article_no='" +  article_no  + "' AND customer_no='" + customer_no + "'");
      t.replace( DSREPLACE( "[barcode_no_customer]" ), ret );
    }

    for( int i = 0; i < 10; i++ ) {
        const QString c = QString("field%1").arg( i );
        if( SqlTables::isConnected() && t.contains( "["+c+"]" ) && !article_no.isEmpty() ) {
            QString ret = query("SELECT " + c + " FROM " + TABLE_BASIC + " WHERE article_no='" +  article_no  + "'");
            t.replace( DSREPLACE( "["+c+"]" ), ret );
        }
    }

    if( SqlTables::isConnected() && t.contains( "[article_desc]" ) && !article_no.isEmpty() )
        t.replace( DSREPLACE( "[article_desc]" ), query( QString("SELECT article_desc FROM ") + TABLE_BASIC  + " WHERE article_no='" +  article_no  + "'") );

    if( !article_no.isEmpty() )
        t.replace( DSREPLACE( "[article_no]" ), article_no );

    if( !customer_no.isEmpty() )
        t.replace( DSREPLACE( "[customer_no]" ), customer_no );

    if( SqlTables::isConnected() && t.contains( "[customer_name]" ) && !customer_no.isEmpty() )
        t.replace( DSREPLACE( "[customer_name]" ), query( QString("SELECT customer_name  FROM ") + TABLE_CUSTOMER + " WHERE customer_no='" +  customer_no  + "'") );

    if( !barcode_no.isEmpty() )
        t.replace( DSREPLACE( "[barcode_no]" ), barcode_no );

    if( SqlTables::isConnected() && t.contains( "[barcode_no_basic]" ) && !article_no.isEmpty() )
        t.replace( DSREPLACE( "[barcode_no_basic]" ), query( QString("SELECT barcode_no FROM ") + TABLE_BASIC  + " WHERE article_no='" +  article_no  + "'") );

    if( !group.isEmpty() )
        t.replace( DSREPLACE( "[group]" ), group );

    if( !encoding_type_name.isEmpty() )
        t.replace( DSREPLACE( "[encoding_type]" ), encoding_type_name);

    if( !label_name.isEmpty() )
        t.replace( DSREPLACE( "[filename]" ), label_name );

    if( t.contains( "[date]" ) )
        t.replace( DSREPLACE( "[date]" ), QDateTime::currentDateTime().toString( KBarcodeSettings::getDateFormat() ) );

    while(date_reg_exp.search(t,0) != -1) {
        strftime(temp_time_str,sizeof temp_time_str - 1, date_reg_exp.cap(1).ascii(),&label_time_struct) ;
        t.replace( DSREPLACE( date_reg_exp.cap(0) ), QString::QString( temp_time_str));
    }

    if( t.contains( "[index]" ) ) {
        m_contains_update = true;
        t.replace( DSREPLACE( "[index]" ), QString::number( m_index + 1 ) );
    }

    if( t.contains( "[page]" ) ) {
        m_contains_update = true;
        t.replace( DSREPLACE( "[page]" ), QString::number( m_page + 1 ) );
    }

    if( t.contains( "[resolution]" ) ) {
        QPaintDeviceMetrics metrics( m_printer );
        int res = metrics.logicalDpiY();
        t.replace( DSREPLACE( "[resolution]" ), QString( "%1dpi" ).arg( res ) );
    }

    if( !serial.isEmpty() && t.contains( "[serial]" ) ) {
        m_contains_update = true;
        t.replace( DSREPLACE( "[serial]" ), createSerial() );
    }

    return t;
}


QString TokenProvider::query( const QString & query )
{
    QSqlQuery q( query );
    while( q.next() )
        return q.value( 0 ).toString();

    return QString::null;
}

const QString TokenProvider::createSerial()
{
    unsigned long tmp;
    QString s = QString::null;
    // Split string into prenum, number and postnum parts
    QRegExp splitit("(\\D*)(\\d+)(.*)");
    int pos = splitit.search(serial);

    // Is there anything to increment ?
    if (pos > -1) {
        QString prenum = splitit.cap(1);

        tmp = splitit.cap(2).toULong();
        QString postnum = splitit.cap(3);
        tmp += (m_increment*m_index);
        QString tmpstr;
        tmpstr.setNum(splitit.cap(2).length());
        QString formatstring = "%0" + tmpstr + "lu";

        s = prenum + tmpstr.sprintf(formatstring, tmp) + postnum;
        m_update = true;
    }

    return s;
}
