/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.gnu.gnomevfs;

import org.gnu.glib.GObject;

/**
 * Contains information about a file.
 */
public class VFSFileInfo extends GObject {
	
	VFSFileInfo(int handle) {
		setHandle(handle);
	}

	/****************************************
     * BEGINNING OF JNI CODE
     ****************************************/
	native static final protected int gnome_vfs_file_info_new();
	native static final protected String getName(int handle);
	native static final protected int getValidFields(int handle);
	native static final protected int getFileType(int handle);
	native static final protected int getFilePermissions(int handle);
	native static final protected int getFileFlags(int handle);
	native static final protected int getFileSize(int handle);
	native static final protected int getBlockCount(int handle);
	native static final protected String getMimeType(int handle);
	native static final protected String getSymlinkName(int handle);
	native static final protected long getAtime(int handle);
	native static final protected long getCtime(int handle);
	native static final protected long getMtime(int handle);
    /****************************************
     * END OF JNI CODE
     ****************************************/
}
