<?php
#    IRM - The Information Resource Manager
#    Copyright (C) 1999 Yann Ramin
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License (in file COPYING) for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
################################################################################

include("../include/irm.inc");
require_once 'include/i18n.php';

AuthCheck("post-only");

commonHeader(_("Tracking") ." - " . _("More Information"));
PRINT "<a href=\"".$_SESSION['_sess_prevpage']."\">";
__("Go Back");
PRINT "</a><hr noshade><br>";

PRINT "<FORM METHOD=POST ACTION=\"tracking-update.php\">\n";
$track = new Tracking($ID);

// Is the current user authorised to modify tracking items?
$curuser = new User($_SESSION['_sess_username']);
$readonly = !$curuser->permissionCheck('tech');
$track->displayDetail($readonly);
PRINT "<table border=1 width=100%><tr><th>";
__("Knowledge Base System");
PRINT "</th></tr>";
PRINT "<tr bgcolor=#DDDDDD><td><input type=checkbox name=addtoknowledgebase value=yes>";
__("If tracking is marked as complete, should it be used to add something to the knowledgebase?");
PRINT "</td></tr>\n";
PRINT "</table>";
PRINT "<INPUT TYPE=hidden NAME=tID VALUE=$ID>";
PRINT "<INPUT TYPE=SUBMIT VALUE=\""._("Update Tracking")."\"><BR>\n";
PRINT "</form>";
PRINT "<br>";
commonFooter();
