<?php
#    IRM - The Information Resource Manager
#    Copyright (C) 1999 Yann Ramin
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License (in file COPYING) for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
################################################################################

include("../include/irm.inc");
require_once 'lib/Config.php';
require_once 'include/i18n.php';

AuthCheck("tech");
if (@$flags_server == "yes") 
{
	$flags_server = 1;
} else 
{
	$flags_server = 0;
}

if (@$flags_surplus == "yes")
{
        $flags_surplus = 1;
   } else
       {
        $flags_surplus = 0;
}

$DB = Config::Database();

if ($reqID)
{
	if (!preg_match('/^\d+$/', $reqID))
	{
		commonHeader(_("Error"));
		__("ERROR: Requested IDs can only contain digits.  Please re-enter your requested IRM ID");
		commonFooter();
		exit();
	}
	
	$qreqID = $DB->getTextValue($reqID);
	$query = "SELECT COUNT(ID) FROM computers WHERE (ID = $qreqID)";
	if ($DB->getOne($query) == 0) 
	{
		$ID = $reqID;
		$DB->query("INSERT INTO computers__ID (sequence) VALUES ($qreqID)");
		$DB->query("DELETE FROM computers__ID WHERE sequence < $qreqID");
	} else 
	{
		commonHeader(_("Error"));
		printf(_("A computer with ID %s already exists.  Please pick a new ID"), $reqID);
		commonFooter();
		exit();
	}
}

if ($reqID == 0) 
{
	$ID = $DB->_dbh->nextId('computers__ID');
}	

$vals = array(
	'ID' => $ID,
	'name' => $name,
	'type' => $type,
	'flags_server' => $flags_server,
	'flags_surplus' => $flags_surplus,
	'os' => $os,
	'osver' => $osver,
	'processor' => $processor,
	'processor_speed' => $processor_speed,
	'location' => $location,
	'serial' => $serial,
	'otherserial' => $otherserial,
	'ramtype' => $ramtype,
	'ram' => $ram,
	'network' => $network,
	'ip' => $ip,
	'mac' => $mac,
	'hdspace' => $hdspace,
	'contact' => $contact,
	'contact_num' => $contact_num,
	'comments' => $comments,
	'date_mod' => $date_mod
	);

$DB->InsertQuery('computers', $vals);
	
logevent($ID, _("computers"), 4, _("database"), sprintf(_('%s added record'), $IRMName)); 

if ($iface_do == "yes") 
{
	$vals = array(
		'device_on' => $ID,
		'device_type' => 1,
		'iface' => $iface,
		'ifaddr' => $ip,
		'ifmac' => $mac,
		'logical_number' => 1,
		'name' => 'Port 1'
		);
	$DB->InsertQuery('networking_ports', $vals);
}

$qtemplID = $DB->getTextValue($templID);
$query = "SELECT * FROM templ_inst_software WHERE (cID = $qtemplID)";
$data = $DB->getAll($query);

foreach ($data as $result)
{
	$vals = array(
		'sID' => $result['sID'],
		'cID' => $ID
		);
	$DB->InsertQuery('inst_software', $vals);
}

$newloc = appendURLArguments($_SESSION['_sess_prevpage'], array('add' => 1));
header("Location: $newloc");

printf(_("Redirecting to %s\n"), $newloc);
