<?php
#    IRM - The Information Resource Manager
#    Copyright (C) 2003 Yann Ramin
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License (in file COPYING) for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
################################################################################

require_once 'include/i18n.php';
require_once 'lib/Config.php';
require_once 'lib/Databases.php';

function make_dblist()
{
	$dblist = Databases::All();

	if (count($dblist) > 1)
	{
		print '<br>'._('Database: ');
		print '<select name="dbuse" size="1">';  
		foreach ($dblist as $k => $d) {    
			print '<option value="'.$k.'">'.$d.'</option>';
		}
		print "</select>"; 
	}
	else if (count($dblist) == 1)
	{
		$f = array_keys($dblist);
		print '<input type="hidden" name="dbuse" value="'.$f[0].'">';
	}
	else
	{
		trigger_error(_("There are no defined databases"), E_USER_ERROR);
	}
}

################################################################################
?>
<HTML><HEAD><TITLE><?php __('IRM - The Information Resource Manager') ?></TITLE>
</HEAD>
<BODY BGCOLOR="#FFFFFF" onload="document.login.name.focus()">
<FONT FACE="Arial, Helvetica">
<img src="irm-jr1.jpg">
<br>
  

<table border="0">
<tr>
<td valign='top'><h3><?php __('IRM Login') ?></h3>
<?php
switch (@$_REQUEST['auth'])
{
	case 'fail':
		echo "<p><b>"._('Incorrect username or password')."</b>";
		break;
	
	case 'sess':
		echo "<p><b>"._('Session expired')."</b>";
		break;
}
?>
<form method="post" action="login.php" name="login">
<?php __('Username') ?>: <input type="text" name="name" value="">
<br><?php __('Password:') ?> <input type="password" name="password" value="">
<br>
<?php make_dblist(); ?>

<br>
<?php if (@$_REQUEST['redirect'])
{
	echo '<input type="hidden" name="redirect" value="'.$_REQUEST['redirect'].'">';
}
?>
<input type="submit" value="<?php __("Login") ?>">
</form>
<br><br>
</td>
<td>
<h3><?php __('Introduction to IRM') ?></h3>
<p><?php __('IRM is a multi-user computer, software, peripheral and problem tracking system.');
__('You can use IRM, depending on your user-level, to view, edit, and add
computer systems to a database with an extensive list of fields.  You can
also view and post jobs if you have a problem with a computing resource.'); ?></p>

<h4><?php __('Frequently Asked Questions') ?></h4>
<p><?php __('Helpdesk personel get many questions - many of which are
repeated many times. A FAQ, which is a list of frequently asked questions -
and their answers, intends to provide a quick and easy way to help you get
an answer to a questions. If your query isn\'t in this list, feel free to
post a request for help.'); ?>
<form method=post action=login.php>

<?php make_dblist(); ?>

<input type="hidden" name="name" value="IRMConnect">
<input type="hidden" name="redirect" value="users/faq-index.php">
<input type=submit value="<?php __('Read FAQ'); ?>"></form>

<h4><?php __('Request Help'); ?></h4>

<?php __('You can request help without logging in to IRM. To do this you
need to select the appropriate department, click the <b>Help</b> button
below and then follow the instructions. Your request will be filed under the
user name of <b>guest</b> so you will need to ensure that the contact
information is correct if you wish to recieve updates and keep in touch with
the helpdesk.'); ?>

<form method=post action=login.php>

<?php make_dblist(); ?>

<input type="hidden" name="name" value="IRMConnect">
<input type=submit value="<?php __('Request Help') ?>"></form>
</td>
</tr>
</table></form>
<hr width="50%">
<P><?php __(sprintf("More information can be found at %s the IRM website %s",
			'<a href="http://www.stackworks.net/irm/">',
			'</a>')); ?>
</P>
<br>   
</BODY>
</HTML>
