-- Creates scratchpads on a per clientwin basis.

-- I realized that sometimes it might be useful to have a scratchpad for
-- notes and things for only one cwin, and not just globally.

-- This script creates a binding for CTRL-MOD1-"space" to create/toggle the
-- per-cwin scratchpads and sets up MOD1-"space" to toggle the default one.
-- It assumes that the default scratchpad will be the only scratchpad that
-- exists other than the ones this script creates.
-- If you create your own scratchpads I would suggest you either name themr
-- foo_sp (which will cause this script to grab them, but won't really matter)
-- or that you add logic to find_sps to ignore your scratchpads.

local sps = {}

function make_cwin_sp(frame, cwin)
	local g = {}
	local cg = {}
	local pg = {}
	local sp

	if obj_is(frame, "WScratchpad") then
		local s,e

		s,e = string.find(frame:name(), "_sp$")
		if s then
			mod_sp.toggle(frame)
		end

		return
	end

-- This is here so that if the client window changes size the
-- scratchpad for it will also.
	cg = cwin:geom()
	g.w = cg.w
	g.h = cg.h

	if obj_is(sps[cwin:name().."_sp"], "WScratchpad") then
		sp = sps[cwin:name().."_sp"]
	else

		sp = cwin:screen_of():attach_new({type='WScratchpad', layer=2, name=cwin:name().."_sp"})
		sps[cwin:name().."_sp"] = sp
	end

-- This is here so that after a restart the sp goes to where the cwin is.
-- Remove if/when I make the function in find_sps smarter.
	pg = cwin:parent():geom()
	g.x = pg.x
	g.y = cg.y - pg.y

	sp:rqgeom(g)
	mod_sp.toggle(sp)
end

local function find_sps()
-- Tuomo does this in check_and_create in mod_sp so I can do it here
	local hook

	hook = ioncore.get_hook("ioncore_post_layout_setup_hook")
	if hook then
		hook:remove(find_sps)
	end

	local spl

	spl = ioncore.region_list("WScratchpad")

-- TODO Fix this so that it finds the "parent" cwin and sizes the sp to it,
	if spl then
		table.foreach(spl, function(k, v)
			                   local s, e
			                   s, e = string.find(v:name(), "_sp$")
			                   if s then
				                   sps[v:name()] = v
			                   else
				                   if v:name() == "WScratchpad" then
					                   default_sp = v
				                   end
			                   end
			                 end)
	end
end

local function setup_hooks()
	local hook

	hook = ioncore.get_hook("ioncore_post_layout_setup_hook")
	if hook then
		hook:add(find_sps)
	end
end

-- Init
setup_hooks()

-- Bindings
defbindings("WFrame", {
	kpress(CTRL..MOD1.."space", "make_cwin_sp(_, _sub)"),
	kpress(MOD1.."space", "mod_sp.toggle(default_sp)")
})

